/*
 * Decompiled with CFR 0.152.
 */
package org.tinyradius.packet;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.tinyradius.attribute.RadiusAttribute;
import org.tinyradius.dictionary.Dictionary;
import org.tinyradius.packet.AccessRequest;
import org.tinyradius.packet.AccountingRequest;
import org.tinyradius.packet.RadiusPacket;

public class RadiusPackets {
    private static final AtomicInteger nextPacketId = new AtomicInteger();

    public static int nextPacketId() {
        return nextPacketId.updateAndGet(i -> i >= 255 ? 0 : i + 1);
    }

    public static RadiusPacket create(Dictionary dictionary, int type, int identifier) {
        return RadiusPackets.create(dictionary, type, identifier, null, new ArrayList<RadiusAttribute>());
    }

    public static RadiusPacket create(Dictionary dictionary, int type, int identifier, byte[] authenticator) {
        return RadiusPackets.create(dictionary, type, identifier, authenticator, new ArrayList<RadiusAttribute>());
    }

    public static RadiusPacket create(Dictionary dictionary, int type, int identifier, List<RadiusAttribute> attributes) {
        return RadiusPackets.create(dictionary, type, identifier, null, attributes);
    }

    public static RadiusPacket create(Dictionary dictionary, int type, int identifier, byte[] authenticator, List<RadiusAttribute> attributes) {
        switch (type) {
            case 1: {
                return new AccessRequest(dictionary, identifier, authenticator, attributes);
            }
            case 4: {
                return new AccountingRequest(dictionary, identifier, authenticator, attributes);
            }
        }
        return new RadiusPacket(dictionary, type, identifier, authenticator, attributes);
    }
}

