/*
 * Decompiled with CFR 0.152.
 */
package org.tinyradius.server.handler;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinyradius.client.RadiusClient;
import org.tinyradius.packet.RadiusPacket;
import org.tinyradius.packet.RadiusPackets;
import org.tinyradius.server.RequestCtx;
import org.tinyradius.util.RadiusEndpoint;

public abstract class ProxyHandler
extends SimpleChannelInboundHandler<RequestCtx> {
    private static final Logger logger = LoggerFactory.getLogger(ProxyHandler.class);
    private final RadiusClient radiusClient;

    public ProxyHandler(RadiusClient radiusClient) {
        this.radiusClient = radiusClient;
    }

    protected void channelRead0(ChannelHandlerContext ctx, RequestCtx msg) {
        RadiusEndpoint clientEndpoint;
        RadiusPacket request = msg.getRequest();
        Optional<RadiusEndpoint> serverEndpoint = this.getProxyServer(request, clientEndpoint = msg.getEndpoint());
        if (!serverEndpoint.isPresent()) {
            logger.info("Server not found for client proxy request, ignoring");
            return;
        }
        logger.debug("Proxying packet to {}", (Object)serverEndpoint.get().getAddress());
        this.radiusClient.communicate(request, serverEndpoint.get()).addListener(f -> {
            RadiusPacket packet = (RadiusPacket)f.getNow();
            if (f.isSuccess() && packet != null) {
                RadiusPacket response = RadiusPackets.create(request.getDictionary(), packet.getType(), packet.getIdentifier(), packet.getAttributes());
                ctx.writeAndFlush((Object)msg.withResponse(response));
            }
        });
    }

    protected abstract Optional<RadiusEndpoint> getProxyServer(RadiusPacket var1, RadiusEndpoint var2);
}

