/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.core.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonUtils {
    static Logger logger = LoggerFactory.getLogger(CommonUtils.class);

    public static String genSupperName(String name) {
        String supperName = "";
        if (name != null && !"".equals(name)) {
            supperName = name.length() == 1 ? name.toUpperCase() : name.substring(0, 1).toUpperCase() + name.substring(1);
        }
        return supperName;
    }

    public static String UpperCase(String str) {
        StringBuffer aa = new StringBuffer();
        int index = 0;
        int index22 = 0;
        int len = str.length();
        for (int i = 1; i < len; ++i) {
            if (Character.isUpperCase(str.charAt(i))) {
                if (Character.isUpperCase(str.charAt(i + 1))) {
                    aa.append(str.substring(index, i)).append("");
                } else {
                    aa.append(str.substring(index, i)).append(" ");
                }
                index = i;
                ++index22;
                continue;
            }
            index22 = 0;
        }
        aa.append(str.substring(index, len));
        return aa.toString();
    }

    public static byte[] readBytes(File file) {
        long len = file.length();
        if (len >= Integer.MAX_VALUE) {
            throw new RuntimeException("File is larger then max array size");
        }
        byte[] bytes = new byte[(int)len];
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            int readLength = in.read(bytes);
            if ((long)readLength < len) {
                throw new IOException("File length is [" + len + "] but read [" + readLength + "]!");
            }
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonUtils.closeQuiltly(in);
                throw throwable;
            }
        }
        CommonUtils.closeQuiltly(in);
        return bytes;
    }

    public static byte[] readBytes(InputStream ins) {
        if (ins == null) {
            return null;
        }
        ByteArrayOutputStream byteOutArr = new ByteArrayOutputStream();
        int r = -1;
        byte[] bytes = new byte[0x100000];
        try {
            while ((r = ins.read(bytes)) != -1) {
                byteOutArr.write(bytes, 0, r);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            CommonUtils.closeQuiltly(ins);
        }
        return byteOutArr.toByteArray();
    }

    public static void closeQuiltly(InputStream ins) {
        if (ins != null) {
            try {
                ins.close();
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void closeQuiltly(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

