/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *  _   _ ____   ___            _
 * | \ | / ___| / _ \          | |
 * |  \| \___ \| | | |_____ _  | |
 * | |\  |___) | |_| |_____| |_| |
 * |_| \_|____/ \__\_\      \___/                                           https://github.com/yingzhuo/nsq-j
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
package com.github.yingzhuo.nsqj;

import java.util.List;

/**
 * @author 应卓
 * @since 1.0.0
 */
class LookupResponse {

    private LookupResponse data; //older versions wrap responses in a "data" field
    private List<Producer> producers;

    public LookupResponse getData() {
        return data;
    }

    public void setData(LookupResponse data) {
        this.data = data;
    }

    public List<Producer> getProducers() {
        return producers;
    }

    public void setProducers(List<Producer> producers) {
        this.producers = producers;
    }

    @Override
    public String toString() {
        return "LookupResponse{" +
                "data=" + data +
                ", producers=" + producers +
                '}';
    }

    static class Producer {
        private String broadcastAddress;
        private int tcpPort;

        public String getBroadcastAddress() {
            return broadcastAddress;
        }

        public void setBroadcastAddress(String broadcastAddress) {
            this.broadcastAddress = broadcastAddress;
        }

        public int getTcpPort() {
            return tcpPort;
        }

        public void setTcpPort(int tcpPort) {
            this.tcpPort = tcpPort;
        }

        @Override
        public String toString() {
            return "Producer{" +
                    "broadcastAddress='" + broadcastAddress + '\'' +
                    ", tcpPort=" + tcpPort +
                    '}';
        }
    }
}
