/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *  _   _ ____   ___            _
 * | \ | / ___| / _ \          | |
 * |  \| \___ \| | | |_____ _  | |
 * | |\  |___) | |_| |_____| |_| |
 * |_| \_|____/ \__\_\      \___/                                           https://github.com/yingzhuo/nsq-j
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
package com.github.yingzhuo.nsqj;

import java.nio.charset.StandardCharsets;

/**
 * @author 应卓
 * @since 1.0.0
 */
public interface Message {

    String getTopic();

    byte[] getData();

    public default String getDataString() {
        return new String(getData(), StandardCharsets.UTF_8);
    }

    String getId();

    int getAttempts();

    long getTimestamp();

    void finish();

    void requeue();

    void touch();
}
