/*
 * Decompiled with CFR 0.152.
 */
package com.github.yingzhuo.nsqj;

import com.github.yingzhuo.nsqj.Publisher;
import com.github.yingzhuo.nsqj.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Batcher {
    private static final Logger log = LoggerFactory.getLogger(Batcher.class);
    private final Publisher publisher;
    private final String topic;
    private final int maxSize;
    private final int maxDelayMillis;
    private final ScheduledExecutorService executor;
    private int size;
    private List<byte[]> batch = new ArrayList<byte[]>();
    private long sendTime;

    public Batcher(Publisher publisher, String string, int n, int n2) {
        this.publisher = publisher;
        this.topic = string;
        this.maxSize = n;
        this.maxDelayMillis = n2;
        this.executor = publisher.getBatchExecutor();
        Util.checkNotNull(publisher);
        Util.checkNotNull(string);
        Util.checkArgument(n2 > 5);
        Util.checkArgument(n2 <= 60000);
        Util.checkArgument(this.maxSize > 100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(byte[] byArray) {
        boolean bl = false;
        Batcher batcher = this;
        synchronized (batcher) {
            this.batch.add(byArray);
            this.size += byArray.length;
            if (this.batch.size() == 1) {
                this.sendTime = Util.clock() + (long)this.maxDelayMillis;
                this.executor.schedule(new Runnable(){

                    @Override
                    public void run() {
                        Batcher.this.sendDelayedBatch();
                    }
                }, (long)this.maxDelayMillis, TimeUnit.MILLISECONDS);
            } else if (this.size >= this.maxSize) {
                bl = true;
            }
        }
        if (bl) {
            this.sendBatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendDelayedBatch() {
        try {
            boolean bl = false;
            Batcher batcher = this;
            synchronized (batcher) {
                if (!this.batch.isEmpty()) {
                    long l = this.sendTime - Util.clock();
                    if (l < 50L) {
                        bl = true;
                    } else {
                        this.executor.schedule(new Runnable(){

                            @Override
                            public void run() {
                                Batcher.this.sendDelayedBatch();
                            }
                        }, l, TimeUnit.MILLISECONDS);
                    }
                }
            }
            if (bl) {
                this.sendBatch();
            }
        }
        catch (Throwable throwable) {
            log.error("delayed batch error. messages possibly lost", throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendBatch() {
        List<byte[]> list = null;
        Batcher batcher = this;
        synchronized (batcher) {
            if (!this.batch.isEmpty()) {
                list = this.batch;
                int n = Math.min(this.maxSize, (int)((double)list.size() * 1.2));
                n = Math.max(10, n);
                this.batch = new ArrayList<byte[]>(n);
                this.size = 0;
            }
        }
        if (list != null) {
            this.publisher.publish(this.topic, list);
        }
    }
}

