/*
 * Decompiled with CFR 0.152.
 */
package com.github.yingzhuo.nsqj;

import com.github.yingzhuo.nsqj.Util;
import java.io.Serializable;

final class HostAndPort
implements Serializable {
    private static final int NO_PORT = -1;
    private final String host;
    private final int port;
    private final boolean hasBracketlessColons;
    private static final long serialVersionUID = 0L;

    private HostAndPort(String string, int n, boolean bl) {
        this.host = string;
        this.port = n;
        this.hasBracketlessColons = bl;
    }

    public String getHost() {
        return this.host;
    }

    @Deprecated
    public String getHostText() {
        return this.host;
    }

    public boolean hasPort() {
        return this.port >= 0;
    }

    public int getPort() {
        Util.checkState(this.hasPort(), "needs port");
        return this.port;
    }

    public int getPortOrDefault(int n) {
        return this.hasPort() ? this.port : n;
    }

    public static HostAndPort fromParts(String string, int n) {
        Util.checkArgument(HostAndPort.isValidPort(n));
        HostAndPort hostAndPort = HostAndPort.fromString(string);
        Util.checkArgument(!hostAndPort.hasPort());
        return new HostAndPort(hostAndPort.host, n, hostAndPort.hasBracketlessColons);
    }

    public static HostAndPort fromHost(String string) {
        HostAndPort hostAndPort = HostAndPort.fromString(string);
        Util.checkArgument(!hostAndPort.hasPort());
        return hostAndPort;
    }

    public static HostAndPort fromString(String string) {
        String string2;
        Util.checkNotNull(string);
        String string3 = null;
        boolean bl = false;
        if (string.startsWith("[")) {
            String[] stringArray = HostAndPort.getHostAndPortFromBracketedHost(string);
            string2 = stringArray[0];
            string3 = stringArray[1];
        } else {
            int n = string.indexOf(58);
            if (n >= 0 && string.indexOf(58, n + 1) == -1) {
                string2 = string.substring(0, n);
                string3 = string.substring(n + 1);
            } else {
                string2 = string;
                bl = n >= 0;
            }
        }
        int n = -1;
        if (!Util.isNullOrEmpty(string3)) {
            Util.checkArgument(!string3.startsWith("+"));
            try {
                n = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Unparseable port number: " + string);
            }
            Util.checkArgument(HostAndPort.isValidPort(n));
        }
        return new HostAndPort(string2, n, bl);
    }

    private static String[] getHostAndPortFromBracketedHost(String string) {
        int n = 0;
        int n2 = 0;
        Util.checkArgument(string.charAt(0) == '[');
        n = string.indexOf(58);
        n2 = string.lastIndexOf(93);
        Util.checkArgument(n > -1 && n2 > n);
        String string2 = string.substring(1, n2);
        if (n2 + 1 == string.length()) {
            return new String[]{string2, ""};
        }
        Util.checkArgument(string.charAt(n2 + 1) == ':');
        for (int i = n2 + 2; i < string.length(); ++i) {
            Util.checkArgument(Character.isDigit(string.charAt(i)));
        }
        return new String[]{string2, string.substring(n2 + 2)};
    }

    public HostAndPort withDefaultPort(int n) {
        Util.checkArgument(HostAndPort.isValidPort(n));
        if (this.hasPort() || this.port == n) {
            return this;
        }
        return new HostAndPort(this.host, n, this.hasBracketlessColons);
    }

    public HostAndPort requireBracketsForIPv6() {
        Util.checkArgument(!this.hasBracketlessColons);
        return this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof HostAndPort) {
            HostAndPort hostAndPort = (HostAndPort)object;
            return Util.equal(this.host, hostAndPort.host) && this.port == hostAndPort.port && this.hasBracketlessColons == hostAndPort.hasBracketlessColons;
        }
        return false;
    }

    public int hashCode() {
        return Util.hashCode(this.host, this.port, this.hasBracketlessColons);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.host.length() + 8);
        if (this.host.indexOf(58) >= 0) {
            stringBuilder.append('[').append(this.host).append(']');
        } else {
            stringBuilder.append(this.host);
        }
        if (this.hasPort()) {
            stringBuilder.append(':').append(this.port);
        }
        return stringBuilder.toString();
    }

    private static boolean isValidPort(int n) {
        return n >= 0 && n <= 65535;
    }
}

