/*
 * Decompiled with CFR 0.152.
 */
package com.github.yingzhuo.nsqj;

import com.github.yingzhuo.nsqj.Client;
import com.github.yingzhuo.nsqj.Connection;
import com.github.yingzhuo.nsqj.HostAndPort;
import com.github.yingzhuo.nsqj.Publisher;
import java.io.IOException;
import java.util.List;

class PubConnection
extends Connection {
    private final Publisher publisher;

    public PubConnection(Client client, HostAndPort hostAndPort, Publisher publisher) {
        super(client, hostAndPort);
        this.publisher = publisher;
    }

    public synchronized void publish(String string, byte[] byArray) throws IOException {
        this.respQueue.clear();
        this.writeCommand("PUB", string);
        this.write(byArray);
        this.flushAndReadOK();
    }

    public synchronized void publishDeferred(String string, byte[] byArray, long l) throws IOException {
        this.respQueue.clear();
        this.writeCommand("DPUB", string, Long.toString(l));
        this.write(byArray);
        this.flushAndReadOK();
    }

    public synchronized void publish(String string, List<byte[]> list) throws IOException {
        this.respQueue.clear();
        this.writeCommand("MPUB", string);
        int n = 4;
        for (byte[] byArray : list) {
            n += byArray.length + 4;
        }
        this.out.writeInt(n);
        this.out.writeInt(list.size());
        for (byte[] byArray : list) {
            this.write(byArray);
        }
        this.flushAndReadOK();
    }

    @Override
    public void close() {
        super.close();
        if (!this.publisher.isStopping) {
            this.client.getSchedExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    PubConnection.this.publisher.connectionClosed(PubConnection.this);
                }
            });
        }
    }

    public String toString() {
        return String.format("PubCon:%s", this.host.getHost());
    }
}

