/*
 * Decompiled with CFR 0.152.
 */
package com.github.yingzhuo.nsqj;

import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class Util {
    private static final Logger log = LoggerFactory.getLogger(Util.class);
    public static final Charset US_ASCII = Charset.forName("US-ASCII");
    public static final Charset UTF_8 = Charset.forName("UTF-8");

    Util() {
    }

    public static ThreadFactory threadFactory(final String string) {
        final AtomicLong atomicLong = new AtomicLong();
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = Executors.defaultThreadFactory().newThread(runnable);
                thread.setName(string + "-" + Long.toString(atomicLong.getAndIncrement()));
                thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                    @Override
                    public void uncaughtException(Thread thread, Throwable throwable) {
                        log.error("uncaught error", throwable);
                    }
                });
                return thread;
            }
        };
    }

    public static long clock() {
        return System.nanoTime() / 1000000L;
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            log.warn("problem closing. {}", (Object)iOException.toString());
        }
    }

    public static void sleepQuietly(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    public static void cancel(ScheduledFuture scheduledFuture) {
        if (scheduledFuture != null) {
            scheduledFuture.cancel(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> copy(Collection<T> collection) {
        Collection<T> collection2 = collection;
        synchronized (collection2) {
            ArrayList<T> arrayList = new ArrayList<T>(collection.size());
            arrayList.addAll(collection);
            return arrayList;
        }
    }

    public static void checkNotNull(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
    }

    public static void checkArgument(boolean bl) {
        if (!bl) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkState(boolean bl, String string) {
        if (!bl) {
            throw new IllegalStateException(string);
        }
    }

    public static boolean shutdownAndAwaitTermination(ExecutorService executorService, long l, TimeUnit timeUnit) {
        long l2 = timeUnit.toNanos(l) / 2L;
        executorService.shutdown();
        try {
            if (!executorService.awaitTermination(l2, TimeUnit.NANOSECONDS)) {
                executorService.shutdownNow();
                executorService.awaitTermination(l2, TimeUnit.NANOSECONDS);
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            executorService.shutdownNow();
        }
        return executorService.isTerminated();
    }

    public static <T> T firstNonNull(T t, T t2) {
        return t != null ? t : t2;
    }

    public static boolean equal(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    public static int hashCode(Object ... objectArray) {
        return Arrays.hashCode(objectArray);
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }
}

