/*
 * Decompiled with CFR 0.152.
 */
package com.github.yingzhuo.nsqj.spring;

import com.github.yingzhuo.nsqj.Client;
import com.github.yingzhuo.nsqj.Config;
import com.github.yingzhuo.nsqj.Publisher;
import com.github.yingzhuo.nsqj.spring.PublisherConfigurer;
import com.github.yingzhuo.nsqj.spring.config.BatchConfig;
import java.util.List;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class PublisherFactoryBean
implements FactoryBean<Publisher>,
InitializingBean {
    private Client client;
    private String nsqd = "localhost";
    private String failoverNsqd;
    private Config config;
    private List<BatchConfig> batchConfigs;
    private int FailoverDurationSecs = 300;
    private PublisherConfigurer publisherConfigurer;

    public Publisher getObject() {
        Publisher publisher = new Publisher(this.client, this.nsqd, this.failoverNsqd);
        if (this.config != null) {
            publisher.setConfig(this.config);
        }
        if (this.batchConfigs != null) {
            for (BatchConfig batchConfig : this.batchConfigs) {
                publisher.setBatchConfig(batchConfig.getTopic(), batchConfig.getMaxSizeBytes(), batchConfig.getMaxDelayMillis());
            }
        }
        publisher.setFailoverDurationSecs(this.FailoverDurationSecs);
        if (this.publisherConfigurer != null) {
            this.publisherConfigurer.config(publisher);
        }
        return publisher;
    }

    public Class<?> getObjectType() {
        return Publisher.class;
    }

    public void afterPropertiesSet() {
        if (this.client == null) {
            this.client = Client.getDefaultClient();
        }
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public void setNsqd(String string) {
        this.nsqd = string;
    }

    public void setFailoverNsqd(String string) {
        this.failoverNsqd = string;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public void setBatchConfigs(List<BatchConfig> list) {
        this.batchConfigs = list;
    }

    public void setFailoverDurationSecs(int n) {
        this.FailoverDurationSecs = n;
    }

    public void setPublisherConfigurer(PublisherConfigurer publisherConfigurer) {
        this.publisherConfigurer = publisherConfigurer;
    }
}

