/*
 * Decompiled with CFR 0.152.
 */
package com.github.yingzhuo.nsqj.spring.config;

import org.springframework.core.convert.converter.Converter;

public class BatchConfig {
    private String topic;
    private int maxSizeBytes;
    private int maxDelayMillis;

    public String getTopic() {
        return this.topic;
    }

    public int getMaxSizeBytes() {
        return this.maxSizeBytes;
    }

    public int getMaxDelayMillis() {
        return this.maxDelayMillis;
    }

    public void setTopic(String string) {
        this.topic = string;
    }

    public void setMaxSizeBytes(int n) {
        this.maxSizeBytes = n;
    }

    public void setMaxDelayMillis(int n) {
        this.maxDelayMillis = n;
    }

    public static class BatchConfigConverter
    implements Converter<String, BatchConfig> {
        public BatchConfig convert(String string) {
            if (string == null) {
                throw new IllegalArgumentException("invalid batch config (null)");
            }
            String[] stringArray = string.split(",");
            if (stringArray.length != 3) {
                throw new IllegalArgumentException("invalid batch config");
            }
            try {
                BatchConfig batchConfig = new BatchConfig();
                batchConfig.topic = stringArray[0].trim();
                batchConfig.maxSizeBytes = Integer.parseInt(stringArray[1].trim());
                batchConfig.maxDelayMillis = Integer.parseInt(stringArray[2].trim());
                return batchConfig;
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(exception.getMessage(), exception);
            }
        }
    }
}

