/*
 * Decompiled with CFR 0.152.
 */
package com.github.yuchi.semver;

import com.github.yuchi.semver.REWrapper;

public class Constants {
    public static final REWrapper NUMERIC = Constants.wrap("^[0-9]+$");
    public static final REWrapper NUMERICIDENTIFIER = Constants.wrap("0|[1-9]\\d*");
    public static final REWrapper NUMERICIDENTIFIERLOOSE = Constants.wrap("[0-9]+");
    public static final REWrapper NONNUMERICIDENTIFIER = Constants.wrap("\\d*[a-zA-Z-][a-zA-Z0-9-]*");
    public static final REWrapper MAINVERSION = Constants.wrap("(" + NUMERICIDENTIFIER + ")\\." + "(" + NUMERICIDENTIFIER + ")\\." + "(" + NUMERICIDENTIFIER + ")");
    public static final REWrapper MAINVERSIONLOOSE = Constants.wrap("(" + NUMERICIDENTIFIERLOOSE + ")\\." + "(" + NUMERICIDENTIFIERLOOSE + ")\\." + "(" + NUMERICIDENTIFIERLOOSE + ")");
    public static final REWrapper PRERELEASEIDENTIFIER = Constants.wrap("(?:" + NUMERICIDENTIFIER + "|" + NONNUMERICIDENTIFIER + ")");
    public static final REWrapper PRERELEASEIDENTIFIERLOOSE = Constants.wrap("(?:" + NUMERICIDENTIFIERLOOSE + "|" + NONNUMERICIDENTIFIER + ")");
    public static final REWrapper PRERELEASE = Constants.wrap("(?:-(" + PRERELEASEIDENTIFIER + "(?:\\." + PRERELEASEIDENTIFIER + ")*))");
    public static final REWrapper PRERELEASELOOSE = Constants.wrap("(?:-?(" + PRERELEASEIDENTIFIERLOOSE + "(?:\\." + PRERELEASEIDENTIFIERLOOSE + ")*))");
    public static final REWrapper BUILDIDENTIFIER = Constants.wrap("[0-9A-Za-z-]+");
    public static final REWrapper BUILD = Constants.wrap("(?:\\+(" + BUILDIDENTIFIER + "(?:\\." + BUILDIDENTIFIER + ")*))");
    public static final REWrapper FULLPLAIN = Constants.wrap("v?" + MAINVERSION + PRERELEASE + "?" + BUILD + "?");
    public static final REWrapper FULL = Constants.wrap("^" + FULLPLAIN + "$");
    public static final REWrapper LOOSEPLAIN = Constants.wrap("[v=\\s]*" + MAINVERSIONLOOSE + PRERELEASELOOSE + "?" + BUILD + "?");
    public static final REWrapper LOOSE = Constants.wrap("^" + LOOSEPLAIN + "$");
    public static final REWrapper GTLT = Constants.wrap("((?:<|>)?=?)");
    public static final REWrapper XRANGEIDENTIFIERLOOSE = Constants.wrap(NUMERICIDENTIFIERLOOSE + "|x|X|\\*");
    public static final REWrapper XRANGEIDENTIFIER = Constants.wrap(NUMERICIDENTIFIER + "|x|X|\\*");
    public static final REWrapper XRANGEPLAIN = Constants.wrap("[v=\\s]*(" + XRANGEIDENTIFIER + ")" + "(?:\\.(" + XRANGEIDENTIFIER + ")" + "(?:\\.(" + XRANGEIDENTIFIER + ")" + "(?:" + PRERELEASE + ")?" + BUILD + "?" + ")?)?");
    public static final REWrapper XRANGEPLAINLOOSE = Constants.wrap("[v=\\s]*(" + XRANGEIDENTIFIERLOOSE + ")" + "(?:\\.(" + XRANGEIDENTIFIERLOOSE + ")" + "(?:\\.(" + XRANGEIDENTIFIERLOOSE + ")" + "(?:" + PRERELEASELOOSE + ")?" + BUILD + "?" + ")?)?");
    public static final REWrapper XRANGE = Constants.wrap("^" + GTLT + "\\s*" + XRANGEPLAIN + "$");
    public static final REWrapper XRANGELOOSE = Constants.wrap("^" + GTLT + "\\s*" + XRANGEPLAINLOOSE + "$");
    public static final REWrapper LONETILDE = Constants.wrap("(?:~>?)");
    public static final REWrapper TILDETRIM = Constants.wrap("(\\s*)" + LONETILDE + "\\s+", true);
    public static final String TILDETRIM_REPLACE = "$1~";
    public static final REWrapper TILDE = Constants.wrap("^" + LONETILDE + XRANGEPLAIN + "$");
    public static final REWrapper TILDELOOSE = Constants.wrap("^" + LONETILDE + XRANGEPLAINLOOSE + "$");
    public static final REWrapper LONECARET = Constants.wrap("(?:\\^)");
    public static final REWrapper CARETTRIM = Constants.wrap("(\\s*)" + LONECARET + "\\s+", true);
    public static final String CARETTRIM_REPLACE = "$1^";
    public static final REWrapper CARET = Constants.wrap("^" + LONECARET + XRANGEPLAIN + "$");
    public static final REWrapper CARETLOOSE = Constants.wrap("^" + LONECARET + XRANGEPLAINLOOSE + "$");
    public static final REWrapper COMPARATORLOOSE = Constants.wrap("^" + GTLT + "\\s*(" + LOOSEPLAIN + ")$|^$");
    public static final REWrapper COMPARATOR = Constants.wrap("^" + GTLT + "\\s*(" + FULLPLAIN + ")$|^$");
    public static final REWrapper COMPARATORTRIM = Constants.wrap("(\\s*)" + GTLT + "\\s*(" + LOOSEPLAIN + "|" + XRANGEPLAIN + ")", true);
    public static final String COMPARATORTRIM_REPLACE = "$1$2$3";
    public static final REWrapper HYPHENRANGE = Constants.wrap("^\\s*(" + XRANGEPLAIN + ")" + "\\s+-\\s+" + "(" + XRANGEPLAIN + ")" + "\\s*$");
    public static final REWrapper HYPHENRANGELOOSE = Constants.wrap("^\\s*(" + XRANGEPLAINLOOSE + ")" + "\\s+-\\s+" + "(" + XRANGEPLAINLOOSE + ")" + "\\s*$");
    public static final REWrapper STAR = Constants.wrap("(<|>)?=?\\s*\\*");

    protected static REWrapper wrap(String pattern) {
        return new REWrapper(pattern);
    }

    protected static REWrapper wrap(String pattern, boolean global) {
        return new REWrapper(pattern, global);
    }
}

