/*
 * Decompiled with CFR 0.152.
 */
package de.lema.appender;

import de.lema.annotations.Immutable;
import de.lema.appender.ExtraInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Properties;

@Immutable
public final class Identifikation
implements Serializable {
    private static final long serialVersionUID = 12345L;
    private final String anwendung;
    private final String logSenderVersion;
    private final int umgebung;
    private final boolean hatBeacon;
    private final String applikationVersion;
    private final ExtraInfo extraInfo;
    private final String hostname;

    public static Identifikation create(String anwendung, int umgebung, boolean hatBeacon, String appversion, String hostname, boolean mitExtraInfo) {
        String logVersion = Identifikation.getVersionFromFile();
        ExtraInfo extraInfo = mitExtraInfo ? new ExtraInfo() : null;
        return Identifikation.createManuell(anwendung, umgebung, logVersion, hatBeacon, appversion, hostname, extraInfo);
    }

    public static Identifikation createManuell(String anwendung, int umgebung, String logVersion, boolean hatBeacon, String appversion, String hostname, ExtraInfo extraInfo) {
        return new Identifikation(anwendung, umgebung, logVersion, hatBeacon, appversion, hostname, extraInfo);
    }

    public String getLogSenderVersion() {
        return this.logSenderVersion;
    }

    public boolean isHatBeacon() {
        return this.hatBeacon;
    }

    public ExtraInfo getExtraInfo() {
        return this.extraInfo;
    }

    private Identifikation(String anwendung, int umgebung, String logSenderVersion, boolean hatBeacon, String applikationVersion, String hostname, ExtraInfo extraInfo) {
        this.anwendung = anwendung;
        this.umgebung = umgebung;
        this.logSenderVersion = logSenderVersion;
        this.hatBeacon = hatBeacon;
        this.applikationVersion = applikationVersion;
        this.hostname = hostname;
        this.extraInfo = extraInfo;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getApplikationVersion() {
        return this.applikationVersion;
    }

    public String getAnwendung() {
        return this.anwendung;
    }

    public int getUmgebung() {
        return this.umgebung;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.anwendung == null ? 0 : this.anwendung.hashCode());
        result = 31 * result + (this.applikationVersion == null ? 0 : this.applikationVersion.hashCode());
        result = 31 * result + (this.hatBeacon ? 1231 : 1237);
        result = 31 * result + (this.logSenderVersion == null ? 0 : this.logSenderVersion.hashCode());
        result = 31 * result + this.umgebung;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Identifikation)) {
            return false;
        }
        Identifikation other = (Identifikation)obj;
        if (this.anwendung == null ? other.anwendung != null : !this.anwendung.equals(other.anwendung)) {
            return false;
        }
        if (this.applikationVersion == null ? other.applikationVersion != null : !this.applikationVersion.equals(other.applikationVersion)) {
            return false;
        }
        if (this.hatBeacon != other.hatBeacon) {
            return false;
        }
        if (this.logSenderVersion == null ? other.logSenderVersion != null : !this.logSenderVersion.equals(other.logSenderVersion)) {
            return false;
        }
        return this.umgebung == other.umgebung;
    }

    public boolean istValid() {
        return this.getAnwendung() != null && this.getAnwendung().length() > 0;
    }

    public static String getVersionFromFile() {
        try {
            Properties props = new Properties();
            InputStream inputStream = Identifikation.class.getClassLoader().getResourceAsStream("generated.properties");
            props.load(inputStream);
            String version = props.getProperty("version");
            inputStream.close();
            return version;
        }
        catch (Exception exc) {
            return "unbekannt";
        }
    }

    public String toStringKurz() {
        return this.anwendung + "-" + this.umgebung;
    }

    public String toString() {
        return this.toStringKurz() + " (" + this.toStringZusatztext() + ")";
    }

    public String toStringZusatztext() {
        return "LogVersion: " + this.logSenderVersion + ", AppVersion: " + this.applikationVersion + ", Beacon: " + (this.hatBeacon ? "Ja" : "Nein");
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    public static final class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 12345L;
        private transient Identifikation identifikation;

        public SerializationProxy(Identifikation identifikation) {
            this.identifikation = identifikation;
        }

        private void writeObject(ObjectOutputStream s) throws IOException {
            s.defaultWriteObject();
            s.writeInt(7);
            s.writeObject(this.identifikation.getAnwendung());
            s.writeInt(this.identifikation.getUmgebung());
            s.writeObject(this.identifikation.getLogSenderVersion());
            s.writeBoolean(this.identifikation.isHatBeacon());
            s.writeObject(this.identifikation.getApplikationVersion());
            s.writeObject(this.identifikation.getExtraInfo());
            s.writeObject(this.identifikation.getHostname());
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
            int felderImStrom = s.readInt();
            String anwendung = this.read(s, felderImStrom, 1, "<Anwendung>");
            int umgebung = this.read(s, felderImStrom, 2, 10);
            String logVersion = this.read(s, felderImStrom, 3, "<LogServerVersion>");
            boolean hatBecon = this.read(s, felderImStrom, 4, false);
            String appVersion = this.read(s, felderImStrom, 5, "<ApplikationVersion>");
            ExtraInfo extraInfo = this.read(s, felderImStrom, 6, (ExtraInfo)null);
            String hostname = this.read(s, felderImStrom, 7, "");
            this.identifikation = new Identifikation(anwendung, umgebung, logVersion, hatBecon, appVersion, hostname, extraInfo);
        }

        private Object readResolve() {
            return this.identifikation;
        }

        private String read(ObjectInputStream s, int felderImStrom, int akt, String def) throws IOException, ClassNotFoundException {
            return felderImStrom >= akt ? (String)s.readObject() : def;
        }

        private int read(ObjectInputStream s, int felderImStrom, int akt, int def) throws IOException {
            return felderImStrom >= akt ? s.readInt() : def;
        }

        private boolean read(ObjectInputStream s, int felderImStrom, int akt, boolean def) throws IOException {
            return felderImStrom >= akt ? s.readBoolean() : def;
        }

        private <T> T read(ObjectInputStream s, int felderImStrom, int akt, T def) throws IOException, ClassNotFoundException {
            return (T)(felderImStrom >= akt ? s.readObject() : def);
        }
    }
}

