/*
 * Decompiled with CFR 0.152.
 */
package de.lema.appender;

import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.classic.spi.ThrowableProxy;
import de.lema.appender.ExceptionHelper;
import de.lema.appender.LemaLoggingEvent;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.MDC;

public class LemaLoggingEventFactory {
    public static LemaLoggingEvent create(LoggingEvent event, boolean locationInfo) {
        String message = event.getFormattedMessage();
        Throwable throwable = LemaLoggingEventFactory.getThrowable(event);
        String exceptionClass = LemaLoggingEventFactory.getExceptionClass(throwable);
        String exceptionMessage = LemaLoggingEventFactory.getExceptionMessage(throwable);
        long datum = event.getTimeStamp();
        int level = event.getLevel().toInt();
        StackTraceElement[] cda = LemaLoggingEventFactory.getCallerData(event, locationInfo);
        String className = LemaLoggingEventFactory.getClass(event, cda);
        String methodName = LemaLoggingEventFactory.getMethodName(cda);
        int lineNumber = LemaLoggingEventFactory.getLineNumber(cda);
        String threadName = event.getThreadName();
        HashMap<String, String> mdc = LemaLoggingEventFactory.createMdc();
        return new LemaLoggingEvent(message, mdc, throwable, null, datum, level, lineNumber, className, methodName, threadName, exceptionClass, exceptionMessage);
    }

    private static String getExceptionMessage(Throwable throwable) {
        return throwable != null ? throwable.getMessage() : null;
    }

    private static String getExceptionClass(Throwable throwable) {
        return throwable != null ? (throwable instanceof ExceptionHelper ? ((ExceptionHelper)throwable).getClassName() : throwable.getClass().getName()) : null;
    }

    private static Throwable getThrowable(LoggingEvent event) {
        return event.getThrowableProxy() != null ? ((ThrowableProxy)event.getThrowableProxy()).getThrowable() : null;
    }

    private static StackTraceElement[] getCallerData(LoggingEvent event, boolean locationInfo) {
        StackTraceElement[] cda = null;
        if (locationInfo) {
            cda = event.getCallerData();
        }
        return cda;
    }

    private static String getMethodName(StackTraceElement[] cda) {
        return cda != null && cda.length > 0 ? cda[0].getMethodName() : null;
    }

    private static int getLineNumber(StackTraceElement[] cda) {
        return cda != null && cda.length > 0 ? cda[0].getLineNumber() : 0;
    }

    private static HashMap<String, String> createMdc() {
        HashMap<String, String> mdc = new HashMap<String, String>();
        Map context = MDC.getCopyOfContextMap();
        if (context != null && !context.isEmpty()) {
            mdc = new HashMap();
            for (Map.Entry entry : context.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if (key == null || value == null) continue;
                mdc.put(key, value.toString());
            }
        }
        return mdc;
    }

    private static String getClass(LoggingEvent event, StackTraceElement[] cda) {
        if (cda != null && cda.length > 0) {
            return cda[0].getClassName();
        }
        return event.getLoggerName();
    }
}

