/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.bag.immutable.primitive;

import com.gs.collections.api.BooleanIterable;
import com.gs.collections.api.LazyBooleanIterable;
import com.gs.collections.api.bag.ImmutableBag;
import com.gs.collections.api.bag.primitive.BooleanBag;
import com.gs.collections.api.bag.primitive.ImmutableBooleanBag;
import com.gs.collections.api.bag.primitive.MutableBooleanBag;
import com.gs.collections.api.block.function.primitive.BooleanToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BooleanPredicate;
import com.gs.collections.api.block.procedure.primitive.BooleanIntProcedure;
import com.gs.collections.api.block.procedure.primitive.BooleanProcedure;
import com.gs.collections.api.iterator.BooleanIterator;
import com.gs.collections.api.list.primitive.MutableBooleanList;
import com.gs.collections.api.set.primitive.MutableBooleanSet;
import com.gs.collections.impl.bag.mutable.HashBag;
import com.gs.collections.impl.bag.mutable.primitive.BooleanHashBag;
import com.gs.collections.impl.factory.primitive.BooleanBags;
import com.gs.collections.impl.lazy.primitive.LazyBooleanIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.BooleanArrayList;
import com.gs.collections.impl.set.mutable.primitive.BooleanHashSet;
import java.io.IOException;
import java.io.Serializable;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableBooleanSingletonBag
implements ImmutableBooleanBag,
Serializable {
    private static final long serialVersionUID = 1L;
    private final boolean element1;

    ImmutableBooleanSingletonBag(boolean element) {
        this.element1 = element;
    }

    public ImmutableBooleanBag newWith(boolean element) {
        return BooleanBags.immutable.with(new boolean[]{this.element1, element});
    }

    public ImmutableBooleanBag newWithout(boolean element) {
        return this.element1 == element ? BooleanBags.immutable.with() : this;
    }

    public ImmutableBooleanBag newWithAll(BooleanIterable elements) {
        return BooleanHashBag.newBag(elements).with(this.element1).toImmutable();
    }

    public ImmutableBooleanBag newWithoutAll(BooleanIterable elements) {
        return elements.contains(this.element1) ? BooleanBags.immutable.with() : this;
    }

    public int size() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public boolean contains(boolean value) {
        return this.element1 == value;
    }

    public boolean containsAll(BooleanIterable source) {
        BooleanIterator iterator = source.booleanIterator();
        while (iterator.hasNext()) {
            if (this.element1 == iterator.next()) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(boolean ... source) {
        for (boolean value : source) {
            if (this.element1 == value) continue;
            return false;
        }
        return true;
    }

    public void forEach(BooleanProcedure procedure) {
        procedure.value(this.element1);
    }

    public ImmutableBooleanBag select(BooleanPredicate predicate) {
        return predicate.accept(this.element1) ? BooleanHashBag.newBagWith(this.element1).toImmutable() : new BooleanHashBag().toImmutable();
    }

    public ImmutableBooleanBag reject(BooleanPredicate predicate) {
        return predicate.accept(this.element1) ? new BooleanHashBag().toImmutable() : BooleanHashBag.newBagWith(this.element1).toImmutable();
    }

    public <V> ImmutableBag<V> collect(BooleanToObjectFunction<? extends V> function) {
        return HashBag.newBagWith(function.valueOf(this.element1)).toImmutable();
    }

    public MutableBooleanList toList() {
        return BooleanArrayList.newListWith(this.element1);
    }

    public int sizeDistinct() {
        return 1;
    }

    public int occurrencesOf(boolean item) {
        return this.element1 == item ? 1 : 0;
    }

    public void forEachWithOccurrences(BooleanIntProcedure booleanIntProcedure) {
        booleanIntProcedure.value(this.element1, 1);
    }

    public boolean detectIfNone(BooleanPredicate predicate, boolean ifNone) {
        return predicate.accept(this.element1) ? this.element1 : ifNone;
    }

    public int count(BooleanPredicate predicate) {
        return predicate.accept(this.element1) ? 1 : 0;
    }

    public boolean anySatisfy(BooleanPredicate predicate) {
        return predicate.accept(this.element1);
    }

    public boolean noneSatisfy(BooleanPredicate predicate) {
        return !predicate.accept(this.element1);
    }

    public boolean allSatisfy(BooleanPredicate predicate) {
        return predicate.accept(this.element1);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BooleanBag)) {
            return false;
        }
        BooleanBag bag = (BooleanBag)obj;
        if (bag.size() != 1) {
            return false;
        }
        return this.occurrencesOf(this.element1) == bag.occurrencesOf(this.element1);
    }

    public int hashCode() {
        return (this.element1 ? 1231 : 1237) ^ 1;
    }

    public MutableBooleanSet toSet() {
        return BooleanHashSet.newSetWith(this.element1);
    }

    public MutableBooleanBag toBag() {
        return BooleanHashBag.newBagWith(this.element1);
    }

    public ImmutableBooleanBag toImmutable() {
        return this;
    }

    public LazyBooleanIterable asLazy() {
        return new LazyBooleanIterableAdapter((BooleanIterable)this);
    }

    public boolean[] toArray() {
        return new boolean[]{this.element1};
    }

    public String toString() {
        return '[' + this.makeString() + ']';
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.element1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public BooleanIterator booleanIterator() {
        return BooleanHashBag.newBagWith(this.element1).booleanIterator();
    }
}

