/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.lazy.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.LazyCharIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.bag.primitive.MutableCharBag;
import com.gs.collections.api.block.function.primitive.CharFunction;
import com.gs.collections.api.block.function.primitive.CharToObjectFunction;
import com.gs.collections.api.block.function.primitive.LongObjectToLongFunction;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.predicate.primitive.CharPredicate;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.CharProcedure;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.iterator.CharIterator;
import com.gs.collections.api.list.primitive.MutableCharList;
import com.gs.collections.api.set.primitive.MutableCharSet;
import com.gs.collections.impl.bag.mutable.primitive.CharHashBag;
import com.gs.collections.impl.block.factory.primitive.CharPredicates;
import com.gs.collections.impl.lazy.primitive.CollectCharToObjectIterable;
import com.gs.collections.impl.lazy.primitive.SelectCharIterable;
import com.gs.collections.impl.list.mutable.primitive.CharArrayList;
import com.gs.collections.impl.set.mutable.primitive.CharHashSet;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class CollectCharIterable<T>
implements LazyCharIterable {
    private final LazyIterable<T> iterable;
    private final CharFunction<? super T> function;
    private final CharFunctionToProcedure charFunctionToProcedure = new CharFunctionToProcedure();

    public CollectCharIterable(LazyIterable<T> adapted, CharFunction<? super T> function) {
        this.iterable = adapted;
        this.function = function;
    }

    public CharIterator charIterator() {
        return new CharIterator(){
            private final Iterator<T> iterator;
            {
                this.iterator = CollectCharIterable.this.iterable.iterator();
            }

            public char next() {
                return CollectCharIterable.this.function.charValueOf(this.iterator.next());
            }

            public boolean hasNext() {
                return this.iterator.hasNext();
            }
        };
    }

    public void forEach(CharProcedure procedure) {
        this.iterable.forEachWith((Procedure2)this.charFunctionToProcedure, (Object)procedure);
    }

    public int size() {
        return this.iterable.size();
    }

    public boolean isEmpty() {
        return this.iterable.isEmpty();
    }

    public boolean notEmpty() {
        return this.iterable.notEmpty();
    }

    public int count(final CharPredicate predicate) {
        return this.iterable.count(new Predicate<T>(){

            public boolean accept(T each) {
                return predicate.accept(CollectCharIterable.this.function.charValueOf(each));
            }
        });
    }

    public boolean anySatisfy(final CharPredicate predicate) {
        return this.iterable.anySatisfy(new Predicate<T>(){

            public boolean accept(T each) {
                return predicate.accept(CollectCharIterable.this.function.charValueOf(each));
            }
        });
    }

    public boolean allSatisfy(final CharPredicate predicate) {
        return this.iterable.allSatisfy(new Predicate<T>(){

            public boolean accept(T each) {
                return predicate.accept(CollectCharIterable.this.function.charValueOf(each));
            }
        });
    }

    public boolean noneSatisfy(final CharPredicate predicate) {
        return this.iterable.allSatisfy(new Predicate<T>(){

            public boolean accept(T each) {
                return !predicate.accept(CollectCharIterable.this.function.charValueOf(each));
            }
        });
    }

    public LazyCharIterable select(CharPredicate predicate) {
        return new SelectCharIterable((CharIterable)this, predicate);
    }

    public LazyCharIterable reject(CharPredicate predicate) {
        return new SelectCharIterable((CharIterable)this, CharPredicates.not(predicate));
    }

    public char detectIfNone(CharPredicate predicate, char ifNone) {
        CharIterator iterator = this.charIterator();
        while (iterator.hasNext()) {
            char next = iterator.next();
            if (!predicate.accept(next)) continue;
            return next;
        }
        return ifNone;
    }

    public <V> LazyIterable<V> collect(CharToObjectFunction<? extends V> function) {
        return new CollectCharToObjectIterable<V>((CharIterable)this, function);
    }

    public long sum() {
        return this.iterable.injectInto(0L, new LongObjectToLongFunction<T>(){

            public long longValueOf(long longValue, T each) {
                return longValue + (long)CollectCharIterable.this.function.charValueOf(each);
            }
        });
    }

    public char max() {
        CharIterator iterator = this.charIterator();
        char max = iterator.next();
        while (iterator.hasNext()) {
            char next = iterator.next();
            max = next > max ? next : max;
        }
        return max;
    }

    public char min() {
        CharIterator iterator = this.charIterator();
        char min = iterator.next();
        while (iterator.hasNext()) {
            char next = iterator.next();
            min = min < next ? min : next;
        }
        return min;
    }

    public char minIfEmpty(char defaultValue) {
        try {
            return this.min();
        }
        catch (NoSuchElementException noSuchElementException) {
            return defaultValue;
        }
    }

    public char maxIfEmpty(char defaultValue) {
        try {
            return this.max();
        }
        catch (NoSuchElementException noSuchElementException) {
            return defaultValue;
        }
    }

    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return (double)this.sum() / (double)this.size();
    }

    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        char[] sortedArray = this.toSortedArray();
        int i = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            char first = sortedArray[i];
            char second = sortedArray[i - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[i];
    }

    public char[] toArray() {
        final char[] array = new char[this.size()];
        this.iterable.forEachWithIndex(new ObjectIntProcedure<T>(){

            public void value(T each, int index) {
                array[index] = CollectCharIterable.this.function.charValueOf(each);
            }
        });
        return array;
    }

    public char[] toSortedArray() {
        char[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            CharIterator iterator = this.charIterator();
            if (iterator.hasNext()) {
                appendable.append(String.valueOf(iterator.next()));
                while (iterator.hasNext()) {
                    appendable.append(separator);
                    appendable.append(String.valueOf(iterator.next()));
                }
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public MutableCharList toList() {
        return CharArrayList.newList((CharIterable)this);
    }

    public MutableCharList toSortedList() {
        return CharArrayList.newList((CharIterable)this).sortThis();
    }

    public MutableCharSet toSet() {
        return CharHashSet.newSet((CharIterable)this);
    }

    public MutableCharBag toBag() {
        return CharHashBag.newBag((CharIterable)this);
    }

    public LazyCharIterable asLazy() {
        return this;
    }

    public boolean contains(char value) {
        return this.anySatisfy(CharPredicates.equal(value));
    }

    public boolean containsAll(char ... source) {
        for (char value : source) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(CharIterable source) {
        CharIterator iterator = source.charIterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class CharFunctionToProcedure
    implements Procedure2<T, CharProcedure> {
        private static final long serialVersionUID = -4133872659735979655L;

        private CharFunctionToProcedure() {
        }

        public void value(T each, CharProcedure parm) {
            parm.value(CollectCharIterable.this.function.charValueOf(each));
        }
    }
}

