/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.lazy.primitive;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.bag.primitive.MutableIntBag;
import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.iterator.IntIterator;
import com.gs.collections.api.list.primitive.MutableIntList;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.impl.block.factory.primitive.IntPredicates;
import com.gs.collections.impl.lazy.primitive.CollectIntToObjectIterable;
import com.gs.collections.impl.lazy.primitive.SelectIntIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyIntIterableAdapter
implements LazyIntIterable {
    private final IntIterable delegate;

    public LazyIntIterableAdapter(IntIterable delegate) {
        this.delegate = delegate;
    }

    public IntIterator intIterator() {
        return this.delegate.intIterator();
    }

    public void forEach(IntProcedure procedure) {
        this.delegate.forEach(procedure);
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    public int count(IntPredicate predicate) {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(IntPredicate predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(IntPredicate predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(IntPredicate predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    public LazyIntIterable select(IntPredicate predicate) {
        return new SelectIntIterable(this.delegate, predicate);
    }

    public LazyIntIterable reject(IntPredicate predicate) {
        return new SelectIntIterable(this.delegate, IntPredicates.not(predicate));
    }

    public int detectIfNone(IntPredicate predicate, int ifNone) {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public <V> LazyIterable<V> collect(IntToObjectFunction<? extends V> function) {
        return new CollectIntToObjectIterable<V>(this.delegate, function);
    }

    public long sum() {
        return this.delegate.sum();
    }

    public int max() {
        return this.delegate.max();
    }

    public int min() {
        return this.delegate.min();
    }

    public int minIfEmpty(int defaultValue) {
        return this.delegate.minIfEmpty(defaultValue);
    }

    public int maxIfEmpty(int defaultValue) {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    public double average() {
        return this.delegate.average();
    }

    public double median() {
        return this.delegate.median();
    }

    public int[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    public MutableIntList toSortedList() {
        return this.delegate.toSortedList();
    }

    public int[] toArray() {
        return this.delegate.toArray();
    }

    public String toString() {
        return this.delegate.toString();
    }

    public String makeString() {
        return this.delegate.makeString();
    }

    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    public boolean contains(int value) {
        return this.delegate.contains(value);
    }

    public boolean containsAll(int ... source) {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(IntIterable source) {
        return this.delegate.containsAll(source);
    }

    public MutableIntList toList() {
        return this.delegate.toList();
    }

    public MutableIntSet toSet() {
        return this.delegate.toSet();
    }

    public MutableIntBag toBag() {
        return this.delegate.toBag();
    }

    public LazyIntIterable asLazy() {
        return this;
    }
}

