/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.LazyCharIterable;
import com.gs.collections.api.LazyShortIterable;
import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.bag.primitive.MutableShortBag;
import com.gs.collections.api.block.function.primitive.ShortToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.CharShortPredicate;
import com.gs.collections.api.block.predicate.primitive.ShortPredicate;
import com.gs.collections.api.block.procedure.primitive.CharProcedure;
import com.gs.collections.api.block.procedure.primitive.CharShortProcedure;
import com.gs.collections.api.block.procedure.primitive.ShortProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableShortCollection;
import com.gs.collections.api.collection.primitive.MutableShortCollection;
import com.gs.collections.api.iterator.ShortIterator;
import com.gs.collections.api.list.primitive.MutableShortList;
import com.gs.collections.api.map.primitive.CharShortMap;
import com.gs.collections.api.map.primitive.ImmutableCharShortMap;
import com.gs.collections.api.set.primitive.MutableCharSet;
import com.gs.collections.api.set.primitive.MutableShortSet;
import com.gs.collections.impl.bag.mutable.primitive.ShortHashBag;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.factory.primitive.CharShortMaps;
import com.gs.collections.impl.lazy.primitive.LazyShortIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.ShortArrayList;
import com.gs.collections.impl.map.mutable.primitive.CharShortHashMap;
import com.gs.collections.impl.set.mutable.primitive.ShortHashSet;
import java.io.IOException;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableCharShortSingletonMap
implements ImmutableCharShortMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final short EMPTY_VALUE = 0;
    private final char key1;
    private final short value1;

    ImmutableCharShortSingletonMap(char key1, short value1) {
        this.key1 = key1;
        this.value1 = value1;
    }

    public short get(char key) {
        return this.getIfAbsent(key, (short)0);
    }

    public short getIfAbsent(char key, short ifAbsent) {
        return this.key1 == key ? this.value1 : ifAbsent;
    }

    public short getOrThrow(char key) {
        if (this.key1 == key) {
            return this.value1;
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(char key) {
        return this.key1 == key;
    }

    public boolean containsValue(short value) {
        return this.value1 == value;
    }

    public void forEachValue(ShortProcedure procedure) {
        procedure.value(this.value1);
    }

    public void forEachKey(CharProcedure procedure) {
        procedure.value(this.key1);
    }

    public void forEachKeyValue(CharShortProcedure procedure) {
        procedure.value(this.key1, this.value1);
    }

    public LazyCharIterable keysView() {
        return CharShortHashMap.newWithKeysValues(this.key1, this.value1).keysView();
    }

    public ImmutableCharShortMap select(CharShortPredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? CharShortHashMap.newWithKeysValues(this.key1, this.value1).toImmutable() : new CharShortHashMap().toImmutable();
    }

    public ImmutableCharShortMap reject(CharShortPredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? new CharShortHashMap().toImmutable() : CharShortHashMap.newWithKeysValues(this.key1, this.value1).toImmutable();
    }

    public ImmutableCharShortMap toImmutable() {
        return this;
    }

    public ShortIterator shortIterator() {
        return CharShortHashMap.newWithKeysValues(this.key1, this.value1).shortIterator();
    }

    public void forEach(ShortProcedure procedure) {
        procedure.value(this.value1);
    }

    public int count(ShortPredicate predicate) {
        return predicate.accept(this.value1) ? 1 : 0;
    }

    public long sum() {
        return this.value1;
    }

    public short min() {
        return this.value1;
    }

    public short max() {
        return this.value1;
    }

    public short maxIfEmpty(short defaultValue) {
        return this.value1;
    }

    public short minIfEmpty(short defaultValue) {
        return this.value1;
    }

    public double average() {
        return this.value1;
    }

    public double median() {
        return this.value1;
    }

    public short[] toSortedArray() {
        return new short[]{this.value1};
    }

    public MutableShortList toSortedList() {
        return ShortArrayList.newListWith(this.value1);
    }

    public boolean anySatisfy(ShortPredicate predicate) {
        return predicate.accept(this.value1);
    }

    public boolean allSatisfy(ShortPredicate predicate) {
        return predicate.accept(this.value1);
    }

    public boolean noneSatisfy(ShortPredicate predicate) {
        return !predicate.accept(this.value1);
    }

    public ImmutableShortCollection select(ShortPredicate predicate) {
        return predicate.accept(this.value1) ? ShortArrayList.newListWith(this.value1).toImmutable() : new ShortArrayList().toImmutable();
    }

    public ImmutableShortCollection reject(ShortPredicate predicate) {
        return predicate.accept(this.value1) ? new ShortArrayList().toImmutable() : ShortArrayList.newListWith(this.value1).toImmutable();
    }

    public short detectIfNone(ShortPredicate predicate, short ifNone) {
        return predicate.accept(this.value1) ? this.value1 : ifNone;
    }

    public <V> ImmutableCollection<V> collect(ShortToObjectFunction<? extends V> function) {
        return Lists.immutable.of(function.valueOf(this.value1));
    }

    public short[] toArray() {
        return new short[]{this.value1};
    }

    public boolean contains(short value) {
        return this.value1 == value;
    }

    public boolean containsAll(short ... source) {
        for (short value : source) {
            if (this.value1 == value) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(ShortIterable source) {
        ShortIterator iterator = source.shortIterator();
        while (iterator.hasNext()) {
            if (this.value1 == iterator.next()) continue;
            return false;
        }
        return true;
    }

    public MutableShortList toList() {
        return ShortArrayList.newListWith(this.value1);
    }

    public MutableShortSet toSet() {
        return ShortHashSet.newSetWith(this.value1);
    }

    public MutableShortBag toBag() {
        return ShortHashBag.newBagWith(this.value1);
    }

    public LazyShortIterable asLazy() {
        return new LazyShortIterableAdapter((ShortIterable)this);
    }

    public ImmutableCharShortMap newWithKeyValue(char key, short value) {
        return CharShortMaps.immutable.withAll((CharShortMap)CharShortHashMap.newWithKeysValues(this.key1, this.value1, key, value));
    }

    public ImmutableCharShortMap newWithoutKey(char key) {
        return this.key1 == key ? CharShortMaps.immutable.with() : this;
    }

    public ImmutableCharShortMap newWithoutAllKeys(CharIterable keys) {
        return keys.contains(this.key1) ? CharShortMaps.immutable.with() : this;
    }

    public int size() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public MutableCharSet keySet() {
        throw new UnsupportedOperationException("keySet is not implemented yet!");
    }

    public MutableShortCollection values() {
        throw new UnsupportedOperationException("values is not implemented yet!");
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CharShortMap)) {
            return false;
        }
        CharShortMap map = (CharShortMap)obj;
        if (map.size() != 1) {
            return false;
        }
        return map.containsKey(this.key1) && this.value1 == map.getOrThrow(this.key1);
    }

    public int hashCode() {
        return this.key1 ^ this.value1;
    }

    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.key1));
            appendable.append("=");
            appendable.append(String.valueOf(this.value1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

