/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.LazyCharIterable;
import com.gs.collections.api.LazyDoubleIterable;
import com.gs.collections.api.bag.primitive.MutableCharBag;
import com.gs.collections.api.block.function.primitive.CharToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.CharPredicate;
import com.gs.collections.api.block.predicate.primitive.DoubleCharPredicate;
import com.gs.collections.api.block.procedure.primitive.CharProcedure;
import com.gs.collections.api.block.procedure.primitive.DoubleCharProcedure;
import com.gs.collections.api.block.procedure.primitive.DoubleProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableCharCollection;
import com.gs.collections.api.collection.primitive.MutableCharCollection;
import com.gs.collections.api.iterator.CharIterator;
import com.gs.collections.api.iterator.DoubleIterator;
import com.gs.collections.api.list.primitive.MutableCharList;
import com.gs.collections.api.map.primitive.DoubleCharMap;
import com.gs.collections.api.map.primitive.ImmutableDoubleCharMap;
import com.gs.collections.api.map.primitive.MutableDoubleCharMap;
import com.gs.collections.api.set.primitive.MutableCharSet;
import com.gs.collections.api.set.primitive.MutableDoubleSet;
import com.gs.collections.impl.block.procedure.checked.primitive.CheckedDoubleCharProcedure;
import com.gs.collections.impl.map.mutable.primitive.DoubleCharHashMap;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableDoubleCharHashMap
implements ImmutableDoubleCharMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableDoubleCharMap delegate;

    ImmutableDoubleCharHashMap(DoubleCharMap delegate) {
        this.delegate = new DoubleCharHashMap(delegate);
    }

    public char get(double key) {
        return this.delegate.get(key);
    }

    public char getIfAbsent(double key, char ifAbsent) {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    public char getOrThrow(double key) {
        return this.delegate.getOrThrow(key);
    }

    public boolean containsKey(double key) {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(char value) {
        return this.delegate.containsValue(value);
    }

    public void forEachValue(CharProcedure procedure) {
        this.delegate.forEachValue(procedure);
    }

    public void forEachKey(DoubleProcedure procedure) {
        this.delegate.forEachKey(procedure);
    }

    public void forEachKeyValue(DoubleCharProcedure procedure) {
        this.delegate.forEachKeyValue(procedure);
    }

    public LazyDoubleIterable keysView() {
        return this.delegate.keysView();
    }

    public ImmutableDoubleCharMap select(DoubleCharPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableDoubleCharMap reject(DoubleCharPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public ImmutableDoubleCharMap toImmutable() {
        return this;
    }

    public CharIterator charIterator() {
        return this.delegate.charIterator();
    }

    public void forEach(CharProcedure procedure) {
        this.delegate.forEach(procedure);
    }

    public int count(CharPredicate predicate) {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(CharPredicate predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(CharPredicate predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(CharPredicate predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    public ImmutableCharCollection select(CharPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableCharCollection reject(CharPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public char detectIfNone(CharPredicate predicate, char ifNone) {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public <V> ImmutableCollection<V> collect(CharToObjectFunction<? extends V> function) {
        return this.delegate.collect(function).toImmutable();
    }

    public long sum() {
        return this.delegate.sum();
    }

    public char max() {
        return this.delegate.max();
    }

    public char maxIfEmpty(char defaultValue) {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    public char min() {
        return this.delegate.min();
    }

    public char minIfEmpty(char defaultValue) {
        return this.delegate.minIfEmpty(defaultValue);
    }

    public double average() {
        return this.delegate.average();
    }

    public double median() {
        return this.delegate.median();
    }

    public char[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    public MutableCharList toSortedList() {
        return this.delegate.toSortedList();
    }

    public char[] toArray() {
        return this.delegate.toArray();
    }

    public boolean contains(char value) {
        return this.delegate.contains(value);
    }

    public boolean containsAll(char ... source) {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(CharIterable source) {
        return this.delegate.containsAll(source);
    }

    public MutableCharList toList() {
        return this.delegate.toList();
    }

    public MutableCharSet toSet() {
        return this.delegate.toSet();
    }

    public MutableCharBag toBag() {
        return this.delegate.toBag();
    }

    public LazyCharIterable asLazy() {
        return this.delegate.asLazy();
    }

    public ImmutableDoubleCharMap newWithKeyValue(double key, char value) {
        DoubleCharHashMap map = new DoubleCharHashMap(this.size() + 1);
        map.putAll((DoubleCharMap)this);
        map.put(key, value);
        return map.toImmutable();
    }

    public ImmutableDoubleCharMap newWithoutKey(double key) {
        DoubleCharHashMap map = new DoubleCharHashMap(this.size());
        map.putAll((DoubleCharMap)this);
        map.removeKey(key);
        return map.toImmutable();
    }

    public ImmutableDoubleCharMap newWithoutAllKeys(DoubleIterable keys) {
        DoubleCharHashMap map = new DoubleCharHashMap(this.size());
        map.putAll((DoubleCharMap)this);
        DoubleIterator iterator = keys.doubleIterator();
        while (iterator.hasNext()) {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    public String makeString() {
        return this.delegate.makeString();
    }

    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    public MutableDoubleSet keySet() {
        throw new UnsupportedOperationException("keySet is not implemented yet!");
    }

    public MutableCharCollection values() {
        throw new UnsupportedOperationException("values is not implemented yet!");
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.delegate.toString();
    }

    private Object writeReplace() {
        return new ImmutableDoubleCharMapSerializationProxy((DoubleCharMap)this);
    }

    protected static class ImmutableDoubleCharMapSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private DoubleCharMap map;

        public ImmutableDoubleCharMapSerializationProxy() {
        }

        protected ImmutableDoubleCharMapSerializationProxy(DoubleCharMap map) {
            this.map = map;
        }

        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.map.size());
            try {
                this.map.forEachKeyValue((DoubleCharProcedure)new CheckedDoubleCharProcedure(){

                    public void safeValue(double key, char value) throws IOException {
                        out.writeDouble(key);
                        out.writeChar(value);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            DoubleCharHashMap deserializedMap = new DoubleCharHashMap();
            for (int i = 0; i < size; ++i) {
                deserializedMap.put(in.readDouble(), in.readChar());
            }
            this.map = deserializedMap;
        }

        protected Object readResolve() {
            return this.map.toImmutable();
        }
    }
}

