/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.LazyShortIterable;
import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.bag.primitive.MutableIntBag;
import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.predicate.primitive.ShortIntPredicate;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.block.procedure.primitive.ShortIntProcedure;
import com.gs.collections.api.block.procedure.primitive.ShortProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableIntCollection;
import com.gs.collections.api.collection.primitive.MutableIntCollection;
import com.gs.collections.api.iterator.IntIterator;
import com.gs.collections.api.list.primitive.MutableIntList;
import com.gs.collections.api.map.primitive.ImmutableShortIntMap;
import com.gs.collections.api.map.primitive.ShortIntMap;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.api.set.primitive.MutableShortSet;
import com.gs.collections.impl.bag.mutable.primitive.IntHashBag;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.factory.primitive.ShortIntMaps;
import com.gs.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.IntArrayList;
import com.gs.collections.impl.map.mutable.primitive.ShortIntHashMap;
import com.gs.collections.impl.set.mutable.primitive.IntHashSet;
import java.io.IOException;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableShortIntSingletonMap
implements ImmutableShortIntMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int EMPTY_VALUE = 0;
    private final short key1;
    private final int value1;

    ImmutableShortIntSingletonMap(short key1, int value1) {
        this.key1 = key1;
        this.value1 = value1;
    }

    public int get(short key) {
        return this.getIfAbsent(key, 0);
    }

    public int getIfAbsent(short key, int ifAbsent) {
        return this.key1 == key ? this.value1 : ifAbsent;
    }

    public int getOrThrow(short key) {
        if (this.key1 == key) {
            return this.value1;
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(short key) {
        return this.key1 == key;
    }

    public boolean containsValue(int value) {
        return this.value1 == value;
    }

    public void forEachValue(IntProcedure procedure) {
        procedure.value(this.value1);
    }

    public void forEachKey(ShortProcedure procedure) {
        procedure.value(this.key1);
    }

    public void forEachKeyValue(ShortIntProcedure procedure) {
        procedure.value(this.key1, this.value1);
    }

    public LazyShortIterable keysView() {
        return ShortIntHashMap.newWithKeysValues(this.key1, this.value1).keysView();
    }

    public ImmutableShortIntMap select(ShortIntPredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? ShortIntHashMap.newWithKeysValues(this.key1, this.value1).toImmutable() : new ShortIntHashMap().toImmutable();
    }

    public ImmutableShortIntMap reject(ShortIntPredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? new ShortIntHashMap().toImmutable() : ShortIntHashMap.newWithKeysValues(this.key1, this.value1).toImmutable();
    }

    public ImmutableShortIntMap toImmutable() {
        return this;
    }

    public IntIterator intIterator() {
        return ShortIntHashMap.newWithKeysValues(this.key1, this.value1).intIterator();
    }

    public void forEach(IntProcedure procedure) {
        procedure.value(this.value1);
    }

    public int count(IntPredicate predicate) {
        return predicate.accept(this.value1) ? 1 : 0;
    }

    public long sum() {
        return this.value1;
    }

    public int min() {
        return this.value1;
    }

    public int max() {
        return this.value1;
    }

    public int maxIfEmpty(int defaultValue) {
        return this.value1;
    }

    public int minIfEmpty(int defaultValue) {
        return this.value1;
    }

    public double average() {
        return this.value1;
    }

    public double median() {
        return this.value1;
    }

    public int[] toSortedArray() {
        return new int[]{this.value1};
    }

    public MutableIntList toSortedList() {
        return IntArrayList.newListWith(this.value1);
    }

    public boolean anySatisfy(IntPredicate predicate) {
        return predicate.accept(this.value1);
    }

    public boolean allSatisfy(IntPredicate predicate) {
        return predicate.accept(this.value1);
    }

    public boolean noneSatisfy(IntPredicate predicate) {
        return !predicate.accept(this.value1);
    }

    public ImmutableIntCollection select(IntPredicate predicate) {
        return predicate.accept(this.value1) ? IntArrayList.newListWith(this.value1).toImmutable() : new IntArrayList().toImmutable();
    }

    public ImmutableIntCollection reject(IntPredicate predicate) {
        return predicate.accept(this.value1) ? new IntArrayList().toImmutable() : IntArrayList.newListWith(this.value1).toImmutable();
    }

    public int detectIfNone(IntPredicate predicate, int ifNone) {
        return predicate.accept(this.value1) ? this.value1 : ifNone;
    }

    public <V> ImmutableCollection<V> collect(IntToObjectFunction<? extends V> function) {
        return Lists.immutable.of(function.valueOf(this.value1));
    }

    public int[] toArray() {
        return new int[]{this.value1};
    }

    public boolean contains(int value) {
        return this.value1 == value;
    }

    public boolean containsAll(int ... source) {
        for (int value : source) {
            if (this.value1 == value) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(IntIterable source) {
        IntIterator iterator = source.intIterator();
        while (iterator.hasNext()) {
            if (this.value1 == iterator.next()) continue;
            return false;
        }
        return true;
    }

    public MutableIntList toList() {
        return IntArrayList.newListWith(this.value1);
    }

    public MutableIntSet toSet() {
        return IntHashSet.newSetWith(this.value1);
    }

    public MutableIntBag toBag() {
        return IntHashBag.newBagWith(this.value1);
    }

    public LazyIntIterable asLazy() {
        return new LazyIntIterableAdapter((IntIterable)this);
    }

    public ImmutableShortIntMap newWithKeyValue(short key, int value) {
        return ShortIntMaps.immutable.withAll((ShortIntMap)ShortIntHashMap.newWithKeysValues(this.key1, this.value1, key, value));
    }

    public ImmutableShortIntMap newWithoutKey(short key) {
        return this.key1 == key ? ShortIntMaps.immutable.with() : this;
    }

    public ImmutableShortIntMap newWithoutAllKeys(ShortIterable keys) {
        return keys.contains(this.key1) ? ShortIntMaps.immutable.with() : this;
    }

    public int size() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public MutableShortSet keySet() {
        throw new UnsupportedOperationException("keySet is not implemented yet!");
    }

    public MutableIntCollection values() {
        throw new UnsupportedOperationException("values is not implemented yet!");
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ShortIntMap)) {
            return false;
        }
        ShortIntMap map = (ShortIntMap)obj;
        if (map.size() != 1) {
            return false;
        }
        return map.containsKey(this.key1) && this.value1 == map.getOrThrow(this.key1);
    }

    public int hashCode() {
        return this.key1 ^ this.value1;
    }

    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.key1));
            appendable.append("=");
            appendable.append(String.valueOf(this.value1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

