/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.mutable.primitive;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.LazyByteIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.LazyLongIterable;
import com.gs.collections.api.LongIterable;
import com.gs.collections.api.bag.primitive.MutableByteBag;
import com.gs.collections.api.bag.primitive.MutableLongBag;
import com.gs.collections.api.block.function.primitive.ByteToLongFunction;
import com.gs.collections.api.block.function.primitive.ByteToObjectFunction;
import com.gs.collections.api.block.function.primitive.LongFunction;
import com.gs.collections.api.block.function.primitive.LongFunction0;
import com.gs.collections.api.block.function.primitive.LongToLongFunction;
import com.gs.collections.api.block.function.primitive.LongToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.ByteLongPredicate;
import com.gs.collections.api.block.predicate.primitive.BytePredicate;
import com.gs.collections.api.block.predicate.primitive.LongPredicate;
import com.gs.collections.api.block.procedure.primitive.ByteLongProcedure;
import com.gs.collections.api.block.procedure.primitive.ByteProcedure;
import com.gs.collections.api.block.procedure.primitive.LongProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableLongCollection;
import com.gs.collections.api.collection.primitive.MutableLongCollection;
import com.gs.collections.api.iterator.ByteIterator;
import com.gs.collections.api.iterator.LongIterator;
import com.gs.collections.api.list.primitive.MutableByteList;
import com.gs.collections.api.list.primitive.MutableLongList;
import com.gs.collections.api.map.primitive.ByteLongMap;
import com.gs.collections.api.map.primitive.ImmutableByteLongMap;
import com.gs.collections.api.map.primitive.MutableByteLongMap;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.primitive.ByteSet;
import com.gs.collections.api.set.primitive.ImmutableByteSet;
import com.gs.collections.api.set.primitive.MutableByteSet;
import com.gs.collections.api.set.primitive.MutableLongSet;
import com.gs.collections.impl.bag.mutable.primitive.ByteHashBag;
import com.gs.collections.impl.bag.mutable.primitive.LongHashBag;
import com.gs.collections.impl.block.factory.primitive.BytePredicates;
import com.gs.collections.impl.collection.mutable.primitive.SynchronizedLongCollection;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableLongCollection;
import com.gs.collections.impl.factory.Sets;
import com.gs.collections.impl.factory.primitive.ByteLongMaps;
import com.gs.collections.impl.factory.primitive.ByteSets;
import com.gs.collections.impl.factory.primitive.LongLists;
import com.gs.collections.impl.lazy.primitive.CollectByteToObjectIterable;
import com.gs.collections.impl.lazy.primitive.LazyByteIterableAdapter;
import com.gs.collections.impl.lazy.primitive.LazyLongIterableAdapter;
import com.gs.collections.impl.lazy.primitive.SelectByteIterable;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.list.mutable.primitive.ByteArrayList;
import com.gs.collections.impl.list.mutable.primitive.LongArrayList;
import com.gs.collections.impl.map.mutable.primitive.SynchronizedByteLongMap;
import com.gs.collections.impl.map.mutable.primitive.UnmodifiableByteLongMap;
import com.gs.collections.impl.set.mutable.primitive.ByteHashSet;
import com.gs.collections.impl.set.mutable.primitive.LongHashSet;
import com.gs.collections.impl.set.mutable.primitive.SynchronizedByteSet;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableByteSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteLongHashMap
implements MutableByteLongMap,
Externalizable {
    static final long EMPTY_VALUE = 0L;
    private static final long serialVersionUID = 1L;
    private static final byte EMPTY_KEY = 0;
    private static final byte REMOVED_KEY = 1;
    private static final int OCCUPIED_DATA_RATIO = 2;
    private static final int OCCUPIED_SENTINEL_RATIO = 4;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private byte[] keys;
    private long[] values;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private SentinelValues sentinelValues;

    public ByteLongHashMap() {
        this.allocateTable(16);
    }

    public ByteLongHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(initialCapacity * 2));
        this.allocateTable(capacity);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    public ByteLongHashMap(ByteLongMap map) {
        this(Math.max(map.size(), 8));
        this.putAll(map);
    }

    private int fastCeil(float v) {
        int possibleResult = (int)v;
        if (v - (float)possibleResult > 0.0f) {
            ++possibleResult;
        }
        return possibleResult;
    }

    public static ByteLongHashMap newWithKeysValues(byte key1, long value1) {
        return new ByteLongHashMap(1).withKeyValue(key1, value1);
    }

    public static ByteLongHashMap newWithKeysValues(byte key1, long value1, byte key2, long value2) {
        return new ByteLongHashMap(2).withKeysValues(key1, value1, key2, value2);
    }

    public static ByteLongHashMap newWithKeysValues(byte key1, long value1, byte key2, long value2, byte key3, long value3) {
        return new ByteLongHashMap(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static ByteLongHashMap newWithKeysValues(byte key1, long value1, byte key2, long value2, byte key3, long value3, byte key4, long value4) {
        return new ByteLongHashMap(4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ByteLongMap)) {
            return false;
        }
        ByteLongMap other = (ByteLongMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.sentinelValues == null) {
            if (other.containsKey((byte)0) || other.containsKey((byte)1)) {
                return false;
            }
        } else {
            if (this.sentinelValues.containsZeroKey && (!other.containsKey((byte)0) || this.sentinelValues.zeroValue != other.getOrThrow((byte)0))) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && (!other.containsKey((byte)1) || this.sentinelValues.oneValue != other.getOrThrow((byte)1))) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            byte key = this.keys[i];
            if (!ByteLongHashMap.isNonSentinel(key) || other.containsKey(key) && this.values[i] == other.getOrThrow(key)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += 0 ^ (int)(this.sentinelValues.zeroValue ^ this.sentinelValues.zeroValue >>> 32);
            }
            if (this.sentinelValues.containsOneKey) {
                result += 1 ^ (int)(this.sentinelValues.oneValue ^ this.sentinelValues.oneValue >>> 32);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteLongHashMap.isNonSentinel(this.keys[i])) continue;
            result += this.keys[i] ^ (int)(this.values[i] ^ this.values[i] >>> 32);
        }
        return result;
    }

    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    public int size() {
        return this.occupiedWithData + (this.sentinelValues == null ? 0 : this.sentinelValues.size());
    }

    public boolean isEmpty() {
        return this.occupiedWithData == 0 && (this.sentinelValues == null || this.sentinelValues.size() == 0);
    }

    public boolean notEmpty() {
        return this.occupiedWithData != 0 || this.sentinelValues != null && this.sentinelValues.size() != 0;
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            boolean first = true;
            if (this.sentinelValues != null) {
                if (this.sentinelValues.containsZeroKey) {
                    appendable.append(String.valueOf(0)).append("=").append(String.valueOf(this.sentinelValues.zeroValue));
                    first = false;
                }
                if (this.sentinelValues.containsOneKey) {
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(1)).append("=").append(String.valueOf(this.sentinelValues.oneValue));
                    first = false;
                }
            }
            for (int i = 0; i < this.keys.length; ++i) {
                byte key = this.keys[i];
                if (!ByteLongHashMap.isNonSentinel(key)) continue;
                if (!first) {
                    appendable.append(separator);
                }
                appendable.append(String.valueOf(key)).append("=").append(String.valueOf(this.values[i]));
                first = false;
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public LongIterator longIterator() {
        return new InternalLongIterator();
    }

    public long[] toArray() {
        long[] array = new long[this.size()];
        int index = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                array[index] = this.sentinelValues.zeroValue;
                ++index;
            }
            if (this.sentinelValues.containsOneKey) {
                array[index] = this.sentinelValues.oneValue;
                ++index;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteLongHashMap.isNonSentinel(this.keys[i])) continue;
            array[index] = this.values[i];
            ++index;
        }
        return array;
    }

    public boolean contains(long value) {
        return this.containsValue(value);
    }

    public boolean containsAll(long ... source) {
        for (long each : source) {
            if (this.contains(each)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(LongIterable source) {
        return source.allSatisfy(new LongPredicate(){

            public boolean accept(long value) {
                return ByteLongHashMap.this.contains(value);
            }
        });
    }

    public void forEach(LongProcedure procedure) {
        this.forEachValue(procedure);
    }

    public MutableLongCollection select(LongPredicate predicate) {
        LongArrayList result = new LongArrayList();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                result.add(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                result.add(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteLongHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public MutableLongCollection reject(LongPredicate predicate) {
        LongArrayList result = new LongArrayList();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(this.sentinelValues.zeroValue)) {
                result.add(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(this.sentinelValues.oneValue)) {
                result.add(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteLongHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public <V> MutableCollection<V> collect(LongToObjectFunction<? extends V> function) {
        FastList target = FastList.newList(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                target.add(function.valueOf(this.sentinelValues.zeroValue));
            }
            if (this.sentinelValues.containsOneKey) {
                target.add(function.valueOf(this.sentinelValues.oneValue));
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteLongHashMap.isNonSentinel(this.keys[i])) continue;
            target.add(function.valueOf(this.values[i]));
        }
        return target;
    }

    public long detectIfNone(LongPredicate predicate, long value) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteLongHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return this.values[i];
        }
        return value;
    }

    public int count(LongPredicate predicate) {
        int count = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                ++count;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                ++count;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteLongHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            ++count;
        }
        return count;
    }

    public boolean anySatisfy(LongPredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return true;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return true;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteLongHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return true;
        }
        return false;
    }

    public boolean allSatisfy(LongPredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(this.sentinelValues.zeroValue)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(this.sentinelValues.oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteLongHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean noneSatisfy(LongPredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteLongHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public <V> V injectInto(V injectedValue, ObjectLongToObjectFunction<? super V, ? extends V> function) {
        Object result = injectedValue;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result = function.valueOf(result, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                result = function.valueOf(result, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteLongHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.valueOf(result, this.values[i]);
        }
        return result;
    }

    public MutableLongList toList() {
        return LongArrayList.newList((LongIterable)this);
    }

    public MutableLongSet toSet() {
        return LongHashSet.newSet((LongIterable)this);
    }

    public MutableLongBag toBag() {
        return LongHashBag.newBag((LongIterable)this);
    }

    public LazyLongIterable asLazy() {
        return new LazyLongIterableAdapter((LongIterable)this);
    }

    public void clear() {
        this.sentinelValues = null;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        Arrays.fill(this.keys, (byte)0);
        Arrays.fill(this.values, 0L);
    }

    public void put(byte key, long value) {
        if (ByteLongHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value;
            return;
        }
        if (ByteLongHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value;
            return;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values[index] = value;
            return;
        }
        if (this.keys[index] == 1) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    public void putAll(ByteLongMap map) {
        map.forEachKeyValue(new ByteLongProcedure(){

            public void value(byte key, long value) {
                ByteLongHashMap.this.put(key, value);
            }
        });
    }

    public void removeKey(byte key) {
        if (ByteLongHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return;
            }
            if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.containsZeroKey = false;
                this.sentinelValues.zeroValue = 0L;
            } else {
                this.sentinelValues = null;
            }
            return;
        }
        if (ByteLongHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return;
            }
            if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.containsOneKey = false;
                this.sentinelValues.oneValue = 0L;
            } else {
                this.sentinelValues = null;
            }
            return;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.keys[index] = 1;
            this.values[index] = 0L;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
        }
    }

    public void remove(byte key) {
        this.removeKey(key);
    }

    public long removeKeyIfAbsent(byte key, long value) {
        if (ByteLongHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return value;
            }
            long oldValue = this.sentinelValues.zeroValue;
            if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.containsZeroKey = false;
                this.sentinelValues.zeroValue = 0L;
            } else {
                this.sentinelValues = null;
            }
            return oldValue;
        }
        if (ByteLongHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return value;
            }
            long oldValue = this.sentinelValues.oneValue;
            if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.containsOneKey = false;
                this.sentinelValues.oneValue = 0L;
            } else {
                this.sentinelValues = null;
            }
            return oldValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.keys[index] = 1;
            long oldValue = this.values[index];
            this.values[index] = 0L;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
            return oldValue;
        }
        return value;
    }

    public long getIfAbsentPut(byte key, long value) {
        if (ByteLongHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value;
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value;
            return value;
        }
        if (ByteLongHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value;
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value;
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        this.keys[index] = key;
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public long getIfAbsentPut(byte key, LongFunction0 function) {
        long value;
        if (ByteLongHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                long value2 = function.value();
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value2;
                return value2;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            long value3 = function.value();
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value3;
            return value3;
        }
        if (ByteLongHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                long value4 = function.value();
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value4;
                return value4;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            long value5 = function.value();
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value5;
            return value5;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        this.keys[index] = key;
        this.values[index] = value = function.value();
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public <P> long getIfAbsentPutWith(byte key, LongFunction<? super P> function, P parameter) {
        long value;
        if (ByteLongHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                long value2 = function.longValueOf(parameter);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value2;
                return value2;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            long value3 = function.longValueOf(parameter);
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value3;
            return value3;
        }
        if (ByteLongHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                long value4 = function.longValueOf(parameter);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value4;
                return value4;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            long value5 = function.longValueOf(parameter);
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value5;
            return value5;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        this.keys[index] = key;
        this.values[index] = value = function.longValueOf(parameter);
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public long getIfAbsentPutWithKey(byte key, ByteToLongFunction function) {
        long value;
        if (ByteLongHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                long value2 = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value2;
                return value2;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            long value3 = function.valueOf(key);
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value3;
            return value3;
        }
        if (ByteLongHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                long value4 = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value4;
                return value4;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            long value5 = function.valueOf(key);
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value5;
            return value5;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        this.keys[index] = key;
        this.values[index] = value = function.valueOf(key);
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public long updateValue(byte key, long initialValueIfAbsent, LongToLongFunction function) {
        long value;
        if (ByteLongHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = function.valueOf(initialValueIfAbsent);
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = function.valueOf(this.sentinelValues.zeroValue);
            } else {
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = function.valueOf(initialValueIfAbsent);
            }
            return this.sentinelValues.zeroValue;
        }
        if (ByteLongHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = function.valueOf(initialValueIfAbsent);
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = function.valueOf(this.sentinelValues.oneValue);
            } else {
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = function.valueOf(initialValueIfAbsent);
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values[index] = function.valueOf(this.values[index]);
            return this.values[index];
        }
        if (this.keys[index] == 1) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value = function.valueOf(initialValueIfAbsent);
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public ByteLongHashMap withKeyValue(byte key1, long value1) {
        this.put(key1, value1);
        return this;
    }

    public ByteLongHashMap withKeysValues(byte key1, long value1, byte key2, long value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public ByteLongHashMap withKeysValues(byte key1, long value1, byte key2, long value2, byte key3, long value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public ByteLongHashMap withKeysValues(byte key1, long value1, byte key2, long value2, byte key3, long value3, byte key4, long value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    public ByteLongHashMap withoutKey(byte key) {
        this.removeKey(key);
        return this;
    }

    public ByteLongHashMap withoutAllKeys(ByteIterable keys) {
        keys.forEach(new ByteProcedure(){

            public void value(byte key) {
                ByteLongHashMap.this.removeKey(key);
            }
        });
        return this;
    }

    public MutableByteLongMap asUnmodifiable() {
        return new UnmodifiableByteLongMap(this);
    }

    public MutableByteLongMap asSynchronized() {
        return new SynchronizedByteLongMap(this);
    }

    public ImmutableByteLongMap toImmutable() {
        return ByteLongMaps.immutable.ofAll((ByteLongMap)this);
    }

    public long get(byte key) {
        return this.getIfAbsent(key, 0L);
    }

    public long getIfAbsent(byte key, long ifAbsent) {
        if (ByteLongHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return ifAbsent;
            }
            return this.sentinelValues.zeroValue;
        }
        if (ByteLongHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return ifAbsent;
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        return ifAbsent;
    }

    public long getOrThrow(byte key) {
        if (ByteLongHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.zeroValue;
        }
        if (ByteLongHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (ByteLongHashMap.isNonSentinel(this.keys[index])) {
            return this.values[index];
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(byte key) {
        if (ByteLongHashMap.isEmptyKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsZeroKey;
        }
        if (ByteLongHashMap.isRemovedKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsOneKey;
        }
        return this.keys[this.probe(key)] == key;
    }

    public boolean containsValue(long value) {
        if (this.sentinelValues != null && this.sentinelValues.containsValue(value)) {
            return true;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (!ByteLongHashMap.isNonSentinel(this.keys[i]) || this.values[i] != value) continue;
            return true;
        }
        return false;
    }

    public void forEachValue(LongProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteLongHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.values[i]);
        }
    }

    public void forEachKey(ByteProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value((byte)0);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value((byte)1);
            }
        }
        for (byte key : this.keys) {
            if (!ByteLongHashMap.isNonSentinel(key)) continue;
            procedure.value(key);
        }
    }

    public void forEachKeyValue(ByteLongProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value((byte)0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value((byte)1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteLongHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i], this.values[i]);
        }
    }

    public LazyByteIterable keysView() {
        return new KeysView();
    }

    public ByteLongHashMap select(ByteLongPredicate predicate) {
        ByteLongHashMap result = new ByteLongHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept((byte)0, this.sentinelValues.zeroValue)) {
                result.put((byte)0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept((byte)1, this.sentinelValues.oneValue)) {
                result.put((byte)1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteLongHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    public ByteLongHashMap reject(ByteLongPredicate predicate) {
        ByteLongHashMap result = new ByteLongHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept((byte)0, this.sentinelValues.zeroValue)) {
                result.put((byte)0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept((byte)1, this.sentinelValues.oneValue)) {
                result.put((byte)1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteLongHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    public long sum() {
        long result = 0L;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey) {
                result += this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteLongHashMap.isNonSentinel(this.keys[i])) continue;
            result += this.values[i];
        }
        return result;
    }

    public long max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        LongIterator iterator = this.longIterator();
        long max = iterator.next();
        while (iterator.hasNext()) {
            long value = iterator.next();
            if (max >= value) continue;
            max = value;
        }
        return max;
    }

    public long maxIfEmpty(long defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.max();
    }

    public long min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        LongIterator iterator = this.longIterator();
        long min = iterator.next();
        while (iterator.hasNext()) {
            long value = iterator.next();
            if (value >= min) continue;
            min = value;
        }
        return min;
    }

    public long minIfEmpty(long defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.min();
    }

    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return (double)this.sum() / (double)this.size();
    }

    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        long[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            long first = sortedArray[middleIndex];
            long second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    public long[] toSortedArray() {
        long[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    public MutableLongList toSortedList() {
        return LongArrayList.newList((LongIterable)this).sortThis();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                out.writeByte(0);
                out.writeLong(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                out.writeByte(1);
                out.writeLong(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteLongHashMap.isNonSentinel(this.keys[i])) continue;
            out.writeByte(this.keys[i]);
            out.writeLong(this.values[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.put(in.readByte(), in.readLong());
        }
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehash() {
        this.rehash(this.keys.length);
    }

    private void rehashAndGrow() {
        this.rehash(this.keys.length << 1);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        byte[] old = this.keys;
        long[] oldValues = this.values;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!ByteLongHashMap.isNonSentinel(old[i])) continue;
            this.put(old[i], oldValues[i]);
        }
    }

    int probe(byte element) {
        int index = this.spread(element);
        byte keyAtIndex = this.keys[index];
        if (keyAtIndex == element || keyAtIndex == 0) {
            return index;
        }
        int removedIndex = keyAtIndex == 1 ? index : -1;
        int nextIndex = index;
        int probe = 17;
        while (true) {
            nextIndex += probe;
            probe += 17;
            if (this.keys[nextIndex &= this.keys.length - 1] == element) {
                return nextIndex;
            }
            if (this.keys[nextIndex] == 1) {
                if (removedIndex != -1) continue;
                removedIndex = nextIndex;
                continue;
            }
            if (this.keys[nextIndex] == 0) break;
        }
        return removedIndex == -1 ? nextIndex : removedIndex;
    }

    int spread(byte element) {
        return element & this.keys.length - 1;
    }

    private void allocateTable(int sizeToAllocate) {
        this.keys = new byte[sizeToAllocate];
        this.values = new long[sizeToAllocate];
    }

    private static boolean isEmptyKey(byte key) {
        return key == 0;
    }

    private static boolean isRemovedKey(byte key) {
        return key == 1;
    }

    private static boolean isNonSentinel(byte key) {
        return !ByteLongHashMap.isEmptyKey(key) && !ByteLongHashMap.isRemovedKey(key);
    }

    private int maxOccupiedWithData() {
        int capacity = this.keys.length;
        return Math.min(capacity - 1, capacity / 2);
    }

    private int maxOccupiedWithSentinels() {
        return this.keys.length / 4;
    }

    public MutableByteSet keySet() {
        return new KeySet();
    }

    public MutableLongCollection values() {
        return new ValuesCollection();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValuesCollection
    implements MutableLongCollection {
        private ValuesCollection() {
        }

        public void clear() {
            ByteLongHashMap.this.clear();
        }

        public MutableLongCollection select(LongPredicate predicate) {
            return ByteLongHashMap.this.select(predicate);
        }

        public MutableLongCollection reject(LongPredicate predicate) {
            return ByteLongHashMap.this.reject(predicate);
        }

        public long detectIfNone(LongPredicate predicate, long ifNone) {
            return ByteLongHashMap.this.detectIfNone(predicate, ifNone);
        }

        public <V> MutableCollection<V> collect(LongToObjectFunction<? extends V> function) {
            return ByteLongHashMap.this.collect(function);
        }

        public long sum() {
            return ByteLongHashMap.this.sum();
        }

        public long max() {
            return ByteLongHashMap.this.max();
        }

        public long maxIfEmpty(long defaultValue) {
            return ByteLongHashMap.this.maxIfEmpty(defaultValue);
        }

        public long min() {
            return ByteLongHashMap.this.min();
        }

        public long minIfEmpty(long defaultValue) {
            return ByteLongHashMap.this.minIfEmpty(defaultValue);
        }

        public double average() {
            return ByteLongHashMap.this.average();
        }

        public double median() {
            return ByteLongHashMap.this.median();
        }

        public long[] toSortedArray() {
            return ByteLongHashMap.this.toSortedArray();
        }

        public MutableLongList toSortedList() {
            return ByteLongHashMap.this.toSortedList();
        }

        public MutableLongCollection with(long element) {
            throw new UnsupportedOperationException();
        }

        public MutableLongCollection without(long element) {
            throw new UnsupportedOperationException();
        }

        public MutableLongCollection withAll(LongIterable elements) {
            throw new UnsupportedOperationException();
        }

        public MutableLongCollection withoutAll(LongIterable elements) {
            throw new UnsupportedOperationException();
        }

        public MutableLongCollection asUnmodifiable() {
            return UnmodifiableLongCollection.of(this);
        }

        public MutableLongCollection asSynchronized() {
            return SynchronizedLongCollection.of(this);
        }

        public ImmutableLongCollection toImmutable() {
            return LongLists.immutable.withAll((LongIterable)this);
        }

        public boolean contains(long value) {
            return ByteLongHashMap.this.containsValue(value);
        }

        public boolean containsAll(long ... source) {
            return ByteLongHashMap.this.containsAll(source);
        }

        public boolean containsAll(LongIterable source) {
            return ByteLongHashMap.this.containsAll(source);
        }

        public MutableLongList toList() {
            return ByteLongHashMap.this.toList();
        }

        public MutableLongSet toSet() {
            return ByteLongHashMap.this.toSet();
        }

        public MutableLongBag toBag() {
            return ByteLongHashMap.this.toBag();
        }

        public LazyLongIterable asLazy() {
            return new LazyLongIterableAdapter((LongIterable)this);
        }

        public boolean isEmpty() {
            return ByteLongHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return ByteLongHashMap.this.notEmpty();
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (ByteLongHashMap.this.sentinelValues != null) {
                    if (ByteLongHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(ByteLongHashMap.this.sentinelValues.zeroValue));
                        first = false;
                    }
                    if (ByteLongHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(ByteLongHashMap.this.sentinelValues.oneValue));
                        first = false;
                    }
                }
                for (int i = 0; i < ByteLongHashMap.this.keys.length; ++i) {
                    byte key = ByteLongHashMap.this.keys[i];
                    if (!ByteLongHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(ByteLongHashMap.this.values[i]));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public LongIterator longIterator() {
            return ByteLongHashMap.this.longIterator();
        }

        public void forEach(LongProcedure procedure) {
            ByteLongHashMap.this.forEach(procedure);
        }

        public int count(LongPredicate predicate) {
            return ByteLongHashMap.this.count(predicate);
        }

        public boolean anySatisfy(LongPredicate predicate) {
            return ByteLongHashMap.this.anySatisfy(predicate);
        }

        public boolean allSatisfy(LongPredicate predicate) {
            return ByteLongHashMap.this.allSatisfy(predicate);
        }

        public boolean noneSatisfy(LongPredicate predicate) {
            return ByteLongHashMap.this.noneSatisfy(predicate);
        }

        public boolean add(long element) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(long ... source) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(LongIterable source) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(long item) {
            int oldSize = ByteLongHashMap.this.size();
            if (ByteLongHashMap.this.sentinelValues != null) {
                if (ByteLongHashMap.this.sentinelValues.containsZeroKey && item == ByteLongHashMap.this.sentinelValues.zeroValue) {
                    ByteLongHashMap.this.removeKey((byte)0);
                }
                if (ByteLongHashMap.this.sentinelValues.containsOneKey && item == ByteLongHashMap.this.sentinelValues.oneValue) {
                    ByteLongHashMap.this.removeKey((byte)1);
                }
            }
            for (int i = 0; i < ByteLongHashMap.this.keys.length; ++i) {
                if (!ByteLongHashMap.isNonSentinel(ByteLongHashMap.this.keys[i]) || item != ByteLongHashMap.this.values[i]) continue;
                ByteLongHashMap.this.removeKey(ByteLongHashMap.this.keys[i]);
            }
            return oldSize != ByteLongHashMap.this.size();
        }

        public boolean removeAll(LongIterable source) {
            int oldSize = ByteLongHashMap.this.size();
            LongIterator iterator = source.longIterator();
            while (iterator.hasNext()) {
                this.remove(iterator.next());
            }
            return oldSize != ByteLongHashMap.this.size();
        }

        public boolean removeAll(long ... source) {
            int oldSize = ByteLongHashMap.this.size();
            for (long item : source) {
                this.remove(item);
            }
            return oldSize != ByteLongHashMap.this.size();
        }

        public int size() {
            return ByteLongHashMap.this.size();
        }

        public long[] toArray() {
            return ByteLongHashMap.this.toArray();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    implements MutableByteSet {
        private KeySet() {
        }

        public ByteIterator byteIterator() {
            return new KeySetIterator();
        }

        public void forEach(ByteProcedure procedure) {
            ByteLongHashMap.this.forEachKey(procedure);
        }

        public int count(BytePredicate predicate) {
            int count = 0;
            if (ByteLongHashMap.this.sentinelValues != null) {
                if (ByteLongHashMap.this.sentinelValues.containsZeroKey && predicate.accept((byte)0)) {
                    ++count;
                }
                if (ByteLongHashMap.this.sentinelValues.containsOneKey && predicate.accept((byte)1)) {
                    ++count;
                }
            }
            for (byte key : ByteLongHashMap.this.keys) {
                if (!ByteLongHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                ++count;
            }
            return count;
        }

        public boolean anySatisfy(BytePredicate predicate) {
            if (ByteLongHashMap.this.sentinelValues != null) {
                if (ByteLongHashMap.this.sentinelValues.containsZeroKey && predicate.accept((byte)0)) {
                    return true;
                }
                if (ByteLongHashMap.this.sentinelValues.containsOneKey && predicate.accept((byte)1)) {
                    return true;
                }
            }
            for (byte key : ByteLongHashMap.this.keys) {
                if (!ByteLongHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return true;
            }
            return false;
        }

        public boolean allSatisfy(BytePredicate predicate) {
            if (ByteLongHashMap.this.sentinelValues != null) {
                if (ByteLongHashMap.this.sentinelValues.containsZeroKey && !predicate.accept((byte)0)) {
                    return false;
                }
                if (ByteLongHashMap.this.sentinelValues.containsOneKey && !predicate.accept((byte)1)) {
                    return false;
                }
            }
            for (byte key : ByteLongHashMap.this.keys) {
                if (!ByteLongHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean noneSatisfy(BytePredicate predicate) {
            if (ByteLongHashMap.this.sentinelValues != null) {
                if (ByteLongHashMap.this.sentinelValues.containsZeroKey && predicate.accept((byte)0)) {
                    return false;
                }
                if (ByteLongHashMap.this.sentinelValues.containsOneKey && predicate.accept((byte)1)) {
                    return false;
                }
            }
            for (byte key : ByteLongHashMap.this.keys) {
                if (!ByteLongHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean add(byte element) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(byte ... source) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(ByteIterable source) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(byte key) {
            int oldSize = ByteLongHashMap.this.size();
            ByteLongHashMap.this.removeKey(key);
            return oldSize != ByteLongHashMap.this.size();
        }

        public boolean removeAll(ByteIterable source) {
            int oldSize = ByteLongHashMap.this.size();
            ByteIterator iterator = source.byteIterator();
            while (iterator.hasNext()) {
                ByteLongHashMap.this.removeKey(iterator.next());
            }
            return oldSize != ByteLongHashMap.this.size();
        }

        public boolean removeAll(byte ... source) {
            int oldSize = ByteLongHashMap.this.size();
            for (byte item : source) {
                ByteLongHashMap.this.removeKey(item);
            }
            return oldSize != ByteLongHashMap.this.size();
        }

        public void clear() {
            ByteLongHashMap.this.clear();
        }

        public MutableByteSet select(BytePredicate predicate) {
            ByteHashSet result = new ByteHashSet();
            if (ByteLongHashMap.this.sentinelValues != null) {
                if (ByteLongHashMap.this.sentinelValues.containsZeroKey && predicate.accept((byte)0)) {
                    result.add((byte)0);
                }
                if (ByteLongHashMap.this.sentinelValues.containsOneKey && predicate.accept((byte)1)) {
                    result.add((byte)1);
                }
            }
            for (byte key : ByteLongHashMap.this.keys) {
                if (!ByteLongHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        public MutableByteSet reject(BytePredicate predicate) {
            ByteHashSet result = new ByteHashSet();
            if (ByteLongHashMap.this.sentinelValues != null) {
                if (ByteLongHashMap.this.sentinelValues.containsZeroKey && !predicate.accept((byte)0)) {
                    result.add((byte)0);
                }
                if (ByteLongHashMap.this.sentinelValues.containsOneKey && !predicate.accept((byte)1)) {
                    result.add((byte)1);
                }
            }
            for (byte key : ByteLongHashMap.this.keys) {
                if (!ByteLongHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        public MutableByteSet with(byte element) {
            throw new UnsupportedOperationException();
        }

        public MutableByteSet without(byte element) {
            throw new UnsupportedOperationException();
        }

        public MutableByteSet withAll(ByteIterable elements) {
            throw new UnsupportedOperationException();
        }

        public MutableByteSet withoutAll(ByteIterable elements) {
            throw new UnsupportedOperationException();
        }

        public byte detectIfNone(BytePredicate predicate, byte ifNone) {
            if (ByteLongHashMap.this.sentinelValues != null) {
                if (ByteLongHashMap.this.sentinelValues.containsZeroKey && predicate.accept((byte)0)) {
                    return 0;
                }
                if (ByteLongHashMap.this.sentinelValues.containsOneKey && predicate.accept((byte)1)) {
                    return 1;
                }
            }
            for (byte key : ByteLongHashMap.this.keys) {
                if (!ByteLongHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return key;
            }
            return ifNone;
        }

        public <V> MutableSet<V> collect(ByteToObjectFunction<? extends V> function) {
            MutableSet result = Sets.mutable.with();
            if (ByteLongHashMap.this.sentinelValues != null) {
                if (ByteLongHashMap.this.sentinelValues.containsZeroKey) {
                    result.add(function.valueOf((byte)0));
                }
                if (ByteLongHashMap.this.sentinelValues.containsOneKey) {
                    result.add(function.valueOf((byte)1));
                }
            }
            for (byte key : ByteLongHashMap.this.keys) {
                if (!ByteLongHashMap.isNonSentinel(key)) continue;
                result.add(function.valueOf(key));
            }
            return result;
        }

        public MutableByteSet asUnmodifiable() {
            return UnmodifiableByteSet.of(this);
        }

        public MutableByteSet asSynchronized() {
            return SynchronizedByteSet.of(this);
        }

        public long sum() {
            long sum = 0L;
            if (ByteLongHashMap.this.sentinelValues != null) {
                if (ByteLongHashMap.this.sentinelValues.containsZeroKey) {
                    sum += 0L;
                }
                if (ByteLongHashMap.this.sentinelValues.containsOneKey) {
                    ++sum;
                }
            }
            for (byte key : ByteLongHashMap.this.keys) {
                if (!ByteLongHashMap.isNonSentinel(key)) continue;
                sum += (long)key;
            }
            return sum;
        }

        public byte max() {
            if (ByteLongHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            byte max = 0;
            boolean isMaxSet = false;
            if (ByteLongHashMap.this.sentinelValues != null) {
                if (ByteLongHashMap.this.sentinelValues.containsZeroKey) {
                    max = 0;
                    isMaxSet = true;
                }
                if (ByteLongHashMap.this.sentinelValues.containsOneKey && (!isMaxSet || max < 1)) {
                    max = 1;
                    isMaxSet = true;
                }
            }
            for (int i = 0; i < ByteLongHashMap.this.keys.length; ++i) {
                if (!ByteLongHashMap.isNonSentinel(ByteLongHashMap.this.keys[i]) || isMaxSet && max >= ByteLongHashMap.this.keys[i]) continue;
                max = ByteLongHashMap.this.keys[i];
                isMaxSet = true;
            }
            return max;
        }

        public byte maxIfEmpty(byte defaultValue) {
            if (ByteLongHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.max();
        }

        public byte min() {
            if (ByteLongHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            byte min = 0;
            boolean isMinSet = false;
            if (ByteLongHashMap.this.sentinelValues != null) {
                if (ByteLongHashMap.this.sentinelValues.containsZeroKey) {
                    min = 0;
                    isMinSet = true;
                }
                if (ByteLongHashMap.this.sentinelValues.containsOneKey && (!isMinSet || 1 < min)) {
                    min = 1;
                    isMinSet = true;
                }
            }
            for (int i = 0; i < ByteLongHashMap.this.keys.length; ++i) {
                if (!ByteLongHashMap.isNonSentinel(ByteLongHashMap.this.keys[i]) || isMinSet && ByteLongHashMap.this.keys[i] >= min) continue;
                min = ByteLongHashMap.this.keys[i];
                isMinSet = true;
            }
            return min;
        }

        public byte minIfEmpty(byte defaultValue) {
            if (ByteLongHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.min();
        }

        public double average() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            return (double)this.sum() / (double)this.size();
        }

        public double median() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            byte[] sortedArray = this.toSortedArray();
            int middleIndex = sortedArray.length >> 1;
            if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
                byte first = sortedArray[middleIndex];
                byte second = sortedArray[middleIndex - 1];
                return ((double)first + (double)second) / 2.0;
            }
            return sortedArray[middleIndex];
        }

        public byte[] toSortedArray() {
            byte[] array = this.toArray();
            Arrays.sort(array);
            return array;
        }

        public MutableByteList toSortedList() {
            return ByteArrayList.newList((ByteIterable)this).sortThis();
        }

        public byte[] toArray() {
            int size = ByteLongHashMap.this.size();
            final byte[] result = new byte[size];
            ByteLongHashMap.this.forEachKey(new ByteProcedure(){
                private int index;

                public void value(byte each) {
                    result[this.index] = each;
                    ++this.index;
                }
            });
            return result;
        }

        public boolean contains(byte value) {
            return ByteLongHashMap.this.containsKey(value);
        }

        public boolean containsAll(byte ... source) {
            for (byte item : source) {
                if (ByteLongHashMap.this.containsKey(item)) continue;
                return false;
            }
            return true;
        }

        public boolean containsAll(ByteIterable source) {
            ByteIterator iterator = source.byteIterator();
            while (iterator.hasNext()) {
                if (ByteLongHashMap.this.containsKey(iterator.next())) continue;
                return false;
            }
            return true;
        }

        public MutableByteList toList() {
            return ByteArrayList.newList((ByteIterable)this);
        }

        public MutableByteSet toSet() {
            return ByteHashSet.newSet((ByteIterable)this);
        }

        public MutableByteBag toBag() {
            return ByteHashBag.newBag((ByteIterable)this);
        }

        public LazyByteIterable asLazy() {
            return new LazyByteIterableAdapter((ByteIterable)this);
        }

        public ByteSet freeze() {
            throw new UnsupportedOperationException();
        }

        public ImmutableByteSet toImmutable() {
            return ByteSets.immutable.withAll((ByteIterable)this);
        }

        public int size() {
            return ByteLongHashMap.this.size();
        }

        public boolean isEmpty() {
            return ByteLongHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return ByteLongHashMap.this.notEmpty();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ByteSet)) {
                return false;
            }
            ByteSet other = (ByteSet)obj;
            return this.size() == other.size() && this.containsAll(other.toArray());
        }

        public int hashCode() {
            int result = 0;
            if (ByteLongHashMap.this.sentinelValues != null) {
                if (ByteLongHashMap.this.sentinelValues.containsZeroKey) {
                    result += 0;
                }
                if (ByteLongHashMap.this.sentinelValues.containsOneKey) {
                    ++result;
                }
            }
            for (int i = 0; i < ByteLongHashMap.this.keys.length; ++i) {
                if (!ByteLongHashMap.isNonSentinel(ByteLongHashMap.this.keys[i])) continue;
                result += ByteLongHashMap.this.keys[i];
            }
            return result;
        }

        public String toString() {
            return this.makeString("[", ", ", "]");
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (ByteLongHashMap.this.sentinelValues != null) {
                    if (ByteLongHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(0));
                        first = false;
                    }
                    if (ByteLongHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(1));
                        first = false;
                    }
                }
                for (byte key : ByteLongHashMap.this.keys) {
                    if (!ByteLongHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(key));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class KeySetIterator
    implements ByteIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private KeySetIterator() {
        }

        public boolean hasNext() {
            return this.count < ByteLongHashMap.this.size();
        }

        public byte next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (ByteLongHashMap.this.containsKey((byte)0)) {
                    return 0;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (ByteLongHashMap.this.containsKey((byte)1)) {
                    return 1;
                }
            }
            byte[] keys = ByteLongHashMap.this.keys;
            while (!ByteLongHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            byte result = keys[this.position];
            ++this.position;
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeysView
    implements LazyByteIterable {
        private KeysView() {
        }

        public String toString() {
            return this.makeString("[", ", ", "]");
        }

        public int size() {
            return ByteLongHashMap.this.size();
        }

        public boolean isEmpty() {
            return ByteLongHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return ByteLongHashMap.this.notEmpty();
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (ByteLongHashMap.this.sentinelValues != null) {
                    if (ByteLongHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(0));
                        first = false;
                    }
                    if (ByteLongHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(1));
                        first = false;
                    }
                }
                for (byte key : ByteLongHashMap.this.keys) {
                    if (!ByteLongHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(key));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public ByteIterator byteIterator() {
            return new KeySetIterator();
        }

        public boolean contains(byte key) {
            return ByteLongHashMap.this.containsKey(key);
        }

        public boolean containsAll(byte ... keys) {
            for (byte key : keys) {
                if (ByteLongHashMap.this.containsKey(key)) continue;
                return false;
            }
            return true;
        }

        public boolean containsAll(ByteIterable source) {
            return source.allSatisfy(new BytePredicate(){

                public boolean accept(byte key) {
                    return ByteLongHashMap.this.containsKey(key);
                }
            });
        }

        public void forEach(ByteProcedure procedure) {
            ByteLongHashMap.this.forEachKey(procedure);
        }

        public int count(BytePredicate predicate) {
            int count = 0;
            if (ByteLongHashMap.this.sentinelValues != null) {
                if (ByteLongHashMap.this.sentinelValues.containsZeroKey && predicate.accept((byte)0)) {
                    ++count;
                }
                if (ByteLongHashMap.this.sentinelValues.containsOneKey && predicate.accept((byte)1)) {
                    ++count;
                }
            }
            for (byte key : ByteLongHashMap.this.keys) {
                if (!ByteLongHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                ++count;
            }
            return count;
        }

        public boolean anySatisfy(BytePredicate predicate) {
            if (ByteLongHashMap.this.sentinelValues != null) {
                if (ByteLongHashMap.this.sentinelValues.containsZeroKey && predicate.accept((byte)0)) {
                    return true;
                }
                if (ByteLongHashMap.this.sentinelValues.containsOneKey && predicate.accept((byte)1)) {
                    return true;
                }
            }
            for (byte key : ByteLongHashMap.this.keys) {
                if (!ByteLongHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return true;
            }
            return false;
        }

        public boolean allSatisfy(BytePredicate predicate) {
            if (ByteLongHashMap.this.sentinelValues != null) {
                if (ByteLongHashMap.this.sentinelValues.containsZeroKey && !predicate.accept((byte)0)) {
                    return false;
                }
                if (ByteLongHashMap.this.sentinelValues.containsOneKey && !predicate.accept((byte)1)) {
                    return false;
                }
            }
            for (byte key : ByteLongHashMap.this.keys) {
                if (!ByteLongHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean noneSatisfy(BytePredicate predicate) {
            if (ByteLongHashMap.this.sentinelValues != null) {
                if (ByteLongHashMap.this.sentinelValues.containsZeroKey && predicate.accept((byte)0)) {
                    return false;
                }
                if (ByteLongHashMap.this.sentinelValues.containsOneKey && predicate.accept((byte)1)) {
                    return false;
                }
            }
            for (byte key : ByteLongHashMap.this.keys) {
                if (!ByteLongHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public LazyByteIterable select(BytePredicate predicate) {
            return new SelectByteIterable((ByteIterable)this, predicate);
        }

        public LazyByteIterable reject(BytePredicate predicate) {
            return new SelectByteIterable((ByteIterable)this, BytePredicates.not(predicate));
        }

        public byte detectIfNone(BytePredicate predicate, byte value) {
            if (ByteLongHashMap.this.sentinelValues != null) {
                if (ByteLongHashMap.this.sentinelValues.containsZeroKey && predicate.accept((byte)0)) {
                    return 0;
                }
                if (ByteLongHashMap.this.sentinelValues.containsOneKey && predicate.accept((byte)1)) {
                    return 1;
                }
            }
            for (byte key : ByteLongHashMap.this.keys) {
                if (!ByteLongHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return key;
            }
            return value;
        }

        public <V> LazyIterable<V> collect(ByteToObjectFunction<? extends V> function) {
            return new CollectByteToObjectIterable<V>((ByteIterable)this, function);
        }

        public long sum() {
            long result = 0L;
            if (ByteLongHashMap.this.sentinelValues != null) {
                if (ByteLongHashMap.this.sentinelValues.containsZeroKey) {
                    result += 0L;
                }
                if (ByteLongHashMap.this.sentinelValues.containsOneKey) {
                    ++result;
                }
            }
            for (byte key : ByteLongHashMap.this.keys) {
                if (!ByteLongHashMap.isNonSentinel(key)) continue;
                result += (long)key;
            }
            return result;
        }

        public byte max() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            ByteIterator iterator = this.byteIterator();
            byte max = iterator.next();
            while (iterator.hasNext()) {
                byte value = iterator.next();
                if (max >= value) continue;
                max = value;
            }
            return max;
        }

        public byte min() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            ByteIterator iterator = this.byteIterator();
            byte min = iterator.next();
            while (iterator.hasNext()) {
                byte value = iterator.next();
                if (value >= min) continue;
                min = value;
            }
            return min;
        }

        public byte minIfEmpty(byte defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.min();
        }

        public byte maxIfEmpty(byte defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.max();
        }

        public double average() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            return (double)this.sum() / (double)this.size();
        }

        public double median() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            byte[] sortedArray = this.toSortedArray();
            int middleIndex = sortedArray.length >> 1;
            if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
                byte first = sortedArray[middleIndex];
                byte second = sortedArray[middleIndex - 1];
                return ((double)first + (double)second) / 2.0;
            }
            return sortedArray[middleIndex];
        }

        public byte[] toSortedArray() {
            byte[] array = this.toArray();
            Arrays.sort(array);
            return array;
        }

        public byte[] toArray() {
            int size = ByteLongHashMap.this.size();
            final byte[] result = new byte[size];
            ByteLongHashMap.this.forEachKey(new ByteProcedure(){
                private int index;

                public void value(byte each) {
                    result[this.index] = each;
                    ++this.index;
                }
            });
            return result;
        }

        public MutableByteList toList() {
            return ByteArrayList.newList((ByteIterable)this);
        }

        public MutableByteList toSortedList() {
            return ByteArrayList.newList((ByteIterable)this).sortThis();
        }

        public MutableByteSet toSet() {
            return ByteHashSet.newSet((ByteIterable)this);
        }

        public MutableByteBag toBag() {
            return ByteHashBag.newBag((ByteIterable)this);
        }

        public LazyByteIterable asLazy() {
            return this;
        }
    }

    private class InternalLongIterator
    implements LongIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private InternalLongIterator() {
        }

        public boolean hasNext() {
            return this.count < ByteLongHashMap.this.size();
        }

        public long next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (ByteLongHashMap.this.containsKey((byte)0)) {
                    return ByteLongHashMap.this.get((byte)0);
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (ByteLongHashMap.this.containsKey((byte)1)) {
                    return ByteLongHashMap.this.get((byte)1);
                }
            }
            byte[] keys = ByteLongHashMap.this.keys;
            while (!ByteLongHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            long result = ByteLongHashMap.this.values[this.position];
            ++this.position;
            return result;
        }
    }

    private static final class SentinelValues {
        private boolean containsZeroKey;
        private boolean containsOneKey;
        private long zeroValue;
        private long oneValue;

        private SentinelValues() {
        }

        public int size() {
            return (this.containsZeroKey ? 1 : 0) + (this.containsOneKey ? 1 : 0);
        }

        public boolean containsValue(long value) {
            boolean valueEqualsZeroValue = this.containsZeroKey && this.zeroValue == value;
            boolean valueEqualsOneValue = this.containsOneKey && this.oneValue == value;
            return valueEqualsZeroValue || valueEqualsOneValue;
        }
    }
}

