/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.mutable.primitive;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.IntIterable;
import com.gs.collections.api.LazyDoubleIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.bag.primitive.MutableIntBag;
import com.gs.collections.api.block.function.primitive.DoubleToIntFunction;
import com.gs.collections.api.block.function.primitive.IntFunction;
import com.gs.collections.api.block.function.primitive.IntFunction0;
import com.gs.collections.api.block.function.primitive.IntToIntFunction;
import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.DoubleIntPredicate;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.procedure.primitive.DoubleIntProcedure;
import com.gs.collections.api.block.procedure.primitive.DoubleProcedure;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableIntCollection;
import com.gs.collections.api.iterator.IntIterator;
import com.gs.collections.api.list.primitive.MutableIntList;
import com.gs.collections.api.map.primitive.DoubleIntMap;
import com.gs.collections.api.map.primitive.ImmutableDoubleIntMap;
import com.gs.collections.api.map.primitive.MutableDoubleIntMap;
import com.gs.collections.api.set.primitive.MutableDoubleSet;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.impl.factory.primitive.DoubleIntMaps;
import com.gs.collections.impl.map.mutable.primitive.UnmodifiableDoubleIntMap;
import java.io.Serializable;
import net.jcip.annotations.GuardedBy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SynchronizedDoubleIntMap
implements MutableDoubleIntMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Object lock;
    @GuardedBy(value="this.lock")
    private final MutableDoubleIntMap map;

    SynchronizedDoubleIntMap(MutableDoubleIntMap map) {
        this(map, null);
    }

    SynchronizedDoubleIntMap(MutableDoubleIntMap map, Object newLock) {
        this.map = map;
        this.lock = newLock == null ? this : newLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.map.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(double key, int value) {
        Object object = this.lock;
        synchronized (object) {
            this.map.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(DoubleIntMap map) {
        Object object = this.lock;
        synchronized (object) {
            this.map.putAll(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeKey(double key) {
        Object object = this.lock;
        synchronized (object) {
            this.map.removeKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(double key) {
        Object object = this.lock;
        synchronized (object) {
            this.map.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeKeyIfAbsent(double key, int value) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.removeKeyIfAbsent(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIfAbsentPut(double key, int value) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.getIfAbsentPut(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIfAbsentPut(double key, IntFunction0 function) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.getIfAbsentPut(key, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIfAbsentPutWithKey(double key, DoubleToIntFunction function) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.getIfAbsentPutWithKey(key, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> int getIfAbsentPutWith(double key, IntFunction<? super P> function, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.getIfAbsentPutWith(key, function, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateValue(double key, int initialValueIfAbsent, IntToIntFunction function) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.updateValue(key, initialValueIfAbsent, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get(double key) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIfAbsent(double key, int ifAbsent) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.getIfAbsent(key, ifAbsent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOrThrow(double key) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.getOrThrow(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(double key) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValue(int value) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.containsValue(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachValue(IntProcedure procedure) {
        Object object = this.lock;
        synchronized (object) {
            this.map.forEachValue(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachKey(DoubleProcedure procedure) {
        Object object = this.lock;
        synchronized (object) {
            this.map.forEachKey(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachKeyValue(DoubleIntProcedure procedure) {
        Object object = this.lock;
        synchronized (object) {
            this.map.forEachKeyValue(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LazyDoubleIterable keysView() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.keysView();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableDoubleIntMap select(DoubleIntPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableDoubleIntMap reject(DoubleIntPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.reject(predicate);
        }
    }

    public IntIterator intIterator() {
        return this.map.intIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEach(IntProcedure procedure) {
        Object object = this.lock;
        synchronized (object) {
            this.map.forEach(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int count(IntPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.count(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean anySatisfy(IntPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.anySatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean allSatisfy(IntPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.allSatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean noneSatisfy(IntPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.noneSatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableIntCollection select(IntPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableIntCollection reject(IntPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.reject(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int detectIfNone(IntPredicate predicate, int ifNone) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.detectIfNone(predicate, ifNone);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> MutableCollection<V> collect(IntToObjectFunction<? extends V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.collect(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long sum() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.sum();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int max() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.max();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int maxIfEmpty(int defaultValue) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.maxIfEmpty(defaultValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int min() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.min();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int minIfEmpty(int defaultValue) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.minIfEmpty(defaultValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double average() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.average();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double median() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.median();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] toSortedArray() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toSortedArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableIntList toSortedList() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toSortedList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] toArray() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(int value) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.contains(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(int ... source) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.containsAll(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(IntIterable source) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.containsAll(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableIntList toList() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableIntSet toSet() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableIntBag toBag() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toBag();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LazyIntIterable asLazy() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.asLazy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableDoubleIntMap withKeyValue(double key, int value) {
        Object object = this.lock;
        synchronized (object) {
            this.map.withKeyValue(key, value);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableDoubleIntMap withoutKey(double key) {
        Object object = this.lock;
        synchronized (object) {
            this.map.withoutKey(key);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableDoubleIntMap withoutAllKeys(DoubleIterable keys) {
        Object object = this.lock;
        synchronized (object) {
            this.map.withoutAllKeys(keys);
        }
        return this;
    }

    public MutableDoubleIntMap asUnmodifiable() {
        return new UnmodifiableDoubleIntMap(this);
    }

    public MutableDoubleIntMap asSynchronized() {
        return this;
    }

    public ImmutableDoubleIntMap toImmutable() {
        return DoubleIntMaps.immutable.withAll((DoubleIntMap)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean notEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.notEmpty();
        }
    }

    public MutableDoubleSet keySet() {
        throw new UnsupportedOperationException("keySet is not implemented yet!");
    }

    public MutableIntCollection values() {
        throw new UnsupportedOperationException("values is not implemented yet!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object otherMap) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.equals(otherMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String makeString() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.makeString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String makeString(String separator) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.makeString(separator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String makeString(String start, String separator, String end) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.makeString(start, separator, end);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendString(Appendable appendable) {
        Object object = this.lock;
        synchronized (object) {
            this.map.appendString(appendable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendString(Appendable appendable, String separator) {
        Object object = this.lock;
        synchronized (object) {
            this.map.appendString(appendable, separator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendString(Appendable appendable, String start, String separator, String end) {
        Object object = this.lock;
        synchronized (object) {
            this.map.appendString(appendable, start, separator, end);
        }
    }
}

