/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.mutable.primitive;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.MutableBag;
import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.function.Function0;
import com.gs.collections.api.block.function.Function2;
import com.gs.collections.api.block.function.primitive.BooleanFunction;
import com.gs.collections.api.block.function.primitive.ByteFunction;
import com.gs.collections.api.block.function.primitive.CharFunction;
import com.gs.collections.api.block.function.primitive.DoubleFunction;
import com.gs.collections.api.block.function.primitive.DoubleObjectToDoubleFunction;
import com.gs.collections.api.block.function.primitive.DoubleToObjectFunction;
import com.gs.collections.api.block.function.primitive.FloatFunction;
import com.gs.collections.api.block.function.primitive.FloatObjectToFloatFunction;
import com.gs.collections.api.block.function.primitive.IntFunction;
import com.gs.collections.api.block.function.primitive.IntObjectToIntFunction;
import com.gs.collections.api.block.function.primitive.LongFunction;
import com.gs.collections.api.block.function.primitive.LongObjectToLongFunction;
import com.gs.collections.api.block.function.primitive.ShortFunction;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.predicate.Predicate2;
import com.gs.collections.api.block.predicate.primitive.DoubleObjectPredicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.DoubleObjectProcedure;
import com.gs.collections.api.block.procedure.primitive.DoubleProcedure;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableBooleanCollection;
import com.gs.collections.api.collection.primitive.MutableByteCollection;
import com.gs.collections.api.collection.primitive.MutableCharCollection;
import com.gs.collections.api.collection.primitive.MutableDoubleCollection;
import com.gs.collections.api.collection.primitive.MutableFloatCollection;
import com.gs.collections.api.collection.primitive.MutableIntCollection;
import com.gs.collections.api.collection.primitive.MutableLongCollection;
import com.gs.collections.api.collection.primitive.MutableShortCollection;
import com.gs.collections.api.list.MutableList;
import com.gs.collections.api.map.MutableMap;
import com.gs.collections.api.map.primitive.DoubleObjectMap;
import com.gs.collections.api.map.primitive.ImmutableDoubleObjectMap;
import com.gs.collections.api.map.primitive.MutableDoubleObjectMap;
import com.gs.collections.api.map.sorted.MutableSortedMap;
import com.gs.collections.api.multimap.MutableMultimap;
import com.gs.collections.api.partition.PartitionMutableCollection;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.primitive.MutableDoubleSet;
import com.gs.collections.api.set.sorted.MutableSortedSet;
import com.gs.collections.api.tuple.Pair;
import com.gs.collections.impl.UnmodifiableIteratorAdapter;
import com.gs.collections.impl.factory.primitive.DoubleObjectMaps;
import com.gs.collections.impl.map.mutable.primitive.SynchronizedDoubleObjectMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UnmodifiableDoubleObjectMap<V>
implements MutableDoubleObjectMap<V>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableDoubleObjectMap<V> map;

    UnmodifiableDoubleObjectMap(MutableDoubleObjectMap<V> map) {
        this.map = map;
    }

    private boolean isAbsent(V result, double key) {
        return result == null && !this.containsKey(key);
    }

    private V getIfAbsentThrow(double key) {
        Object result = this.map.get(key);
        if (this.isAbsent(result, key)) {
            throw new UnsupportedOperationException("Cannot add to an " + this.getClass().getSimpleName());
        }
        return (V)result;
    }

    public V put(double key, V value) {
        throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
    }

    public V removeKey(double key) {
        throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
    }

    public V remove(double key) {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    public V getIfAbsentPut(double key, Function0<? extends V> function) {
        return this.getIfAbsentThrow(key);
    }

    public V getIfAbsentPut(double key, V value) {
        return this.getIfAbsentThrow(key);
    }

    public V getIfAbsentPutWithKey(double key, DoubleToObjectFunction<? extends V> function) {
        return this.getIfAbsentThrow(key);
    }

    public <P> V getIfAbsentPutWith(double key, Function<? super P, ? extends V> function, P parameter) {
        return this.getIfAbsentThrow(key);
    }

    public V updateValue(double key, Function0<? extends V> factory, Function<? super V, ? extends V> function) {
        throw new UnsupportedOperationException("Cannot call updateValue() on " + this.getClass().getSimpleName());
    }

    public <P> V updateValueWith(double key, Function0<? extends V> factory, Function2<? super V, ? super P, ? extends V> function, P parameter) {
        throw new UnsupportedOperationException("Cannot call updateValueWith() on " + this.getClass().getSimpleName());
    }

    public V get(double key) {
        return (V)this.map.get(key);
    }

    public V getIfAbsent(double key, Function0<? extends V> ifAbsent) {
        return (V)this.map.getIfAbsent(key, ifAbsent);
    }

    public boolean containsKey(double key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    public void forEachValue(Procedure<? super V> procedure) {
        this.map.forEachValue(procedure);
    }

    public void forEachKey(DoubleProcedure procedure) {
        this.map.forEachKey(procedure);
    }

    public void forEachKeyValue(DoubleObjectProcedure<? super V> procedure) {
        this.map.forEachKeyValue(procedure);
    }

    public MutableDoubleObjectMap<V> select(DoubleObjectPredicate<? super V> predicate) {
        return this.map.select(predicate);
    }

    public MutableDoubleObjectMap<V> reject(DoubleObjectPredicate<? super V> predicate) {
        return this.map.reject(predicate);
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean notEmpty() {
        return this.map.notEmpty();
    }

    public V getFirst() {
        return (V)this.map.getFirst();
    }

    public V getLast() {
        return (V)this.map.getLast();
    }

    public boolean contains(Object object) {
        return this.map.contains(object);
    }

    public boolean containsAllIterable(Iterable<?> source) {
        return this.map.containsAllIterable(source);
    }

    public boolean containsAll(Collection<?> source) {
        return this.map.containsAll(source);
    }

    public boolean containsAllArguments(Object ... elements) {
        return this.map.containsAllArguments(elements);
    }

    public MutableCollection<V> select(Predicate<? super V> predicate) {
        return this.map.select(predicate);
    }

    public <R extends Collection<V>> R select(Predicate<? super V> predicate, R target) {
        return (R)this.map.select(predicate, target);
    }

    public <P, R extends Collection<V>> R selectWith(Predicate2<? super V, ? super P> predicate, P parameter, R targetCollection) {
        return (R)this.map.selectWith(predicate, parameter, targetCollection);
    }

    public PartitionMutableCollection<V> partition(Predicate<? super V> predicate) {
        return this.map.partition(predicate);
    }

    public <S> MutableCollection<S> selectInstancesOf(Class<S> clazz) {
        return this.map.selectInstancesOf(clazz);
    }

    public MutableList<Pair<V, Integer>> zipWithIndex() {
        return (MutableList)this.map.zipWithIndex();
    }

    public <R extends Collection<Pair<V, Integer>>> R zipWithIndex(R target) {
        return (R)this.map.zipWithIndex(target);
    }

    public RichIterable<RichIterable<V>> chunk(int size) {
        return this.map.chunk(size);
    }

    public <K, V1> MutableMap<K, V1> aggregateInPlaceBy(Function<? super V, ? extends K> groupBy, Function0<? extends V1> zeroValueFactory, Procedure2<? super V1, ? super V> mutatingAggregator) {
        return this.map.aggregateInPlaceBy(groupBy, zeroValueFactory, mutatingAggregator);
    }

    public <K, V1> MutableMap<K, V1> aggregateBy(Function<? super V, ? extends K> groupBy, Function0<? extends V1> zeroValueFactory, Function2<? super V1, ? super V, ? extends V1> nonMutatingAggregator) {
        return this.map.aggregateBy(groupBy, zeroValueFactory, nonMutatingAggregator);
    }

    public MutableCollection<V> reject(Predicate<? super V> predicate) {
        return this.map.reject(predicate);
    }

    public <R extends Collection<V>> R reject(Predicate<? super V> predicate, R target) {
        return (R)this.map.reject(predicate, target);
    }

    public <P, R extends Collection<V>> R rejectWith(Predicate2<? super V, ? super P> predicate, P parameter, R targetCollection) {
        return (R)this.map.rejectWith(predicate, parameter, targetCollection);
    }

    public void clear() {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public <V1> MutableCollection<V1> collect(Function<? super V, ? extends V1> function) {
        return this.map.collect(function);
    }

    public MutableBooleanCollection collectBoolean(BooleanFunction<? super V> booleanFunction) {
        return this.map.collectBoolean(booleanFunction);
    }

    public MutableByteCollection collectByte(ByteFunction<? super V> byteFunction) {
        return this.map.collectByte(byteFunction);
    }

    public MutableCharCollection collectChar(CharFunction<? super V> charFunction) {
        return this.map.collectChar(charFunction);
    }

    public MutableDoubleCollection collectDouble(DoubleFunction<? super V> doubleFunction) {
        return this.map.collectDouble(doubleFunction);
    }

    public MutableFloatCollection collectFloat(FloatFunction<? super V> floatFunction) {
        return this.map.collectFloat(floatFunction);
    }

    public MutableIntCollection collectInt(IntFunction<? super V> intFunction) {
        return this.map.collectInt(intFunction);
    }

    public MutableLongCollection collectLong(LongFunction<? super V> longFunction) {
        return this.map.collectLong(longFunction);
    }

    public MutableShortCollection collectShort(ShortFunction<? super V> shortFunction) {
        return this.map.collectShort(shortFunction);
    }

    public <P, V1, R extends Collection<V1>> R collectWith(Function2<? super V, ? super P, ? extends V1> function, P parameter, R targetCollection) {
        return (R)this.map.collectWith(function, parameter, targetCollection);
    }

    public <V1, R extends Collection<V1>> R collect(Function<? super V, ? extends V1> function, R target) {
        return (R)this.map.collect(function, target);
    }

    public <V1> MutableCollection<V1> collectIf(Predicate<? super V> predicate, Function<? super V, ? extends V1> function) {
        return this.map.collectIf(predicate, function);
    }

    public <V1, R extends Collection<V1>> R collectIf(Predicate<? super V> predicate, Function<? super V, ? extends V1> function, R target) {
        return (R)this.map.collectIf(predicate, function, target);
    }

    public <V1> RichIterable<V1> flatCollect(Function<? super V, ? extends Iterable<V1>> function) {
        return this.map.flatCollect(function);
    }

    public <V1, R extends Collection<V1>> R flatCollect(Function<? super V, ? extends Iterable<V1>> function, R target) {
        return (R)this.map.flatCollect(function, target);
    }

    public V detect(Predicate<? super V> predicate) {
        return (V)this.map.detect(predicate);
    }

    public V detectIfNone(Predicate<? super V> predicate, Function0<? extends V> function) {
        return (V)this.map.detectIfNone(predicate, function);
    }

    public int count(Predicate<? super V> predicate) {
        return this.map.count(predicate);
    }

    public boolean anySatisfy(Predicate<? super V> predicate) {
        return this.map.anySatisfy(predicate);
    }

    public boolean allSatisfy(Predicate<? super V> predicate) {
        return this.map.allSatisfy(predicate);
    }

    public boolean noneSatisfy(Predicate<? super V> predicate) {
        return this.map.noneSatisfy(predicate);
    }

    public <IV> IV injectInto(IV injectedValue, Function2<? super IV, ? super V, ? extends IV> function) {
        return (IV)this.map.injectInto(injectedValue, function);
    }

    public int injectInto(int injectedValue, IntObjectToIntFunction<? super V> function) {
        return this.map.injectInto(injectedValue, function);
    }

    public long injectInto(long injectedValue, LongObjectToLongFunction<? super V> function) {
        return this.map.injectInto(injectedValue, function);
    }

    public float injectInto(float injectedValue, FloatObjectToFloatFunction<? super V> function) {
        return this.map.injectInto(injectedValue, function);
    }

    public double injectInto(double injectedValue, DoubleObjectToDoubleFunction<? super V> function) {
        return this.map.injectInto(injectedValue, function);
    }

    public MutableList<V> toList() {
        return this.map.toList();
    }

    public MutableList<V> toSortedList() {
        return this.map.toSortedList();
    }

    public MutableList<V> toSortedList(Comparator<? super V> comparator) {
        return this.map.toSortedList(comparator);
    }

    public <V1 extends Comparable<? super V1>> MutableList<V> toSortedListBy(Function<? super V, ? extends V1> function) {
        return this.map.toSortedListBy(function);
    }

    public MutableSet<V> toSet() {
        return this.map.toSet();
    }

    public MutableSortedSet<V> toSortedSet() {
        return this.map.toSortedSet();
    }

    public MutableSortedSet<V> toSortedSet(Comparator<? super V> comparator) {
        return this.map.toSortedSet(comparator);
    }

    public <V1 extends Comparable<? super V1>> MutableSortedSet<V> toSortedSetBy(Function<? super V, ? extends V1> function) {
        return this.map.toSortedSetBy(function);
    }

    public MutableBag<V> toBag() {
        return this.map.toBag();
    }

    public <NK, NV> MutableMap<NK, NV> toMap(Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction) {
        return this.map.toMap(keyFunction, valueFunction);
    }

    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction) {
        return this.map.toSortedMap(keyFunction, valueFunction);
    }

    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Comparator<? super NK> comparator, Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction) {
        return this.map.toSortedMap(comparator, keyFunction, valueFunction);
    }

    public LazyIterable<V> asLazy() {
        return this.map.asLazy();
    }

    public Object[] toArray() {
        return this.map.toArray();
    }

    public <T> T[] toArray(T[] a) {
        return this.map.toArray((Object[])a);
    }

    public V min(Comparator<? super V> comparator) {
        return (V)this.map.min(comparator);
    }

    public V max(Comparator<? super V> comparator) {
        return (V)this.map.max(comparator);
    }

    public V min() {
        return (V)this.map.min();
    }

    public V max() {
        return (V)this.map.max();
    }

    public <V1 extends Comparable<? super V1>> V maxBy(Function<? super V, ? extends V1> function) {
        return (V)this.map.maxBy(function);
    }

    public <V1 extends Comparable<? super V1>> V minBy(Function<? super V, ? extends V1> function) {
        return (V)this.map.minBy(function);
    }

    public long sumOfInt(IntFunction<? super V> function) {
        return this.map.sumOfInt(function);
    }

    public double sumOfFloat(FloatFunction<? super V> function) {
        return this.map.sumOfFloat(function);
    }

    public long sumOfLong(LongFunction<? super V> function) {
        return this.map.sumOfLong(function);
    }

    public double sumOfDouble(DoubleFunction<? super V> function) {
        return this.map.sumOfDouble(function);
    }

    public MutableDoubleSet keySet() {
        throw new UnsupportedOperationException("keySet is not implemented yet!");
    }

    public Collection<V> values() {
        throw new UnsupportedOperationException("values is not implemented yet!");
    }

    public boolean equals(Object obj) {
        return this.map.equals(obj);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }

    public String makeString() {
        return this.map.makeString();
    }

    public String makeString(String separator) {
        return this.map.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.map.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.map.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.map.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.map.appendString(appendable, start, separator, end);
    }

    public <V1> MutableMultimap<V1, V> groupBy(Function<? super V, ? extends V1> function) {
        return this.map.groupBy(function);
    }

    public <V1, R extends MutableMultimap<V1, V>> R groupBy(Function<? super V, ? extends V1> function, R target) {
        return (R)this.map.groupBy(function, target);
    }

    public <V1> MutableMultimap<V1, V> groupByEach(Function<? super V, ? extends Iterable<V1>> function) {
        return this.map.groupByEach(function);
    }

    public <V1, R extends MutableMultimap<V1, V>> R groupByEach(Function<? super V, ? extends Iterable<V1>> function, R target) {
        return (R)this.map.groupByEach(function, target);
    }

    public <S> MutableCollection<Pair<V, S>> zip(Iterable<S> that) {
        return this.map.zip(that);
    }

    public <S, R extends Collection<Pair<V, S>>> R zip(Iterable<S> that, R target) {
        return (R)this.map.zip(that, target);
    }

    public MutableDoubleObjectMap<V> withKeyValue(double key, V value) {
        throw new UnsupportedOperationException("Cannot call withKeyValue() on " + this.getClass().getSimpleName());
    }

    public MutableDoubleObjectMap<V> withoutKey(double key) {
        throw new UnsupportedOperationException("Cannot call withoutKey() on " + this.getClass().getSimpleName());
    }

    public MutableDoubleObjectMap<V> withoutAllKeys(DoubleIterable keys) {
        throw new UnsupportedOperationException("Cannot call withoutAllKeys() on " + this.getClass().getSimpleName());
    }

    public MutableDoubleObjectMap<V> asUnmodifiable() {
        return this;
    }

    public MutableDoubleObjectMap<V> asSynchronized() {
        return new SynchronizedDoubleObjectMap(this);
    }

    public ImmutableDoubleObjectMap<V> toImmutable() {
        return DoubleObjectMaps.immutable.withAll((DoubleObjectMap)this);
    }

    public void forEach(Procedure<? super V> procedure) {
        this.map.forEach(procedure);
    }

    public void forEachWithIndex(ObjectIntProcedure<? super V> objectIntProcedure) {
        this.map.forEachWithIndex(objectIntProcedure);
    }

    public <P> void forEachWith(Procedure2<? super V, ? super P> procedure, P parameter) {
        this.map.forEachWith(procedure, parameter);
    }

    public Iterator<V> iterator() {
        return new UnmodifiableIteratorAdapter(this.map.iterator());
    }
}

