/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.mutable.primitive;

import com.gs.collections.api.BooleanIterable;
import com.gs.collections.api.LazyBooleanIterable;
import com.gs.collections.api.LazyLongIterable;
import com.gs.collections.api.LongIterable;
import com.gs.collections.api.bag.primitive.MutableBooleanBag;
import com.gs.collections.api.block.function.primitive.BooleanFunction;
import com.gs.collections.api.block.function.primitive.BooleanFunction0;
import com.gs.collections.api.block.function.primitive.BooleanToBooleanFunction;
import com.gs.collections.api.block.function.primitive.BooleanToObjectFunction;
import com.gs.collections.api.block.function.primitive.LongToBooleanFunction;
import com.gs.collections.api.block.predicate.primitive.BooleanPredicate;
import com.gs.collections.api.block.predicate.primitive.LongBooleanPredicate;
import com.gs.collections.api.block.procedure.primitive.BooleanProcedure;
import com.gs.collections.api.block.procedure.primitive.LongBooleanProcedure;
import com.gs.collections.api.block.procedure.primitive.LongProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableBooleanCollection;
import com.gs.collections.api.iterator.BooleanIterator;
import com.gs.collections.api.list.primitive.MutableBooleanList;
import com.gs.collections.api.map.primitive.ImmutableLongBooleanMap;
import com.gs.collections.api.map.primitive.LongBooleanMap;
import com.gs.collections.api.map.primitive.MutableLongBooleanMap;
import com.gs.collections.api.set.primitive.MutableBooleanSet;
import com.gs.collections.api.set.primitive.MutableLongSet;
import com.gs.collections.impl.factory.primitive.LongBooleanMaps;
import com.gs.collections.impl.map.mutable.primitive.SynchronizedLongBooleanMap;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UnmodifiableLongBooleanMap
implements MutableLongBooleanMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableLongBooleanMap map;

    UnmodifiableLongBooleanMap(MutableLongBooleanMap map) {
        this.map = map;
    }

    private boolean isAbsent(boolean result, long key) {
        return !result && !this.containsKey(key);
    }

    private boolean getIfAbsentThrow(long key) {
        boolean result = this.map.get(key);
        if (this.isAbsent(result, key)) {
            throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
        }
        return result;
    }

    public void clear() {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public void put(long key, boolean value) {
        throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
    }

    public void putAll(LongBooleanMap map) {
        throw new UnsupportedOperationException("Cannot call putAll() on " + this.getClass().getSimpleName());
    }

    public void removeKey(long key) {
        throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
    }

    public void remove(long key) {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    public boolean removeKeyIfAbsent(long key, boolean value) {
        if (this.map.containsKey(key)) {
            throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
        }
        return value;
    }

    public boolean getIfAbsentPut(long key, boolean value) {
        return this.getIfAbsentThrow(key);
    }

    public boolean getIfAbsentPut(long key, BooleanFunction0 function) {
        return this.getIfAbsentThrow(key);
    }

    public boolean getIfAbsentPutWithKey(long key, LongToBooleanFunction function) {
        return this.getIfAbsentThrow(key);
    }

    public <P> boolean getIfAbsentPutWith(long key, BooleanFunction<? super P> function, P parameter) {
        return this.getIfAbsentThrow(key);
    }

    public boolean updateValue(long key, boolean initialValueIfAbsent, BooleanToBooleanFunction function) {
        throw new UnsupportedOperationException("Cannot call updateValue() on " + this.getClass().getSimpleName());
    }

    public boolean get(long key) {
        return this.map.get(key);
    }

    public boolean getIfAbsent(long key, boolean ifAbsent) {
        return this.map.getIfAbsent(key, ifAbsent);
    }

    public boolean getOrThrow(long key) {
        return this.map.getOrThrow(key);
    }

    public boolean containsKey(long key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(boolean value) {
        return this.map.containsValue(value);
    }

    public void forEachValue(BooleanProcedure procedure) {
        this.map.forEachValue(procedure);
    }

    public void forEachKey(LongProcedure procedure) {
        this.map.forEachKey(procedure);
    }

    public void forEachKeyValue(LongBooleanProcedure procedure) {
        this.map.forEachKeyValue(procedure);
    }

    public LazyLongIterable keysView() {
        return this.map.keysView();
    }

    public MutableLongBooleanMap select(LongBooleanPredicate predicate) {
        return this.map.select(predicate);
    }

    public MutableLongBooleanMap reject(LongBooleanPredicate predicate) {
        return this.map.reject(predicate);
    }

    public BooleanIterator booleanIterator() {
        return this.map.booleanIterator();
    }

    public void forEach(BooleanProcedure procedure) {
        this.map.forEach(procedure);
    }

    public int count(BooleanPredicate predicate) {
        return this.map.count(predicate);
    }

    public boolean anySatisfy(BooleanPredicate predicate) {
        return this.map.anySatisfy(predicate);
    }

    public boolean allSatisfy(BooleanPredicate predicate) {
        return this.map.allSatisfy(predicate);
    }

    public boolean noneSatisfy(BooleanPredicate predicate) {
        return this.map.noneSatisfy(predicate);
    }

    public MutableBooleanCollection select(BooleanPredicate predicate) {
        return this.map.select(predicate);
    }

    public MutableBooleanCollection reject(BooleanPredicate predicate) {
        return this.map.reject(predicate);
    }

    public boolean detectIfNone(BooleanPredicate predicate, boolean ifNone) {
        return this.map.detectIfNone(predicate, ifNone);
    }

    public <V> MutableCollection<V> collect(BooleanToObjectFunction<? extends V> function) {
        return this.map.collect(function);
    }

    public boolean[] toArray() {
        return this.map.toArray();
    }

    public boolean contains(boolean value) {
        return this.map.contains(value);
    }

    public boolean containsAll(boolean ... source) {
        return this.map.containsAll(source);
    }

    public boolean containsAll(BooleanIterable source) {
        return this.map.containsAll(source);
    }

    public MutableBooleanList toList() {
        return this.map.toList();
    }

    public MutableBooleanSet toSet() {
        return this.map.toSet();
    }

    public MutableBooleanBag toBag() {
        return this.map.toBag();
    }

    public LazyBooleanIterable asLazy() {
        return this.map.asLazy();
    }

    public MutableLongBooleanMap withKeyValue(long key, boolean value) {
        throw new UnsupportedOperationException("Cannot call withKeyValue() on " + this.getClass().getSimpleName());
    }

    public MutableLongBooleanMap withoutKey(long key) {
        throw new UnsupportedOperationException("Cannot call withoutKey() on " + this.getClass().getSimpleName());
    }

    public MutableLongBooleanMap withoutAllKeys(LongIterable keys) {
        throw new UnsupportedOperationException("Cannot call withoutAllKeys() on " + this.getClass().getSimpleName());
    }

    public MutableLongBooleanMap asUnmodifiable() {
        return this;
    }

    public MutableLongBooleanMap asSynchronized() {
        return new SynchronizedLongBooleanMap(this);
    }

    public ImmutableLongBooleanMap toImmutable() {
        return LongBooleanMaps.immutable.withAll((LongBooleanMap)this);
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean notEmpty() {
        return this.map.notEmpty();
    }

    public MutableLongSet keySet() {
        throw new UnsupportedOperationException("keySet is not implemented yet!");
    }

    public MutableBooleanCollection values() {
        throw new UnsupportedOperationException("values is not implemented yet!");
    }

    public boolean equals(Object otherMap) {
        return this.map.equals(otherMap);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }

    public String makeString() {
        return this.map.makeString();
    }

    public String makeString(String separator) {
        return this.map.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.map.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.map.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.map.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.map.appendString(appendable, start, separator, end);
    }
}

