/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.set.mutable.primitive;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.LazyFloatIterable;
import com.gs.collections.api.bag.primitive.MutableFloatBag;
import com.gs.collections.api.block.function.primitive.FloatToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.FloatPredicate;
import com.gs.collections.api.block.procedure.primitive.FloatProcedure;
import com.gs.collections.api.iterator.FloatIterator;
import com.gs.collections.api.list.primitive.MutableFloatList;
import com.gs.collections.api.set.ImmutableSet;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.primitive.FloatSet;
import com.gs.collections.api.set.primitive.ImmutableFloatSet;
import com.gs.collections.api.set.primitive.MutableFloatSet;
import com.gs.collections.impl.bag.mutable.primitive.FloatHashBag;
import com.gs.collections.impl.factory.primitive.FloatSets;
import com.gs.collections.impl.lazy.primitive.LazyFloatIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.FloatArrayList;
import com.gs.collections.impl.set.immutable.primitive.ImmutableFloatSetSerializationProxy;
import com.gs.collections.impl.set.mutable.UnifiedSet;
import com.gs.collections.impl.set.mutable.primitive.SynchronizedFloatSet;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableFloatSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Arrays;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FloatHashSet
implements MutableFloatSet,
Externalizable {
    private static final long serialVersionUID = 1L;
    private static final int OCCUPIED_DATA_RATIO = 2;
    private static final int OCCUPIED_SENTINEL_RATIO = 4;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private static final float EMPTY = 0.0f;
    private static final float REMOVED = 1.0f;
    private float[] table;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private int zeroToThirtyOne;
    private int zeroToThirtyOneOccupied;
    private transient boolean copyOnWrite;

    public FloatHashSet() {
        this.allocateTable(16);
    }

    public FloatHashSet(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(initialCapacity * 2));
        this.allocateTable(capacity);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    private int fastCeil(float v) {
        int possibleResult = (int)v;
        if (v - (float)possibleResult > 0.0f) {
            ++possibleResult;
        }
        return possibleResult;
    }

    public FloatHashSet(FloatHashSet set) {
        this.occupiedWithData = set.occupiedWithData;
        this.occupiedWithSentinels = set.occupiedWithSentinels;
        this.zeroToThirtyOneOccupied = set.zeroToThirtyOneOccupied;
        this.zeroToThirtyOne = set.zeroToThirtyOne;
        this.allocateTable(set.table.length);
        System.arraycopy(set.table, 0, this.table, 0, set.table.length);
    }

    public static FloatHashSet newSet(FloatIterable source) {
        if (source instanceof FloatHashSet) {
            return new FloatHashSet((FloatHashSet)source);
        }
        return FloatHashSet.newSetWith(source.toArray());
    }

    public static FloatHashSet newSetWith(float ... source) {
        FloatHashSet result = new FloatHashSet();
        result.addAll(source);
        return result;
    }

    private static boolean isBetweenZeroAndThirtyOne(float value) {
        return value >= 0.0f && value <= 31.0f && Double.compare(value, Math.floor(value)) == 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FloatSet)) {
            return false;
        }
        FloatSet other = (FloatSet)obj;
        return this.size() == other.size() && this.containsAll(other.toArray());
    }

    public int hashCode() {
        float value;
        int result = 0;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            result += Float.floatToIntBits(value);
        }
        if (this.table != null) {
            for (int i = 0; i < this.table.length; ++i) {
                if (!FloatHashSet.isNonSentinel(this.table[i])) continue;
                result += Float.floatToIntBits(this.table[i]);
            }
        }
        return result;
    }

    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    public int size() {
        return this.occupiedWithData + this.zeroToThirtyOneOccupied;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean notEmpty() {
        return this.size() != 0;
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            float value;
            appendable.append(start);
            int count = 0;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                if (count > 0) {
                    appendable.append(separator);
                }
                ++count;
                appendable.append(String.valueOf(value));
            }
            for (float value2 : this.table) {
                if (!FloatHashSet.isNonSentinel(value2)) continue;
                if (count > 0) {
                    appendable.append(separator);
                }
                ++count;
                appendable.append(String.valueOf(value2));
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean add(float element) {
        if (FloatHashSet.isBetweenZeroAndThirtyOne(element)) {
            int initial = this.zeroToThirtyOne;
            this.zeroToThirtyOne |= 1 << (int)element;
            if (this.zeroToThirtyOne != initial) {
                ++this.zeroToThirtyOneOccupied;
                return true;
            }
            return false;
        }
        int index = this.probe(element);
        if (Float.compare(this.table[index], element) == 0) {
            return false;
        }
        if (this.copyOnWrite) {
            this.copyTable();
        }
        if (Float.compare(this.table[index], 1.0f) == 0) {
            --this.occupiedWithSentinels;
        }
        this.table[index] = element;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return true;
    }

    public boolean addAll(float ... source) {
        int oldSize = this.size();
        for (float item : source) {
            this.add(item);
        }
        return this.size() != oldSize;
    }

    public boolean addAll(FloatIterable source) {
        if (source.isEmpty()) {
            return false;
        }
        int oldSize = this.size();
        if (source instanceof FloatHashSet) {
            FloatHashSet hashSet = (FloatHashSet)source;
            this.zeroToThirtyOne |= hashSet.zeroToThirtyOne;
            this.zeroToThirtyOneOccupied = Integer.bitCount(this.zeroToThirtyOne);
            for (float item : hashSet.table) {
                if (!FloatHashSet.isNonSentinel(item)) continue;
                this.add(item);
            }
        } else {
            FloatIterator iterator = source.floatIterator();
            while (iterator.hasNext()) {
                float item = iterator.next();
                this.add(item);
            }
        }
        return this.size() != oldSize;
    }

    public boolean remove(float value) {
        if (FloatHashSet.isBetweenZeroAndThirtyOne(value)) {
            int initial = this.zeroToThirtyOne;
            this.zeroToThirtyOne &= ~(1 << (int)value);
            if (this.zeroToThirtyOne == initial) {
                return false;
            }
            --this.zeroToThirtyOneOccupied;
            return true;
        }
        int index = this.probe(value);
        if (Float.compare(this.table[index], value) == 0) {
            if (this.copyOnWrite) {
                this.copyTable();
            }
            this.table[index] = 1.0f;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
            return true;
        }
        return false;
    }

    public boolean removeAll(FloatIterable source) {
        if (source.isEmpty()) {
            return false;
        }
        int oldSize = this.size();
        if (source instanceof FloatHashSet) {
            FloatHashSet hashSet = (FloatHashSet)source;
            this.zeroToThirtyOne &= ~hashSet.zeroToThirtyOne;
            this.zeroToThirtyOneOccupied = Integer.bitCount(this.zeroToThirtyOne);
            for (float item : hashSet.table) {
                if (!FloatHashSet.isNonSentinel(item)) continue;
                this.remove(item);
            }
        } else {
            FloatIterator iterator = source.floatIterator();
            while (iterator.hasNext()) {
                float item = iterator.next();
                this.remove(item);
            }
        }
        return this.size() != oldSize;
    }

    public boolean removeAll(float ... source) {
        if (source.length == 0) {
            return false;
        }
        int oldSize = this.size();
        for (float item : source) {
            this.remove(item);
        }
        return this.size() != oldSize;
    }

    public void clear() {
        this.zeroToThirtyOneOccupied = 0;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        this.zeroToThirtyOne = 0;
        if (this.copyOnWrite) {
            this.table = new float[this.table.length];
            this.copyOnWrite = false;
        } else {
            Arrays.fill(this.table, 0.0f);
        }
    }

    public FloatHashSet with(float element) {
        this.add(element);
        return this;
    }

    public FloatHashSet without(float element) {
        this.remove(element);
        return this;
    }

    public FloatHashSet withAll(FloatIterable elements) {
        this.addAll(elements.toArray());
        return this;
    }

    public FloatHashSet withoutAll(FloatIterable elements) {
        this.removeAll(elements);
        return this;
    }

    public MutableFloatSet asUnmodifiable() {
        return new UnmodifiableFloatSet(this);
    }

    public MutableFloatSet asSynchronized() {
        return new SynchronizedFloatSet(this);
    }

    public ImmutableFloatSet toImmutable() {
        if (this.size() == 0) {
            return FloatSets.immutable.with();
        }
        if (this.size() == 1) {
            return FloatSets.immutable.with(this.floatIterator().next());
        }
        FloatHashSet mutableSet = FloatHashSet.newSetWith(this.toArray());
        return new ImmutableFloatHashSet(mutableSet.table, mutableSet.occupiedWithData, mutableSet.zeroToThirtyOne, mutableSet.zeroToThirtyOneOccupied);
    }

    public FloatIterator floatIterator() {
        return new InternalFloatIterator();
    }

    public float[] toArray() {
        float value;
        float[] array = new float[this.size()];
        int j = 0;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            array[j] = value = (float)Integer.numberOfTrailingZeros(zeroToThirtyOne);
            ++j;
        }
        for (int i = 0; i < this.table.length && j < this.size(); ++i) {
            if (!FloatHashSet.isNonSentinel(this.table[i])) continue;
            array[j] = this.table[i];
            ++j;
        }
        return array;
    }

    public boolean contains(float value) {
        if (FloatHashSet.isBetweenZeroAndThirtyOne(value)) {
            int temp = this.zeroToThirtyOne;
            return (temp >>> (int)value & 1) != 0;
        }
        return Float.compare(this.table[this.probe(value)], value) == 0;
    }

    public boolean containsAll(float ... source) {
        for (float item : source) {
            if (this.contains(item)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(FloatIterable source) {
        FloatIterator iterator = source.floatIterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public void forEach(FloatProcedure procedure) {
        float value;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            procedure.value(value);
        }
        for (float value2 : this.table) {
            if (!FloatHashSet.isNonSentinel(value2)) continue;
            procedure.value(value2);
        }
    }

    public FloatHashSet select(FloatPredicate predicate) {
        float value;
        FloatHashSet result = new FloatHashSet();
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            if (!predicate.accept(value)) continue;
            result.add(value);
        }
        for (float value2 : this.table) {
            if (!FloatHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
            result.add(value2);
        }
        return result;
    }

    public MutableFloatSet reject(FloatPredicate predicate) {
        float value;
        FloatHashSet result = new FloatHashSet();
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            if (predicate.accept(value)) continue;
            result.add(value);
        }
        for (float value2 : this.table) {
            if (!FloatHashSet.isNonSentinel(value2) || predicate.accept(value2)) continue;
            result.add(value2);
        }
        return result;
    }

    public <V> MutableSet<V> collect(FloatToObjectFunction<? extends V> function) {
        float value;
        UnifiedSet target = UnifiedSet.newSet(this.size());
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            target.add(function.valueOf(value));
        }
        for (float value2 : this.table) {
            if (!FloatHashSet.isNonSentinel(value2)) continue;
            target.add(function.valueOf(value2));
        }
        return target;
    }

    public float detectIfNone(FloatPredicate predicate, float ifNone) {
        float value;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            if (!predicate.accept(value)) continue;
            return value;
        }
        for (float value2 : this.table) {
            if (!FloatHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
            return value2;
        }
        return ifNone;
    }

    public int count(FloatPredicate predicate) {
        float value;
        int count = 0;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            if (!predicate.accept(value)) continue;
            ++count;
        }
        for (float value2 : this.table) {
            if (!FloatHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
            ++count;
        }
        return count;
    }

    public boolean anySatisfy(FloatPredicate predicate) {
        float value;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            if (!predicate.accept(value)) continue;
            return true;
        }
        for (float value2 : this.table) {
            if (!FloatHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
            return true;
        }
        return false;
    }

    public boolean allSatisfy(FloatPredicate predicate) {
        float value;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            if (predicate.accept(value)) continue;
            return false;
        }
        for (float value2 : this.table) {
            if (!FloatHashSet.isNonSentinel(value2) || predicate.accept(value2)) continue;
            return false;
        }
        return true;
    }

    public boolean noneSatisfy(FloatPredicate predicate) {
        float value;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            if (!predicate.accept(value)) continue;
            return false;
        }
        for (float value2 : this.table) {
            if (!FloatHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
            return false;
        }
        return true;
    }

    public MutableFloatList toList() {
        return FloatArrayList.newList((FloatIterable)this);
    }

    public MutableFloatSet toSet() {
        return FloatHashSet.newSet((FloatIterable)this);
    }

    public MutableFloatBag toBag() {
        return FloatHashBag.newBag((FloatIterable)this);
    }

    public LazyFloatIterable asLazy() {
        return new LazyFloatIterableAdapter((FloatIterable)this);
    }

    public double sum() {
        float value;
        double result = 0.0;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            result += (double)value;
        }
        for (float value2 : this.table) {
            if (!FloatHashSet.isNonSentinel(value2)) continue;
            result += (double)value2;
        }
        return result;
    }

    public float max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        float max = 31 - Integer.numberOfLeadingZeros(this.zeroToThirtyOne);
        boolean isMaxSet = this.zeroToThirtyOneOccupied != 0;
        for (float value : this.table) {
            if (!FloatHashSet.isNonSentinel(value) || isMaxSet && Float.compare(max, value) >= 0) continue;
            max = value;
            isMaxSet = true;
        }
        return max;
    }

    public float maxIfEmpty(float defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.max();
    }

    public float min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        float min = Integer.numberOfTrailingZeros(this.zeroToThirtyOne);
        boolean isMinSet = this.zeroToThirtyOneOccupied != 0;
        for (float value : this.table) {
            if (!FloatHashSet.isNonSentinel(value) || isMinSet && Float.compare(value, min) >= 0) continue;
            min = value;
            isMinSet = true;
        }
        return min;
    }

    public float minIfEmpty(float defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.min();
    }

    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return this.sum() / (double)this.size();
    }

    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        float[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            float first = sortedArray[middleIndex];
            float second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    public float[] toSortedArray() {
        float[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    public MutableFloatList toSortedList() {
        return FloatArrayList.newList((FloatIterable)this).sortThis();
    }

    public FloatSet freeze() {
        if (this.size() == 0) {
            return FloatSets.immutable.with();
        }
        if (this.size() == 1) {
            return FloatSets.immutable.with(this.floatIterator().next());
        }
        this.copyOnWrite = true;
        return new ImmutableFloatHashSet(this.table, this.occupiedWithData, this.zeroToThirtyOne, this.zeroToThirtyOneOccupied);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        float value;
        out.writeInt(this.size());
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            out.writeFloat(value);
        }
        for (float value2 : this.table) {
            if (!FloatHashSet.isNonSentinel(value2)) continue;
            out.writeFloat(value2);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.add(in.readFloat());
        }
    }

    public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function) {
        float value;
        Object result = injectedValue;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            result = function.valueOf(result, value);
        }
        for (float value2 : this.table) {
            if (!FloatHashSet.isNonSentinel(value2)) continue;
            result = function.valueOf(result, value2);
        }
        return result;
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehash() {
        this.rehash(this.table.length);
    }

    private void rehashAndGrow() {
        this.rehash(this.table.length << 1);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.table.length;
        float[] old = this.table;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!FloatHashSet.isNonSentinel(old[i])) continue;
            this.add(old[i]);
        }
    }

    private void allocateTable(int sizeToAllocate) {
        this.table = new float[sizeToAllocate];
    }

    int probe(float element) {
        int index = this.spread(element);
        float valueAtIndex = this.table[index];
        if (Float.compare(valueAtIndex, element) == 0 || Float.compare(valueAtIndex, 0.0f) == 0) {
            return index;
        }
        int removedIndex = Float.compare(valueAtIndex, 1.0f) == 0 ? index : -1;
        int nextIndex = index;
        int probe = 17;
        while (true) {
            nextIndex = nextIndex + probe & this.table.length - 1;
            probe += 17;
            if (Float.compare(this.table[nextIndex], element) == 0) {
                return nextIndex;
            }
            if (Float.compare(this.table[nextIndex], 1.0f) == 0) {
                if (removedIndex != -1) continue;
                removedIndex = nextIndex;
                continue;
            }
            if (Float.compare(this.table[nextIndex], 0.0f) == 0) break;
        }
        return removedIndex == -1 ? nextIndex : removedIndex;
    }

    int spread(float element) {
        int code = Float.floatToIntBits(element);
        code ^= 0x3D ^ code >> 16;
        code += code << 3;
        code ^= code >> 4;
        code *= 668265261;
        code ^= code >> 15;
        return code & this.table.length - 1;
    }

    private void copyTable() {
        this.copyOnWrite = false;
        float[] copy = new float[this.table.length];
        System.arraycopy(this.table, 0, copy, 0, Math.min(this.table.length, this.table.length));
        this.table = copy;
    }

    private int maxOccupiedWithData() {
        int capacity = this.table.length;
        return Math.min(capacity - 1, capacity / 2);
    }

    private int maxOccupiedWithSentinels() {
        return this.table.length / 4;
    }

    private static boolean isNonSentinel(float value) {
        return Float.compare(value, 0.0f) != 0 && Float.compare(value, 1.0f) != 0;
    }

    private class InternalFloatIterator
    implements FloatIterator {
        private int count;
        private int position;
        private float zeroToThirtyOne;

        private InternalFloatIterator() {
        }

        public boolean hasNext() {
            return this.count < FloatHashSet.this.size();
        }

        public float next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            while (this.zeroToThirtyOne < 32.0f) {
                if (FloatHashSet.this.contains(this.zeroToThirtyOne)) {
                    float result = this.zeroToThirtyOne;
                    this.zeroToThirtyOne += 1.0f;
                    return result;
                }
                this.zeroToThirtyOne += 1.0f;
            }
            float[] table = FloatHashSet.this.table;
            while (!FloatHashSet.isNonSentinel(table[this.position])) {
                ++this.position;
            }
            float result = table[this.position];
            ++this.position;
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ImmutableFloatHashSet
    implements ImmutableFloatSet,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final float[] table;
        private final int occupied;
        private final int zeroToThirtyOne;
        private final int zeroToThirtyOneOccupied;

        private ImmutableFloatHashSet(float[] table, int occupied, int zeroToThirtyOne, int zeroToThirtyOneOccupied) {
            this.checkOptimizedSize(occupied + zeroToThirtyOneOccupied);
            this.occupied = occupied;
            this.zeroToThirtyOneOccupied = zeroToThirtyOneOccupied;
            this.zeroToThirtyOne = zeroToThirtyOne;
            this.table = table;
        }

        private void checkOptimizedSize(int length) {
            if (length <= 1) {
                throw new IllegalArgumentException("Use FloatSets.immutable.with() to instantiate an optimized collection");
            }
        }

        public static ImmutableFloatSet newSetWith(float ... elements) {
            return FloatHashSet.newSetWith(elements).toImmutable();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof FloatSet)) {
                return false;
            }
            FloatSet other = (FloatSet)obj;
            return this.size() == other.size() && this.containsAll(other.toArray());
        }

        public int hashCode() {
            float value;
            int result = 0;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                result += Float.floatToIntBits(value);
            }
            if (this.table != null) {
                for (int i = 0; i < this.table.length; ++i) {
                    if (!FloatHashSet.isNonSentinel(this.table[i])) continue;
                    result += Float.floatToIntBits(this.table[i]);
                }
            }
            return result;
        }

        public String toString() {
            return this.makeString("[", ", ", "]");
        }

        public ImmutableFloatSet newWith(float element) {
            return FloatHashSet.newSet((FloatIterable)this).with(element).toImmutable();
        }

        public ImmutableFloatSet newWithout(float element) {
            return FloatHashSet.newSet((FloatIterable)this).without(element).toImmutable();
        }

        public ImmutableFloatSet newWithAll(FloatIterable elements) {
            return FloatHashSet.newSet((FloatIterable)this).withAll(elements).toImmutable();
        }

        public ImmutableFloatSet newWithoutAll(FloatIterable elements) {
            return FloatHashSet.newSet((FloatIterable)this).withoutAll(elements).toImmutable();
        }

        public int size() {
            return this.occupied + this.zeroToThirtyOneOccupied;
        }

        public boolean isEmpty() {
            return this.size() == 0;
        }

        public boolean notEmpty() {
            return this.size() != 0;
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                float value;
                appendable.append(start);
                int count = 0;
                for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
                    value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                    if (count > 0) {
                        appendable.append(separator);
                    }
                    ++count;
                    appendable.append(String.valueOf(value));
                }
                for (float value2 : this.table) {
                    if (!FloatHashSet.isNonSentinel(value2)) continue;
                    if (count > 0) {
                        appendable.append(separator);
                    }
                    ++count;
                    appendable.append(String.valueOf(value2));
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public FloatIterator floatIterator() {
            return new InternalFloatIterator();
        }

        public float[] toArray() {
            float value;
            float[] array = new float[this.size()];
            int j = 0;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
                array[j] = value = (float)Integer.numberOfTrailingZeros(zeroToThirtyOne);
                ++j;
            }
            for (int i = 0; i < this.table.length && j < this.size(); ++i) {
                if (!FloatHashSet.isNonSentinel(this.table[i])) continue;
                array[j] = this.table[i];
                ++j;
            }
            return array;
        }

        public boolean contains(float value) {
            if (FloatHashSet.isBetweenZeroAndThirtyOne(value)) {
                int temp = this.zeroToThirtyOne;
                return (temp >>> (int)value & 1) != 0;
            }
            return Float.compare(this.table[this.probe(value)], value) == 0;
        }

        public boolean containsAll(float ... source) {
            for (float item : source) {
                if (this.contains(item)) continue;
                return false;
            }
            return true;
        }

        public boolean containsAll(FloatIterable source) {
            FloatIterator iterator = source.floatIterator();
            while (iterator.hasNext()) {
                if (this.contains(iterator.next())) continue;
                return false;
            }
            return true;
        }

        public void forEach(FloatProcedure procedure) {
            float value;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                procedure.value(value);
            }
            for (float value2 : this.table) {
                if (!FloatHashSet.isNonSentinel(value2)) continue;
                procedure.value(value2);
            }
        }

        public ImmutableFloatSet select(FloatPredicate predicate) {
            float value;
            FloatHashSet result = new FloatHashSet();
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                if (!predicate.accept(value)) continue;
                result.add(value);
            }
            for (float value2 : this.table) {
                if (!FloatHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
                result.add(value2);
            }
            return result.toImmutable();
        }

        public ImmutableFloatSet reject(FloatPredicate predicate) {
            float value;
            FloatHashSet result = new FloatHashSet();
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                if (predicate.accept(value)) continue;
                result.add(value);
            }
            for (float value2 : this.table) {
                if (!FloatHashSet.isNonSentinel(value2) || predicate.accept(value2)) continue;
                result.add(value2);
            }
            return result.toImmutable();
        }

        public <V> ImmutableSet<V> collect(FloatToObjectFunction<? extends V> function) {
            float value;
            UnifiedSet target = UnifiedSet.newSet(this.size());
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                target.add(function.valueOf(value));
            }
            for (float value2 : this.table) {
                if (!FloatHashSet.isNonSentinel(value2)) continue;
                target.add(function.valueOf(value2));
            }
            return target.toImmutable();
        }

        public float detectIfNone(FloatPredicate predicate, float ifNone) {
            float value;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                if (!predicate.accept(value)) continue;
                return value;
            }
            for (float value2 : this.table) {
                if (!FloatHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
                return value2;
            }
            return ifNone;
        }

        public int count(FloatPredicate predicate) {
            float value;
            int count = 0;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                if (!predicate.accept(value)) continue;
                ++count;
            }
            for (float value2 : this.table) {
                if (!FloatHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
                ++count;
            }
            return count;
        }

        public boolean anySatisfy(FloatPredicate predicate) {
            float value;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                if (!predicate.accept(value)) continue;
                return true;
            }
            for (float value2 : this.table) {
                if (!FloatHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
                return true;
            }
            return false;
        }

        public boolean allSatisfy(FloatPredicate predicate) {
            float value;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                if (predicate.accept(value)) continue;
                return false;
            }
            for (float value2 : this.table) {
                if (!FloatHashSet.isNonSentinel(value2) || predicate.accept(value2)) continue;
                return false;
            }
            return true;
        }

        public boolean noneSatisfy(FloatPredicate predicate) {
            float value;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                if (!predicate.accept(value)) continue;
                return false;
            }
            for (float value2 : this.table) {
                if (!FloatHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
                return false;
            }
            return true;
        }

        public MutableFloatList toList() {
            return FloatArrayList.newList((FloatIterable)this);
        }

        public MutableFloatSet toSet() {
            return FloatHashSet.newSet((FloatIterable)this);
        }

        public MutableFloatBag toBag() {
            return FloatHashBag.newBag((FloatIterable)this);
        }

        public LazyFloatIterable asLazy() {
            return new LazyFloatIterableAdapter((FloatIterable)this);
        }

        public double sum() {
            float value;
            double result = 0.0;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                result += (double)value;
            }
            for (float value2 : this.table) {
                if (!FloatHashSet.isNonSentinel(value2)) continue;
                result += (double)value2;
            }
            return result;
        }

        public float max() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            float max = 31 - Integer.numberOfLeadingZeros(this.zeroToThirtyOne);
            boolean isMaxSet = this.zeroToThirtyOneOccupied != 0;
            for (float value : this.table) {
                if (!FloatHashSet.isNonSentinel(value) || isMaxSet && Float.compare(max, value) >= 0) continue;
                max = value;
                isMaxSet = true;
            }
            return max;
        }

        public float maxIfEmpty(float defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.max();
        }

        public float min() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            float min = Integer.numberOfTrailingZeros(this.zeroToThirtyOne);
            boolean isMinSet = this.zeroToThirtyOneOccupied != 0;
            for (float value : this.table) {
                if (!FloatHashSet.isNonSentinel(value) || isMinSet && Float.compare(value, min) >= 0) continue;
                min = value;
                isMinSet = true;
            }
            return min;
        }

        public float minIfEmpty(float defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.min();
        }

        public double average() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            return this.sum() / (double)this.size();
        }

        public double median() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            float[] sortedArray = this.toSortedArray();
            int middleIndex = sortedArray.length >> 1;
            if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
                float first = sortedArray[middleIndex];
                float second = sortedArray[middleIndex - 1];
                return ((double)first + (double)second) / 2.0;
            }
            return sortedArray[middleIndex];
        }

        public float[] toSortedArray() {
            float[] array = this.toArray();
            Arrays.sort(array);
            return array;
        }

        public MutableFloatList toSortedList() {
            return FloatArrayList.newList((FloatIterable)this).sortThis();
        }

        public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function) {
            float value;
            Object result = injectedValue;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                result = function.valueOf(result, value);
            }
            for (float value2 : this.table) {
                if (!FloatHashSet.isNonSentinel(value2)) continue;
                result = function.valueOf(result, value2);
            }
            return result;
        }

        public FloatSet freeze() {
            return this;
        }

        public ImmutableFloatSet toImmutable() {
            return this;
        }

        private Object writeReplace() {
            return new ImmutableFloatSetSerializationProxy((FloatSet)this);
        }

        int probe(float element) {
            int index = this.spread(element);
            float valueAtIndex = this.table[index];
            if (Float.compare(valueAtIndex, element) == 0 || Float.compare(valueAtIndex, 0.0f) == 0) {
                return index;
            }
            int removedIndex = Float.compare(valueAtIndex, 1.0f) == 0 ? index : -1;
            int nextIndex = index;
            int probe = 17;
            while (true) {
                nextIndex = nextIndex + probe & this.table.length - 1;
                probe += 17;
                if (Float.compare(this.table[nextIndex], element) == 0) {
                    return nextIndex;
                }
                if (Float.compare(this.table[nextIndex], 1.0f) == 0) {
                    if (removedIndex != -1) continue;
                    removedIndex = nextIndex;
                    continue;
                }
                if (Float.compare(this.table[nextIndex], 0.0f) == 0) break;
            }
            return removedIndex == -1 ? nextIndex : removedIndex;
        }

        int spread(float element) {
            int code = Float.floatToIntBits(element);
            code ^= 0x3D ^ code >> 16;
            code += code << 3;
            code ^= code >> 4;
            code *= 668265261;
            code ^= code >> 15;
            return code & this.table.length - 1;
        }

        private class InternalFloatIterator
        implements FloatIterator {
            private int count;
            private int position;
            private float zeroToThirtyOne;

            private InternalFloatIterator() {
            }

            public boolean hasNext() {
                return this.count < ImmutableFloatHashSet.this.size();
            }

            public float next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("next() called, but the iterator is exhausted");
                }
                ++this.count;
                while (this.zeroToThirtyOne < 32.0f) {
                    if (ImmutableFloatHashSet.this.contains(this.zeroToThirtyOne)) {
                        float result = this.zeroToThirtyOne;
                        this.zeroToThirtyOne += 1.0f;
                        return result;
                    }
                    this.zeroToThirtyOne += 1.0f;
                }
                float[] table = ImmutableFloatHashSet.this.table;
                while (!FloatHashSet.isNonSentinel(table[this.position])) {
                    ++this.position;
                }
                float result = table[this.position];
                ++this.position;
                return result;
            }
        }
    }
}

