/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.set.sorted.immutable;

import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.set.sorted.ImmutableSortedSet;
import com.gs.collections.api.set.sorted.SortedSetIterable;
import com.gs.collections.api.tuple.Pair;
import com.gs.collections.impl.EmptyIterator;
import com.gs.collections.impl.factory.SortedSets;
import com.gs.collections.impl.set.sorted.immutable.AbstractImmutableSortedSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableEmptySortedSet<T>
extends AbstractImmutableSortedSet<T>
implements Serializable {
    static final ImmutableSortedSet<?> INSTANCE = new ImmutableEmptySortedSet();
    private static final long serialVersionUID = 1L;
    private final Comparator<? super T> comparator;

    ImmutableEmptySortedSet() {
        this.comparator = null;
    }

    ImmutableEmptySortedSet(Comparator<? super T> comparator) {
        this.comparator = comparator;
    }

    private Object readResolve() {
        if (this.comparator == null) {
            return INSTANCE;
        }
        return this;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        return other instanceof Set && ((Collection)other).isEmpty();
    }

    @Override
    public int hashCode() {
        return 0;
    }

    @Override
    public ImmutableSortedSet<T> newWith(T element) {
        return SortedSets.immutable.of(this.comparator, new Object[]{element});
    }

    @Override
    public ImmutableSortedSet<T> newWithAll(Iterable<? extends T> elements) {
        return SortedSets.immutable.ofAll(this.comparator, elements);
    }

    @Override
    public ImmutableSortedSet<T> newWithout(T element) {
        return this;
    }

    @Override
    public ImmutableSortedSet<T> newWithoutAll(Iterable<? extends T> elements) {
        return this;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public boolean contains(Object object) {
        return false;
    }

    @Override
    public void forEach(Procedure<? super T> procedure) {
    }

    @Override
    public void forEachWithIndex(ObjectIntProcedure<? super T> objectIntProcedure) {
    }

    @Override
    public <P> void forEachWith(Procedure2<? super T, ? super P> procedure, P parameter) {
    }

    @Override
    public Iterator<T> iterator() {
        return EmptyIterator.getInstance();
    }

    @Override
    public T min(Comparator<? super T> comparator) {
        throw new NoSuchElementException();
    }

    @Override
    public T max(Comparator<? super T> comparator) {
        throw new NoSuchElementException();
    }

    @Override
    public T min() {
        throw new NoSuchElementException();
    }

    @Override
    public T max() {
        throw new NoSuchElementException();
    }

    @Override
    public <V extends Comparable<? super V>> T minBy(Function<? super T, ? extends V> function) {
        throw new NoSuchElementException();
    }

    @Override
    public <V extends Comparable<? super V>> T maxBy(Function<? super T, ? extends V> function) {
        throw new NoSuchElementException();
    }

    @Override
    public <S, R extends Collection<Pair<T, S>>> R zip(Iterable<S> that, R target) {
        return target;
    }

    @Override
    public <R extends Collection<Pair<T, Integer>>> R zipWithIndex(R target) {
        return target;
    }

    @Override
    public T first() {
        throw new NoSuchElementException();
    }

    @Override
    public T last() {
        throw new NoSuchElementException();
    }

    @Override
    public Comparator<? super T> comparator() {
        return this.comparator;
    }

    public int compareTo(SortedSetIterable<T> o) {
        return o.size() * -1;
    }
}

