/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.bag.immutable.primitive;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.LazyDoubleIterable;
import com.gs.collections.api.bag.ImmutableBag;
import com.gs.collections.api.bag.primitive.DoubleBag;
import com.gs.collections.api.bag.primitive.ImmutableDoubleBag;
import com.gs.collections.api.bag.primitive.MutableDoubleBag;
import com.gs.collections.api.block.function.primitive.DoubleToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.DoublePredicate;
import com.gs.collections.api.block.procedure.primitive.DoubleIntProcedure;
import com.gs.collections.api.block.procedure.primitive.DoubleProcedure;
import com.gs.collections.api.iterator.DoubleIterator;
import com.gs.collections.api.list.primitive.MutableDoubleList;
import com.gs.collections.api.set.primitive.MutableDoubleSet;
import com.gs.collections.impl.bag.mutable.primitive.DoubleHashBag;
import com.gs.collections.impl.block.procedure.checked.primitive.CheckedDoubleIntProcedure;
import com.gs.collections.impl.iterator.UnmodifiableDoubleIterator;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableDoubleHashBag
implements ImmutableDoubleBag,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableDoubleBag delegate;

    private ImmutableDoubleHashBag(double[] newElements) {
        this.checkOptimizedSize(newElements.length);
        this.delegate = DoubleHashBag.newBagWith(newElements);
    }

    private void checkOptimizedSize(int length) {
        if (length <= 1) {
            throw new IllegalArgumentException("Use DoubleBags.immutable.with() to instantiate an optimized collection");
        }
    }

    public static ImmutableDoubleHashBag newBagWith(double ... elements) {
        return new ImmutableDoubleHashBag(elements);
    }

    public ImmutableDoubleBag newWith(double element) {
        return DoubleHashBag.newBag((DoubleBag)this.delegate).with(element).toImmutable();
    }

    public ImmutableDoubleBag newWithout(double element) {
        DoubleHashBag hashBag = DoubleHashBag.newBag((DoubleBag)this.delegate);
        hashBag.remove(element);
        return hashBag.toImmutable();
    }

    public ImmutableDoubleBag newWithAll(DoubleIterable elements) {
        DoubleHashBag bag = DoubleHashBag.newBag((DoubleBag)this.delegate);
        bag.addAll(elements);
        return bag.toImmutable();
    }

    public ImmutableDoubleBag newWithoutAll(DoubleIterable elements) {
        DoubleHashBag bag = DoubleHashBag.newBag((DoubleBag)this.delegate);
        bag.removeAll(elements);
        return bag.toImmutable();
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    public boolean contains(double value) {
        return this.delegate.contains(value);
    }

    public boolean containsAll(DoubleIterable source) {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(double ... elements) {
        return this.delegate.containsAll(elements);
    }

    public void forEach(DoubleProcedure procedure) {
        this.each(procedure);
    }

    public void each(DoubleProcedure procedure) {
        this.delegate.forEach(procedure);
    }

    public ImmutableDoubleBag select(DoublePredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableDoubleBag reject(DoublePredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <V> ImmutableBag<V> collect(DoubleToObjectFunction<? extends V> function) {
        return this.delegate.collect(function).toImmutable();
    }

    public MutableDoubleList toList() {
        return this.delegate.toList();
    }

    public int sizeDistinct() {
        return this.delegate.sizeDistinct();
    }

    public int occurrencesOf(double item) {
        return this.delegate.occurrencesOf(item);
    }

    public void forEachWithOccurrences(DoubleIntProcedure doubleIntProcedure) {
        this.delegate.forEachWithOccurrences(doubleIntProcedure);
    }

    public double detectIfNone(DoublePredicate predicate, double ifNone) {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public int count(DoublePredicate predicate) {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(DoublePredicate predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    public double sum() {
        return this.delegate.sum();
    }

    public double min() {
        return this.delegate.min();
    }

    public double max() {
        return this.delegate.max();
    }

    public double maxIfEmpty(double defaultValue) {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    public double minIfEmpty(double defaultValue) {
        return this.delegate.minIfEmpty(defaultValue);
    }

    public double average() {
        return this.delegate.average();
    }

    public double median() {
        return this.delegate.median();
    }

    public double[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    public MutableDoubleList toSortedList() {
        return this.delegate.toSortedList();
    }

    public boolean noneSatisfy(DoublePredicate predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    public boolean allSatisfy(DoublePredicate predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    public <T> T injectInto(T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function) {
        return (T)this.delegate.injectInto(injectedValue, function);
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public MutableDoubleSet toSet() {
        return this.delegate.toSet();
    }

    public MutableDoubleBag toBag() {
        return this.delegate.toBag();
    }

    public ImmutableDoubleBag toImmutable() {
        return this;
    }

    public LazyDoubleIterable asLazy() {
        return this.delegate.asLazy();
    }

    public double[] toArray() {
        return this.delegate.toArray();
    }

    public String toString() {
        return this.delegate.toString();
    }

    public String makeString() {
        return this.delegate.makeString();
    }

    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    public DoubleIterator doubleIterator() {
        return new UnmodifiableDoubleIterator((DoubleIterator)this.delegate.doubleIterator());
    }

    private Object writeReplace() {
        return new ImmutableDoubleBagSerializationProxy((DoubleBag)this);
    }

    protected static class ImmutableDoubleBagSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private DoubleBag bag;

        public ImmutableDoubleBagSerializationProxy() {
        }

        protected ImmutableDoubleBagSerializationProxy(DoubleBag bag) {
            this.bag = bag;
        }

        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.bag.sizeDistinct());
            try {
                this.bag.forEachWithOccurrences((DoubleIntProcedure)new CheckedDoubleIntProcedure(){

                    public void safeValue(double item, int count) throws IOException {
                        out.writeDouble(item);
                        out.writeInt(count);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            DoubleHashBag deserializedBag = new DoubleHashBag();
            for (int i = 0; i < size; ++i) {
                deserializedBag.addOccurrences(in.readDouble(), in.readInt());
            }
            this.bag = deserializedBag;
        }

        protected Object readResolve() {
            return this.bag.toImmutable();
        }
    }
}

