/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.bag.sorted.immutable;

import com.gs.collections.api.bag.sorted.ImmutableSortedBag;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.impl.bag.sorted.mutable.TreeBag;
import com.gs.collections.impl.block.procedure.checked.CheckedObjectIntProcedure;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ImmutableSortedBagSerializationProxy<T>
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private ImmutableSortedBag<T> bag;

    public ImmutableSortedBagSerializationProxy() {
    }

    ImmutableSortedBagSerializationProxy(ImmutableSortedBag<T> bag) {
        this.bag = bag;
    }

    @Override
    public void writeExternal(final ObjectOutput out) throws IOException {
        out.writeInt(this.bag.sizeDistinct());
        out.writeObject(this.bag.comparator());
        try {
            this.bag.forEachWithOccurrences((ObjectIntProcedure)new CheckedObjectIntProcedure<T>(){

                @Override
                public void safeValue(T object, int index) throws IOException {
                    out.writeObject(object);
                    out.writeInt(index);
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        Comparator comparator = (Comparator)in.readObject();
        TreeBag deserializedBag = new TreeBag(comparator);
        for (int i = 0; i < size; ++i) {
            deserializedBag.addOccurrences(in.readObject(), in.readInt());
        }
        this.bag = deserializedBag.toImmutable();
    }

    protected Object readResolve() {
        return this.bag.toImmutable();
    }
}

