/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.lazy;

import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.impl.block.predicate.DropIterablePredicate;
import com.gs.collections.impl.block.procedure.IfObjectIntProcedure;
import com.gs.collections.impl.block.procedure.IfProcedure;
import com.gs.collections.impl.block.procedure.IfProcedureWith;
import com.gs.collections.impl.lazy.AbstractLazyIterable;
import com.gs.collections.impl.lazy.iterator.DropIterator;
import com.gs.collections.impl.utility.Iterate;
import java.util.Iterator;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class DropIterable<T>
extends AbstractLazyIterable<T> {
    private final Iterable<T> adapted;
    private final int count;

    public DropIterable(Iterable<T> newAdapted, int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be greater than zero, but was: " + count);
        }
        this.adapted = newAdapted;
        this.count = count;
    }

    public void each(Procedure<? super T> procedure) {
        Iterate.forEach(this.adapted, new IfProcedure<T>(new DropIterablePredicate(this.count), procedure));
    }

    @Override
    public void forEachWithIndex(ObjectIntProcedure<? super T> objectIntProcedure) {
        Iterate.forEach(this.adapted, new IfObjectIntProcedure<T>(new DropIterablePredicate(this.count), objectIntProcedure));
    }

    @Override
    public <P> void forEachWith(Procedure2<? super T, ? super P> procedure, P parameter) {
        Iterate.forEachWith(this.adapted, new IfProcedureWith<T, P>(new DropIterablePredicate(this.count), procedure), parameter);
    }

    public Iterator<T> iterator() {
        return new DropIterator<T>(this.adapted, this.count);
    }
}

