/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.parallel;

import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.list.MutableList;
import com.gs.collections.impl.parallel.ObjectIntProcedureFJTaskRunner;
import com.gs.collections.impl.parallel.ObjectIntProcedureFactory;
import com.gs.collections.impl.utility.ArrayListIterate;
import com.gs.collections.impl.utility.ListIterate;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObjectIntProcedureFJTask<T, BT extends ObjectIntProcedure<? super T>>
implements Runnable {
    private final ObjectIntProcedureFactory<BT> procedureFactory;
    private BT procedure;
    private final List<T> list;
    private final int start;
    private final int end;
    private final ObjectIntProcedureFJTaskRunner<T, BT> taskRunner;

    public ObjectIntProcedureFJTask(ObjectIntProcedureFJTaskRunner<T, BT> newFJTaskRunner, ObjectIntProcedureFactory<BT> newProcedureFactory, List<T> list, int index, int sectionSize, boolean isLast) {
        this.taskRunner = newFJTaskRunner;
        this.procedureFactory = newProcedureFactory;
        this.list = list;
        this.start = index * sectionSize;
        this.end = isLast ? this.list.size() : this.start + sectionSize;
    }

    @Override
    public void run() {
        try {
            this.procedure = this.procedureFactory.create();
            int stop = this.end - 1;
            if (this.list instanceof MutableList) {
                ((MutableList)this.list).forEachWithIndex(this.start, stop, this.procedure);
            } else if (this.list instanceof ArrayList) {
                ArrayListIterate.forEachWithIndex((ArrayList)this.list, this.start, stop, this.procedure);
            } else {
                ListIterate.forEachWithIndex(this.list, this.start, stop, this.procedure);
            }
        }
        catch (Throwable newError) {
            this.taskRunner.setFailed(newError);
        }
        finally {
            this.taskRunner.taskCompleted(this);
        }
    }

    public BT getProcedure() {
        return this.procedure;
    }
}

