/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.stack.immutable;

import com.gs.collections.api.factory.stack.ImmutableStackFactory;
import com.gs.collections.api.stack.ImmutableStack;
import com.gs.collections.impl.stack.immutable.ImmutableArrayStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImmutableStackFactoryImpl
implements ImmutableStackFactory {
    public <T> ImmutableStack<T> empty() {
        return ImmutableArrayStack.newStack();
    }

    public <T> ImmutableStack<T> of() {
        return this.empty();
    }

    public <T> ImmutableStack<T> with() {
        return this.empty();
    }

    public <T> ImmutableStack<T> of(T element) {
        return this.with(element);
    }

    public <T> ImmutableStack<T> with(T element) {
        return ImmutableArrayStack.newStackWith(element);
    }

    public <T> ImmutableStack<T> of(T ... elements) {
        return this.with(elements);
    }

    public <T> ImmutableStack<T> with(T ... elements) {
        return ImmutableArrayStack.newStackWith(elements);
    }

    public <T> ImmutableStack<T> ofAll(Iterable<? extends T> items) {
        return this.withAll(items);
    }

    public <T> ImmutableStack<T> withAll(Iterable<? extends T> items) {
        return ImmutableArrayStack.newStack(items);
    }

    public <T> ImmutableStack<T> ofReversed(T ... elements) {
        return this.withReversed(elements);
    }

    public <T> ImmutableStack<T> withReversed(T ... elements) {
        return ImmutableArrayStack.newStackFromTopToBottom(elements);
    }

    public <T> ImmutableStack<T> ofAllReversed(Iterable<? extends T> items) {
        return this.withAllReversed(items);
    }

    public <T> ImmutableStack<T> withAllReversed(Iterable<? extends T> items) {
        return ImmutableArrayStack.newStackFromTopToBottom(items);
    }
}

