package com.google.adk.tools.mcp;

import com.google.common.collect.ImmutableMap;
import java.time.Duration;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_SseServerParameters extends SseServerParameters {

  private final String url;

  @Nullable
  private final String sseEndpoint;

  @Nullable
  private final ImmutableMap<String, Object> headers;

  @Nullable
  private final Duration timeout;

  @Nullable
  private final Duration sseReadTimeout;

  private AutoValue_SseServerParameters(
      String url,
      @Nullable String sseEndpoint,
      @Nullable ImmutableMap<String, Object> headers,
      @Nullable Duration timeout,
      @Nullable Duration sseReadTimeout) {
    this.url = url;
    this.sseEndpoint = sseEndpoint;
    this.headers = headers;
    this.timeout = timeout;
    this.sseReadTimeout = sseReadTimeout;
  }

  @Override
  public String url() {
    return url;
  }

  @Nullable
  @Override
  public String sseEndpoint() {
    return sseEndpoint;
  }

  @Nullable
  @Override
  public ImmutableMap<String, Object> headers() {
    return headers;
  }

  @Nullable
  @Override
  public Duration timeout() {
    return timeout;
  }

  @Nullable
  @Override
  public Duration sseReadTimeout() {
    return sseReadTimeout;
  }

  @Override
  public String toString() {
    return "SseServerParameters{"
        + "url=" + url + ", "
        + "sseEndpoint=" + sseEndpoint + ", "
        + "headers=" + headers + ", "
        + "timeout=" + timeout + ", "
        + "sseReadTimeout=" + sseReadTimeout
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof SseServerParameters) {
      SseServerParameters that = (SseServerParameters) o;
      return this.url.equals(that.url())
          && (this.sseEndpoint == null ? that.sseEndpoint() == null : this.sseEndpoint.equals(that.sseEndpoint()))
          && (this.headers == null ? that.headers() == null : this.headers.equals(that.headers()))
          && (this.timeout == null ? that.timeout() == null : this.timeout.equals(that.timeout()))
          && (this.sseReadTimeout == null ? that.sseReadTimeout() == null : this.sseReadTimeout.equals(that.sseReadTimeout()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= url.hashCode();
    h$ *= 1000003;
    h$ ^= (sseEndpoint == null) ? 0 : sseEndpoint.hashCode();
    h$ *= 1000003;
    h$ ^= (headers == null) ? 0 : headers.hashCode();
    h$ *= 1000003;
    h$ ^= (timeout == null) ? 0 : timeout.hashCode();
    h$ *= 1000003;
    h$ ^= (sseReadTimeout == null) ? 0 : sseReadTimeout.hashCode();
    return h$;
  }

  static final class Builder extends SseServerParameters.Builder {
    private String url;
    private String sseEndpoint;
    private ImmutableMap<String, Object> headers;
    private Duration timeout;
    private Duration sseReadTimeout;
    Builder() {
    }
    @Override
    public SseServerParameters.Builder url(String url) {
      if (url == null) {
        throw new NullPointerException("Null url");
      }
      this.url = url;
      return this;
    }
    @Override
    public SseServerParameters.Builder sseEndpoint(String sseEndpoint) {
      this.sseEndpoint = sseEndpoint;
      return this;
    }
    @Override
    public SseServerParameters.Builder headers(@Nullable Map<String, Object> headers) {
      this.headers = (headers == null ? null : ImmutableMap.copyOf(headers));
      return this;
    }
    @Override
    public SseServerParameters.Builder timeout(@Nullable Duration timeout) {
      this.timeout = timeout;
      return this;
    }
    @Override
    public SseServerParameters.Builder sseReadTimeout(@Nullable Duration sseReadTimeout) {
      this.sseReadTimeout = sseReadTimeout;
      return this;
    }
    @Override
    public SseServerParameters build() {
      if (this.url == null) {
        String missing = " url";
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_SseServerParameters(
          this.url,
          this.sseEndpoint,
          this.headers,
          this.timeout,
          this.sseReadTimeout);
    }
  }

}
