/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.sessions;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.adk.JsonBaseModel;
import com.google.adk.events.Event;
import com.google.adk.sessions.ApiResponse;
import com.google.adk.sessions.BaseSessionService;
import com.google.adk.sessions.GetSessionConfig;
import com.google.adk.sessions.HttpApiClient;
import com.google.adk.sessions.ListEventsResponse;
import com.google.adk.sessions.ListSessionsResponse;
import com.google.adk.sessions.Session;
import com.google.adk.sessions.SessionJsonConverter;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.genai.types.HttpOptions;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Single;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VertexAiSessionService
implements BaseSessionService {
    private static final int MAX_RETRY_ATTEMPTS = 5;
    private static final ObjectMapper objectMapper = JsonBaseModel.getMapper();
    private static final Logger logger = LoggerFactory.getLogger(VertexAiSessionService.class);
    private final HttpApiClient apiClient;
    private static final Pattern APP_NAME_PATTERN = Pattern.compile("^projects/([a-zA-Z0-9-_]+)/locations/([a-zA-Z0-9-_]+)/reasoningEngines/(\\d+)$");

    public VertexAiSessionService(String project, String location, HttpApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public VertexAiSessionService() {
        this.apiClient = new HttpApiClient(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public VertexAiSessionService(String project, String location, Optional<GoogleCredentials> credentials, Optional<HttpOptions> httpOptions) {
        this.apiClient = new HttpApiClient(Optional.of(project), Optional.of(location), credentials, httpOptions);
    }

    private static JsonNode getJsonResponse(ApiResponse apiResponse) {
        try {
            ResponseBody responseBody = apiResponse.getResponseBody();
            return objectMapper.readTree(responseBody.string());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public Single<Session> createSession(String appName, String userId, @Nullable ConcurrentMap<String, Object> state, @Nullable String sessionId) {
        JsonNode sessionStateNode;
        ApiResponse lroResponse;
        JsonNode jsonResponse;
        ApiResponse apiResponse;
        String reasoningEngineId = VertexAiSessionService.parseReasoningEngineId(appName);
        ConcurrentHashMap<String, Object> sessionJsonMap = new ConcurrentHashMap<String, Object>();
        sessionJsonMap.put("userId", userId);
        if (state != null) {
            sessionJsonMap.put("sessionState", state);
        }
        try {
            apiResponse = this.apiClient.request("POST", "reasoningEngines/" + reasoningEngineId + "/sessions", objectMapper.writeValueAsString(sessionJsonMap));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        logger.debug("Create Session response {}", (Object)apiResponse.getResponseBody());
        String sessionName = "";
        String operationId = "";
        String sessId = Strings.nullToEmpty((String)sessionId);
        if (apiResponse != null && apiResponse.getResponseBody() != null) {
            JsonNode jsonResponse2 = VertexAiSessionService.getJsonResponse(apiResponse);
            sessionName = jsonResponse2.get("name").asText();
            List parts = Splitter.on((char)'/').splitToList((CharSequence)sessionName);
            sessId = (String)parts.get(parts.size() - 3);
            operationId = (String)Iterables.getLast((Iterable)parts);
        }
        for (int i = 0; i < 5 && (jsonResponse = VertexAiSessionService.getJsonResponse(lroResponse = this.apiClient.request("GET", "operations/" + operationId, ""))).get("done") == null; ++i) {
            try {
                TimeUnit.SECONDS.sleep(1L);
                continue;
            }
            catch (InterruptedException e) {
                logger.warn("Error during sleep", (Throwable)e);
            }
        }
        ApiResponse getSessionApiResponse = this.apiClient.request("GET", "reasoningEngines/" + reasoningEngineId + "/sessions/" + sessId, "");
        JsonNode getSessionResponseMap = VertexAiSessionService.getJsonResponse(getSessionApiResponse);
        Instant updateTimestamp = Instant.parse(getSessionResponseMap.get("updateTime").asText());
        ConcurrentMap sessionState = null;
        if (getSessionResponseMap != null && getSessionResponseMap.has("sessionState") && (sessionStateNode = getSessionResponseMap.get("sessionState")) != null) {
            sessionState = (ConcurrentMap)objectMapper.convertValue((Object)sessionStateNode, (TypeReference)new TypeReference<ConcurrentMap<String, Object>>(){});
        }
        return Single.just((Object)Session.builder(sessId).appName(appName).userId(userId).lastUpdateTime(updateTimestamp).state(sessionState == null ? new ConcurrentHashMap() : sessionState).build());
    }

    @Override
    public Single<ListSessionsResponse> listSessions(String appName, String userId) {
        String reasoningEngineId = VertexAiSessionService.parseReasoningEngineId(appName);
        ApiResponse apiResponse = this.apiClient.request("GET", "reasoningEngines/" + reasoningEngineId + "/sessions?filter=user_id=" + userId, "");
        if (apiResponse.getResponseBody() == null) {
            return Single.just((Object)ListSessionsResponse.builder().build());
        }
        JsonNode listSessionsResponseMap = VertexAiSessionService.getJsonResponse(apiResponse);
        List apiSessions = (List)objectMapper.convertValue((Object)listSessionsResponseMap.get("sessions"), (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
        ArrayList<Session> sessions = new ArrayList<Session>();
        for (Map apiSession : apiSessions) {
            String sessionId = (String)Iterables.getLast((Iterable)Splitter.on((char)'/').splitToList((CharSequence)((String)apiSession.get("name"))));
            Instant updateTimestamp = Instant.parse((String)apiSession.get("updateTime"));
            Session session = Session.builder(sessionId).appName(appName).userId(userId).state(new ConcurrentHashMap<String, Object>()).lastUpdateTime(updateTimestamp).build();
            sessions.add(session);
        }
        return Single.just((Object)ListSessionsResponse.builder().sessions(sessions).build());
    }

    @Override
    public Single<ListEventsResponse> listEvents(String appName, String userId, String sessionId) {
        String reasoningEngineId = VertexAiSessionService.parseReasoningEngineId(appName);
        ApiResponse apiResponse = this.apiClient.request("GET", "reasoningEngines/" + reasoningEngineId + "/sessions/" + sessionId + "/events", "");
        logger.debug("List events response {}", (Object)apiResponse);
        if (apiResponse.getResponseBody() == null) {
            return Single.just((Object)ListEventsResponse.builder().build());
        }
        JsonNode sessionEventsNode = VertexAiSessionService.getJsonResponse(apiResponse).get("sessionEvents");
        if (sessionEventsNode == null || sessionEventsNode.isEmpty()) {
            return Single.just((Object)ListEventsResponse.builder().events(new ArrayList<Event>()).build());
        }
        return Single.just((Object)ListEventsResponse.builder().events(((List)objectMapper.convertValue((Object)sessionEventsNode, (TypeReference)new TypeReference<List<ConcurrentMap<String, Object>>>(){})).stream().map(SessionJsonConverter::fromApiEvent).collect(Collectors.toCollection(ArrayList::new))).build());
    }

    @Override
    public Maybe<Session> getSession(String appName, String userId, String sessionId, Optional<GetSessionConfig> config) {
        String reasoningEngineId = VertexAiSessionService.parseReasoningEngineId(appName);
        ApiResponse apiResponse = this.apiClient.request("GET", "reasoningEngines/" + reasoningEngineId + "/sessions/" + sessionId, "");
        JsonNode getSessionResponseMap = VertexAiSessionService.getJsonResponse(apiResponse);
        if (getSessionResponseMap == null) {
            return Maybe.empty();
        }
        String sessId = Optional.ofNullable(getSessionResponseMap.get("name")).map(name -> (String)Iterables.getLast((Iterable)Splitter.on((char)'/').splitToList((CharSequence)name.asText()))).orElse(sessionId);
        Instant updateTimestamp = Optional.ofNullable(getSessionResponseMap.get("updateTime")).map(updateTime -> Instant.parse(updateTime.asText())).orElse(null);
        ConcurrentHashMap sessionState = new ConcurrentHashMap();
        if (getSessionResponseMap != null && getSessionResponseMap.has("sessionState")) {
            sessionState.putAll((Map)objectMapper.convertValue((Object)getSessionResponseMap.get("sessionState"), (TypeReference)new TypeReference<ConcurrentMap<String, Object>>(){}));
        }
        return this.listEvents(appName, userId, sessionId).map(response -> {
            Session.Builder sessionBuilder = Session.builder(sessId).appName(appName).userId(userId).lastUpdateTime(updateTimestamp).state(sessionState);
            Object events = response.events();
            if (events.isEmpty()) {
                return sessionBuilder.build();
            }
            events = events.stream().filter(event -> updateTimestamp == null || Instant.ofEpochMilli(event.timestamp()).isBefore(updateTimestamp)).sorted(Comparator.comparing(Event::timestamp)).collect(Collectors.toCollection(ArrayList::new));
            if (config.isPresent()) {
                if (((GetSessionConfig)config.get()).numRecentEvents().isPresent()) {
                    int numRecentEvents = ((GetSessionConfig)config.get()).numRecentEvents().get();
                    if (events.size() > numRecentEvents) {
                        events = events.subList(events.size() - numRecentEvents, events.size());
                    }
                } else if (((GetSessionConfig)config.get()).afterTimestamp().isPresent()) {
                    int i;
                    Instant afterTimestamp = ((GetSessionConfig)config.get()).afterTimestamp().get();
                    for (i = events.size() - 1; i >= 0 && !Instant.ofEpochMilli(((Event)events.get(i)).timestamp()).isBefore(afterTimestamp); --i) {
                    }
                    if (i >= 0) {
                        events = events.subList(i, events.size());
                    }
                }
            }
            return sessionBuilder.events((List<Event>)events).build();
        }).toMaybe();
    }

    @Override
    public Completable deleteSession(String appName, String userId, String sessionId) {
        String reasoningEngineId = VertexAiSessionService.parseReasoningEngineId(appName);
        ApiResponse unused = this.apiClient.request("DELETE", "reasoningEngines/" + reasoningEngineId + "/sessions/" + sessionId, "");
        return Completable.complete();
    }

    @Override
    public Single<Event> appendEvent(Session session, Event event) {
        BaseSessionService.super.appendEvent(session, event);
        String reasoningEngineId = VertexAiSessionService.parseReasoningEngineId(session.appName());
        ApiResponse response = this.apiClient.request("POST", "reasoningEngines/" + reasoningEngineId + "/sessions/" + session.id() + ":appendEvent", SessionJsonConverter.convertEventToJson(event));
        try {
            if (response.getResponseBody().string().contains("com.google.genai.errors.ClientException")) {
                logger.warn("Failed to append event: ", (Object)event);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        response.close();
        return Single.just((Object)event);
    }

    static String parseReasoningEngineId(String appName) {
        if (appName.matches("\\d+")) {
            return appName;
        }
        Matcher matcher = APP_NAME_PATTERN.matcher(appName);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("App name " + appName + " is not valid. It should either be the full ReasoningEngine resource name, or the reasoning engine id.");
        }
        return matcher.group(matcher.groupCount());
    }
}

