/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.tools;

import com.google.adk.agents.ReadonlyContext;
import com.google.adk.tools.BaseTool;
import com.google.adk.tools.ToolPredicate;
import io.reactivex.rxjava3.core.Flowable;
import java.util.List;
import java.util.Optional;

public interface BaseToolset
extends AutoCloseable {
    public Flowable<BaseTool> getTools(ReadonlyContext var1);

    @Override
    public void close() throws Exception;

    default public boolean isToolSelected(BaseTool tool, Optional<Object> toolFilter, Optional<ReadonlyContext> readonlyContext) {
        if (toolFilter.isEmpty()) {
            return true;
        }
        Object filter = toolFilter.get();
        if (filter instanceof ToolPredicate) {
            ToolPredicate toolPredicate = (ToolPredicate)filter;
            return toolPredicate.test(tool, readonlyContext);
        }
        if (filter instanceof List) {
            List toolNames = (List)filter;
            return toolNames.contains(tool.name());
        }
        return false;
    }
}

