/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.tools.applicationintegrationtoolset;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.adk.tools.BaseTool;
import com.google.adk.tools.ToolContext;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import com.google.genai.types.FunctionDeclaration;
import com.google.genai.types.Schema;
import io.reactivex.rxjava3.core.Single;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;

public class IntegrationConnectorTool
extends BaseTool {
    private final String openApiSpec;
    private final String pathUrl;
    private final HttpExecutor httpExecutor;
    private final String connectionName;
    private final String serviceName;
    private final String host;
    private String entity;
    private String operation;
    private String action;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final ImmutableList<String> EXCLUDE_FIELDS = ImmutableList.of((Object)"connectionName", (Object)"serviceName", (Object)"host", (Object)"entity", (Object)"operation", (Object)"action");
    private static final ImmutableList<String> OPTIONAL_FIELDS = ImmutableList.of((Object)"pageSize", (Object)"pageToken", (Object)"filter", (Object)"sortByColumns");

    IntegrationConnectorTool(String openApiSpec, String pathUrl, String toolName, String toolDescription, String serviceAccountJson) {
        this(openApiSpec, pathUrl, toolName, toolDescription, null, null, null, serviceAccountJson, new DefaultHttpExecutor().createExecutor(serviceAccountJson));
    }

    IntegrationConnectorTool(String openApiSpec, String pathUrl, String toolName, String toolDescription, String connectionName, String serviceName, String host, String serviceAccountJson) {
        this(openApiSpec, pathUrl, toolName, toolDescription, connectionName, serviceName, host, serviceAccountJson, new DefaultHttpExecutor().createExecutor(serviceAccountJson));
    }

    IntegrationConnectorTool(String openApiSpec, String pathUrl, String toolName, String toolDescription, @Nullable String connectionName, @Nullable String serviceName, @Nullable String host, @Nullable String serviceAccountJson, HttpExecutor httpExecutor) {
        super(toolName, toolDescription);
        this.openApiSpec = openApiSpec;
        this.pathUrl = pathUrl;
        this.connectionName = connectionName;
        this.serviceName = serviceName;
        this.host = host;
        this.httpExecutor = httpExecutor;
    }

    Schema toGeminiSchema(String openApiSchema, String operationId) throws Exception {
        String resolvedSchemaString = this.getResolvedRequestSchemaByOperationId(openApiSchema, operationId);
        return Schema.fromJson((String)resolvedSchemaString);
    }

    @Override
    public Optional<FunctionDeclaration> declaration() {
        try {
            String operationId = this.getOperationIdFromPathUrl(this.openApiSpec, this.pathUrl);
            Schema parametersSchema = this.toGeminiSchema(this.openApiSpec, operationId);
            String operationDescription = this.getOperationDescription(this.openApiSpec, operationId);
            FunctionDeclaration declaration = FunctionDeclaration.builder().name(operationId).description(operationDescription).parameters(parametersSchema).build();
            return Optional.of(declaration);
        }
        catch (Exception e) {
            System.err.println("Failed to get OpenAPI spec: " + e.getMessage());
            return Optional.empty();
        }
    }

    @Override
    public Single<Map<String, Object>> runAsync(Map<String, Object> args, ToolContext toolContext) {
        if (this.connectionName != null) {
            args.put("connectionName", this.connectionName);
            args.put("serviceName", this.serviceName);
            args.put("host", this.host);
            if (!Strings.isNullOrEmpty((String)this.entity)) {
                args.put("entity", this.entity);
            } else if (!Strings.isNullOrEmpty((String)this.action)) {
                args.put("action", this.action);
            }
            if (!Strings.isNullOrEmpty((String)this.operation)) {
                args.put("operation", this.operation);
            }
        }
        return Single.fromCallable(() -> {
            try {
                String response = this.executeIntegration(args);
                return ImmutableMap.of((Object)"result", (Object)response);
            }
            catch (Exception e) {
                System.err.println("Failed to execute integration: " + e.getMessage());
                return ImmutableMap.of((Object)"error", (Object)e.getMessage());
            }
        });
    }

    private String executeIntegration(Map<String, Object> args) throws Exception {
        String jsonRequestBody;
        String url = String.format("https://integrations.googleapis.com%s", this.pathUrl);
        try {
            jsonRequestBody = OBJECT_MAPPER.writeValueAsString(args);
        }
        catch (IOException e) {
            throw new Exception("Error converting args to JSON: " + e.getMessage(), e);
        }
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).header("Authorization", "Bearer " + this.httpExecutor.getToken()).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(jsonRequestBody)).build();
        HttpResponse<String> response = this.httpExecutor.send(request, HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() < 200 || response.statusCode() >= 300) {
            throw new Exception("Error executing integration. Status: " + response.statusCode() + " , Response: " + response.body());
        }
        return response.body();
    }

    String getOperationIdFromPathUrl(String openApiSchemaString, String pathUrl) throws Exception {
        JsonNode topLevelNode = OBJECT_MAPPER.readTree(openApiSchemaString);
        JsonNode specNode = topLevelNode.path("openApiSpec");
        if (specNode.isMissingNode() || !specNode.isTextual()) {
            throw new IllegalArgumentException("Failed to get OpenApiSpec, please check the project and region for the integration.");
        }
        JsonNode rootNode = OBJECT_MAPPER.readTree(specNode.asText());
        JsonNode paths = rootNode.path("paths");
        Iterator pathsFields = paths.fields();
        while (pathsFields.hasNext()) {
            Map.Entry pathEntry = (Map.Entry)pathsFields.next();
            String currentPath = (String)pathEntry.getKey();
            if (!currentPath.equals(pathUrl)) continue;
            JsonNode pathItem = (JsonNode)pathEntry.getValue();
            Iterator methods = pathItem.fields();
            while (methods.hasNext()) {
                Map.Entry methodEntry = (Map.Entry)methods.next();
                JsonNode operationNode = (JsonNode)methodEntry.getValue();
                this.entity = "";
                this.operation = "";
                this.action = "";
                if (operationNode.has("x-entity")) {
                    this.entity = operationNode.path("x-entity").asText();
                } else if (operationNode.has("x-action")) {
                    this.action = operationNode.path("x-action").asText();
                }
                if (operationNode.has("x-operation")) {
                    this.operation = operationNode.path("x-operation").asText();
                }
                if (!operationNode.has("operationId")) continue;
                return operationNode.path("operationId").asText();
            }
        }
        throw new Exception("Could not find operationId for pathUrl: " + pathUrl);
    }

    private String getResolvedRequestSchemaByOperationId(String openApiSchemaString, String operationId) throws Exception {
        JsonNode topLevelNode = OBJECT_MAPPER.readTree(openApiSchemaString);
        JsonNode specNode = topLevelNode.path("openApiSpec");
        if (specNode.isMissingNode() || !specNode.isTextual()) {
            throw new IllegalArgumentException("Failed to get OpenApiSpec, please check the project and region for the integration.");
        }
        JsonNode rootNode = OBJECT_MAPPER.readTree(specNode.asText());
        JsonNode operationNode = this.findOperationNodeById(rootNode, operationId);
        if (operationNode == null) {
            throw new Exception("Could not find operation with operationId: " + operationId);
        }
        JsonNode requestSchemaNode = operationNode.path("requestBody").path("content").path("application/json").path("schema");
        if (requestSchemaNode.isMissingNode()) {
            throw new Exception("Could not find request body schema for operationId: " + operationId);
        }
        JsonNode resolvedSchema = this.resolveRefs(requestSchemaNode, rootNode);
        if (resolvedSchema.isObject()) {
            JsonNode requiredNode;
            ObjectNode schemaObject = (ObjectNode)resolvedSchema;
            JsonNode propertiesNode = schemaObject.path("properties");
            if (propertiesNode.isObject()) {
                ObjectNode propertiesObject = (ObjectNode)propertiesNode;
                for (String field : EXCLUDE_FIELDS) {
                    propertiesObject.remove(field);
                }
            }
            if ((requiredNode = schemaObject.path("required")).isArray()) {
                List fieldsToRemove = Streams.concat((Stream[])new Stream[]{OPTIONAL_FIELDS.stream(), EXCLUDE_FIELDS.stream()}).toList();
                ArrayNode requiredArray = (ArrayNode)requiredNode;
                Iterator elements = requiredArray.elements();
                while (elements.hasNext()) {
                    JsonNode element = (JsonNode)elements.next();
                    if (!element.isTextual() || !fieldsToRemove.contains(element.asText())) continue;
                    elements.remove();
                }
            }
        }
        return OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)resolvedSchema);
    }

    private @Nullable JsonNode findOperationNodeById(JsonNode rootNode, String operationId) {
        JsonNode paths = rootNode.path("paths");
        for (JsonNode pathItem : paths) {
            Iterator methods = pathItem.fields();
            while (methods.hasNext()) {
                Map.Entry methodEntry = (Map.Entry)methods.next();
                JsonNode operationNode = (JsonNode)methodEntry.getValue();
                if (!operationNode.path("operationId").asText().equals(operationId)) continue;
                return operationNode;
            }
        }
        return null;
    }

    private JsonNode resolveRefs(JsonNode currentNode, JsonNode rootNode) {
        if (currentNode.isObject()) {
            ObjectNode objectNode = (ObjectNode)currentNode;
            if (objectNode.has("$ref")) {
                String refPath = objectNode.get("$ref").asText();
                if (refPath.isEmpty() || !refPath.startsWith("#/")) {
                    return objectNode;
                }
                JsonNode referencedNode = rootNode.at(refPath.substring(1));
                if (referencedNode.isMissingNode()) {
                    return objectNode;
                }
                return this.resolveRefs(referencedNode, rootNode);
            }
            ObjectNode newObjectNode = OBJECT_MAPPER.createObjectNode();
            Iterator fields = currentNode.fields();
            while (fields.hasNext()) {
                Map.Entry field = (Map.Entry)fields.next();
                newObjectNode.set((String)field.getKey(), this.resolveRefs((JsonNode)field.getValue(), rootNode));
            }
            return newObjectNode;
        }
        return currentNode;
    }

    private String getOperationDescription(String openApiSchemaString, String operationId) throws Exception {
        JsonNode topLevelNode = OBJECT_MAPPER.readTree(openApiSchemaString);
        JsonNode specNode = topLevelNode.path("openApiSpec");
        if (specNode.isMissingNode() || !specNode.isTextual()) {
            return "";
        }
        JsonNode rootNode = OBJECT_MAPPER.readTree(specNode.asText());
        JsonNode operationNode = this.findOperationNodeById(rootNode, operationId);
        if (operationNode == null) {
            return "";
        }
        return operationNode.path("summary").asText();
    }

    static class DefaultHttpExecutor
    implements HttpExecutor {
        private final HttpClient client = HttpClient.newHttpClient();
        private final String serviceAccountJson;

        DefaultHttpExecutor() {
            this(null);
        }

        DefaultHttpExecutor(@Nullable String serviceAccountJson) {
            this.serviceAccountJson = serviceAccountJson;
        }

        @Override
        public <T> HttpResponse<T> send(HttpRequest request, HttpResponse.BodyHandler<T> responseBodyHandler) throws IOException, InterruptedException {
            return this.client.send(request, responseBodyHandler);
        }

        @Override
        public String getToken() throws IOException {
            GoogleCredentials credentials;
            block10: {
                if (this.serviceAccountJson != null && !this.serviceAccountJson.trim().isEmpty()) {
                    try (ByteArrayInputStream is = new ByteArrayInputStream(this.serviceAccountJson.getBytes(StandardCharsets.UTF_8));){
                        credentials = GoogleCredentials.fromStream((InputStream)is).createScoped(new String[]{"https://www.googleapis.com/auth/cloud-platform"});
                        break block10;
                    }
                    catch (IOException e) {
                        throw new IOException("Failed to load credentials from service_account_json.", e);
                    }
                }
                try {
                    credentials = GoogleCredentials.getApplicationDefault().createScoped(new String[]{"https://www.googleapis.com/auth/cloud-platform"});
                }
                catch (IOException e) {
                    throw new IOException("Please provide a service account or configure Application Default Credentials. To set up ADC, see https://cloud.google.com/docs/authentication/external/set-up-adc.", e);
                }
            }
            credentials.refreshIfExpired();
            return credentials.getAccessToken().getTokenValue();
        }

        @Override
        public HttpExecutor createExecutor(String serviceAccountJson) {
            if (Strings.isNullOrEmpty((String)serviceAccountJson)) {
                return new DefaultHttpExecutor();
            }
            return new DefaultHttpExecutor(serviceAccountJson);
        }
    }

    static interface HttpExecutor {
        public <T> HttpResponse<T> send(HttpRequest var1, HttpResponse.BodyHandler<T> var2) throws IOException, InterruptedException;

        public String getToken() throws IOException;

        public HttpExecutor createExecutor(String var1);
    }
}

