/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.utils;

import com.google.adk.agents.BaseAgent;
import com.google.adk.agents.Callbacks;
import com.google.adk.agents.LlmAgent;
import com.google.adk.agents.LoopAgent;
import com.google.adk.agents.ParallelAgent;
import com.google.adk.agents.SequentialAgent;
import com.google.adk.tools.AgentTool;
import com.google.adk.tools.BaseTool;
import com.google.adk.tools.BaseToolset;
import com.google.adk.tools.ExitLoopTool;
import com.google.adk.tools.GoogleSearchTool;
import com.google.adk.tools.LoadArtifactsTool;
import com.google.adk.tools.mcp.McpToolset;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentRegistry {
    private static final Logger logger = LoggerFactory.getLogger(ComponentRegistry.class);
    private static volatile ComponentRegistry instance = new ComponentRegistry();
    private final Map<String, Object> registry = new ConcurrentHashMap<String, Object>();

    protected ComponentRegistry() {
        this.initializePreWiredEntries();
    }

    private void initializePreWiredEntries() {
        this.registerAdkAgentClass(LlmAgent.class);
        this.registerAdkAgentClass(LoopAgent.class);
        this.registerAdkAgentClass(ParallelAgent.class);
        this.registerAdkAgentClass(SequentialAgent.class);
        this.registerAdkToolInstance("google_search", GoogleSearchTool.INSTANCE);
        this.registerAdkToolInstance("load_artifacts", LoadArtifactsTool.INSTANCE);
        this.registerAdkToolInstance("exit_loop", ExitLoopTool.INSTANCE);
        this.registerAdkToolClass(AgentTool.class);
        this.registerAdkToolsetClass(McpToolset.class);
        logger.debug("Initialized base pre-wired entries in ComponentRegistry");
    }

    private void registerAdkAgentClass(Class<? extends BaseAgent> agentClass) {
        this.registry.put(agentClass.getName(), agentClass);
        this.registry.put("google.adk.agents." + agentClass.getSimpleName(), agentClass);
    }

    private void registerAdkToolInstance(String name, @Nonnull Object toolInstance) {
        this.registry.put(name, toolInstance);
        this.registry.put("google.adk.tools." + name, toolInstance);
    }

    private void registerAdkToolClass(@Nonnull Class<?> toolClass) {
        this.registry.put(toolClass.getName(), toolClass);
        this.registry.put("google.adk.tools." + toolClass.getSimpleName(), toolClass);
    }

    private void registerAdkToolsetClass(@Nonnull Class<? extends BaseToolset> toolsetClass) {
        this.registry.put(toolsetClass.getName(), toolsetClass);
        this.registry.put("google.adk.tools." + toolsetClass.getSimpleName(), toolsetClass);
        this.registry.put(toolsetClass.getSimpleName(), toolsetClass);
        String simpleName = toolsetClass.getSimpleName();
        if (simpleName.equals("McpToolset")) {
            this.registry.put("mcp.McpToolset", toolsetClass);
        }
    }

    public void register(String name, Object value) {
        if (Strings.isNullOrEmpty((String)name) || name.trim().isEmpty()) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null");
        }
        Object previous = this.registry.put(name, value);
        if (previous != null) {
            logger.info("Overriding existing registration for name: {} (was: {}, now: {})", new Object[]{name, previous.getClass().getSimpleName(), value.getClass().getSimpleName()});
        } else {
            logger.debug("Registered new object of type {} with name: {}", (Object)value.getClass().getSimpleName(), (Object)name);
        }
    }

    public <T> Optional<T> get(String name, Class<T> type) {
        return this.get(name).filter(value -> {
            if (type.isInstance(value)) {
                return true;
            }
            logger.info("Object with name '{}' is of type {} but expected type {}", new Object[]{name, value.getClass().getSimpleName(), type.getSimpleName()});
            return false;
        }).map(type::cast);
    }

    public Optional<Object> get(String name) {
        if (name == null || name.trim().isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.registry.get(name));
    }

    public static ComponentRegistry getInstance() {
        return instance;
    }

    public static synchronized void setInstance(ComponentRegistry newInstance) {
        if (newInstance == null) {
            throw new IllegalArgumentException("ComponentRegistry instance cannot be null");
        }
        instance = newInstance;
        logger.info("ComponentRegistry singleton instance updated");
    }

    public static Optional<BaseAgent> resolveAgentInstance(String name) {
        if (Strings.isNullOrEmpty((String)name)) {
            return Optional.empty();
        }
        ComponentRegistry registry = ComponentRegistry.getInstance();
        return registry.get(name, BaseAgent.class);
    }

    public static Class<? extends BaseAgent> resolveAgentClass(String agentClassName) {
        if (Strings.isNullOrEmpty((String)agentClassName)) {
            return LlmAgent.class;
        }
        ComponentRegistry registry = ComponentRegistry.getInstance();
        if (agentClassName.contains(".")) {
            Optional<Class> agentClass = registry.get(agentClassName, Class.class);
            if (agentClass.isPresent() && BaseAgent.class.isAssignableFrom(agentClass.get())) {
                return agentClass.get();
            }
        } else {
            Optional<Class> agentClass = registry.get(agentClassName, Class.class);
            if (agentClass.isPresent() && BaseAgent.class.isAssignableFrom(agentClass.get())) {
                return agentClass.get();
            }
            agentClass = registry.get("com.google.adk.agents." + agentClassName, Class.class);
            if (agentClass.isPresent() && BaseAgent.class.isAssignableFrom(agentClass.get())) {
                return agentClass.get();
            }
            agentClass = registry.get("google.adk.agents." + agentClassName, Class.class);
            if (agentClass.isPresent() && BaseAgent.class.isAssignableFrom(agentClass.get())) {
                return agentClass.get();
            }
        }
        throw new IllegalArgumentException("agentClass '" + agentClassName + "' is not in registry or not a subclass of BaseAgent.");
    }

    public static Optional<BaseToolset> resolveToolsetInstance(String name) {
        if (Strings.isNullOrEmpty((String)name)) {
            return Optional.empty();
        }
        ComponentRegistry registry = ComponentRegistry.getInstance();
        if (name.contains(".")) {
            return registry.get(name, BaseToolset.class);
        }
        return registry.get(name, BaseToolset.class).or(() -> registry.get("com.google.adk.tools." + name, BaseToolset.class)).or(() -> registry.get("google.adk.tools." + name, BaseToolset.class));
    }

    public static Optional<BaseTool> resolveToolInstance(String name) {
        if (Strings.isNullOrEmpty((String)name)) {
            return Optional.empty();
        }
        ComponentRegistry registry = ComponentRegistry.getInstance();
        if (name.contains(".")) {
            return registry.get(name, BaseTool.class);
        }
        return registry.get(name, BaseTool.class).or(() -> registry.get("com.google.adk.tools." + name, BaseTool.class)).or(() -> registry.get("google.adk.tools." + name, BaseTool.class));
    }

    public static Optional<Class<? extends BaseTool>> resolveToolClass(String toolClassName) {
        if (Strings.isNullOrEmpty((String)toolClassName)) {
            return Optional.empty();
        }
        ComponentRegistry registry = ComponentRegistry.getInstance();
        if (toolClassName.contains(".")) {
            Optional<Class> toolClass = registry.get(toolClassName, Class.class);
            if (toolClass.isPresent() && BaseTool.class.isAssignableFrom(toolClass.get())) {
                return Optional.of(toolClass.get());
            }
        } else {
            Optional<Class> toolClass = registry.get(toolClassName, Class.class);
            if (toolClass.isPresent() && BaseTool.class.isAssignableFrom(toolClass.get())) {
                return Optional.of(toolClass.get());
            }
            toolClass = registry.get("com.google.adk.tools." + toolClassName, Class.class);
            if (toolClass.isPresent() && BaseTool.class.isAssignableFrom(toolClass.get())) {
                return Optional.of(toolClass.get());
            }
            toolClass = registry.get("google.adk.tools." + toolClassName, Class.class);
            if (toolClass.isPresent() && BaseTool.class.isAssignableFrom(toolClass.get())) {
                return Optional.of(toolClass.get());
            }
        }
        return Optional.empty();
    }

    public static Optional<Class<? extends BaseToolset>> resolveToolsetClass(String toolsetClassName) {
        if (Strings.isNullOrEmpty((String)toolsetClassName)) {
            return Optional.empty();
        }
        ComponentRegistry registry = ComponentRegistry.getInstance();
        if (toolsetClassName.contains(".")) {
            Optional<Class> toolsetClass = registry.get(toolsetClassName, Class.class);
            if (toolsetClass.isPresent() && BaseToolset.class.isAssignableFrom(toolsetClass.get())) {
                return Optional.of(toolsetClass.get());
            }
            try {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(toolsetClassName);
                if (BaseToolset.class.isAssignableFrom(clazz)) {
                    return Optional.of(clazz.asSubclass(BaseToolset.class));
                }
            }
            catch (ClassNotFoundException classNotFoundException) {}
        } else {
            Optional<Class> toolsetClass = registry.get(toolsetClassName, Class.class);
            if (toolsetClass.isPresent() && BaseToolset.class.isAssignableFrom(toolsetClass.get())) {
                return Optional.of(toolsetClass.get());
            }
            toolsetClass = registry.get("google.adk.tools." + toolsetClassName, Class.class);
            if (toolsetClass.isPresent() && BaseToolset.class.isAssignableFrom(toolsetClass.get())) {
                return Optional.of(toolsetClass.get());
            }
        }
        return Optional.empty();
    }

    public Set<String> getToolNamesWithPrefix(String prefix) {
        return (Set)this.registry.keySet().stream().filter(name -> name.startsWith(prefix)).collect(ImmutableSet.toImmutableSet());
    }

    public static Optional<Callbacks.BeforeAgentCallback> resolveBeforeAgentCallback(String name) {
        return ComponentRegistry.resolveCallback(name, Callbacks.BeforeAgentCallback.class);
    }

    public static Optional<Callbacks.AfterAgentCallback> resolveAfterAgentCallback(String name) {
        return ComponentRegistry.resolveCallback(name, Callbacks.AfterAgentCallback.class);
    }

    public static Optional<Callbacks.BeforeModelCallback> resolveBeforeModelCallback(String name) {
        return ComponentRegistry.resolveCallback(name, Callbacks.BeforeModelCallback.class);
    }

    public static Optional<Callbacks.AfterModelCallback> resolveAfterModelCallback(String name) {
        return ComponentRegistry.resolveCallback(name, Callbacks.AfterModelCallback.class);
    }

    public static Optional<Callbacks.BeforeToolCallback> resolveBeforeToolCallback(String name) {
        return ComponentRegistry.resolveCallback(name, Callbacks.BeforeToolCallback.class);
    }

    public static Optional<Callbacks.AfterToolCallback> resolveAfterToolCallback(String name) {
        return ComponentRegistry.resolveCallback(name, Callbacks.AfterToolCallback.class);
    }

    private static <T> Optional<T> resolveCallback(String name, Class<T> type) {
        if (Strings.isNullOrEmpty((String)name)) {
            return Optional.empty();
        }
        ComponentRegistry registry = ComponentRegistry.getInstance();
        return registry.get(name, type);
    }
}

