/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.datatransport.cct.internal;

import android.util.SparseArray;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.datatransport.cct.internal.AutoValue_NetworkConnectionInfo;
import com.google.auto.value.AutoValue;

@AutoValue
public abstract class NetworkConnectionInfo {
    @Nullable
    public abstract NetworkType getNetworkType();

    @Nullable
    public abstract MobileSubtype getMobileSubtype();

    @NonNull
    public static Builder builder() {
        return new AutoValue_NetworkConnectionInfo.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @NonNull
        public abstract Builder setNetworkType(@Nullable NetworkType var1);

        @NonNull
        public abstract Builder setMobileSubtype(@Nullable MobileSubtype var1);

        @NonNull
        public abstract NetworkConnectionInfo build();
    }

    public static enum MobileSubtype {
        UNKNOWN_MOBILE_SUBTYPE(0),
        GPRS(1),
        EDGE(2),
        UMTS(3),
        CDMA(4),
        EVDO_0(5),
        EVDO_A(6),
        RTT(7),
        HSDPA(8),
        HSUPA(9),
        HSPA(10),
        IDEN(11),
        EVDO_B(12),
        LTE(13),
        EHRPD(14),
        HSPAP(15),
        GSM(16),
        TD_SCDMA(17),
        IWLAN(18),
        LTE_CA(19),
        COMBINED(100);

        private static final SparseArray<MobileSubtype> valueMap;
        private final int value;

        private MobileSubtype(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        @Nullable
        public static MobileSubtype forNumber(int value) {
            return (MobileSubtype)((Object)valueMap.get(value));
        }

        static {
            valueMap = new SparseArray();
            valueMap.put(0, (Object)UNKNOWN_MOBILE_SUBTYPE);
            valueMap.put(1, (Object)GPRS);
            valueMap.put(2, (Object)EDGE);
            valueMap.put(3, (Object)UMTS);
            valueMap.put(4, (Object)CDMA);
            valueMap.put(5, (Object)EVDO_0);
            valueMap.put(6, (Object)EVDO_A);
            valueMap.put(7, (Object)RTT);
            valueMap.put(8, (Object)HSDPA);
            valueMap.put(9, (Object)HSUPA);
            valueMap.put(10, (Object)HSPA);
            valueMap.put(11, (Object)IDEN);
            valueMap.put(12, (Object)EVDO_B);
            valueMap.put(13, (Object)LTE);
            valueMap.put(14, (Object)EHRPD);
            valueMap.put(15, (Object)HSPAP);
            valueMap.put(16, (Object)GSM);
            valueMap.put(17, (Object)TD_SCDMA);
            valueMap.put(18, (Object)IWLAN);
            valueMap.put(19, (Object)LTE_CA);
        }
    }

    public static enum NetworkType {
        MOBILE(0),
        WIFI(1),
        MOBILE_MMS(2),
        MOBILE_SUPL(3),
        MOBILE_DUN(4),
        MOBILE_HIPRI(5),
        WIMAX(6),
        BLUETOOTH(7),
        DUMMY(8),
        ETHERNET(9),
        MOBILE_FOTA(10),
        MOBILE_IMS(11),
        MOBILE_CBS(12),
        WIFI_P2P(13),
        MOBILE_IA(14),
        MOBILE_EMERGENCY(15),
        PROXY(16),
        VPN(17),
        NONE(-1);

        private static final SparseArray<NetworkType> valueMap;
        private final int value;

        private NetworkType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        @Nullable
        public static NetworkType forNumber(int value) {
            return (NetworkType)((Object)valueMap.get(value));
        }

        static {
            valueMap = new SparseArray();
            valueMap.put(0, (Object)MOBILE);
            valueMap.put(1, (Object)WIFI);
            valueMap.put(2, (Object)MOBILE_MMS);
            valueMap.put(3, (Object)MOBILE_SUPL);
            valueMap.put(4, (Object)MOBILE_DUN);
            valueMap.put(5, (Object)MOBILE_HIPRI);
            valueMap.put(6, (Object)WIMAX);
            valueMap.put(7, (Object)BLUETOOTH);
            valueMap.put(8, (Object)DUMMY);
            valueMap.put(9, (Object)ETHERNET);
            valueMap.put(10, (Object)MOBILE_FOTA);
            valueMap.put(11, (Object)MOBILE_IMS);
            valueMap.put(12, (Object)MOBILE_CBS);
            valueMap.put(13, (Object)WIFI_P2P);
            valueMap.put(14, (Object)MOBILE_IA);
            valueMap.put(15, (Object)MOBILE_EMERGENCY);
            valueMap.put(16, (Object)PROXY);
            valueMap.put(17, (Object)VPN);
            valueMap.put(-1, (Object)NONE);
        }
    }
}

