/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.datatransport.runtime.retries;

import com.google.android.datatransport.runtime.retries.Function;
import com.google.android.datatransport.runtime.retries.RetryStrategy;

public final class Retries {
    private Retries() {
    }

    public static <TInput, TResult, TException extends Throwable> TResult retry(int maxAttempts, TInput input, Function<TInput, TResult, TException> function, RetryStrategy<TInput, TResult> retryStrategy) throws TException {
        TResult result;
        if (maxAttempts < 1) {
            return function.apply(input);
        }
        while ((input = retryStrategy.shouldRetry(input, result = function.apply(input))) != null && --maxAttempts >= 1) {
        }
        return result;
    }
}

