/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.datatransport.runtime.scheduling.persistence;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDatabaseLockedException;
import android.os.SystemClock;
import android.util.Base64;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.android.datatransport.Encoding;
import com.google.android.datatransport.runtime.EncodedPayload;
import com.google.android.datatransport.runtime.EventInternal;
import com.google.android.datatransport.runtime.TransportContext;
import com.google.android.datatransport.runtime.logging.Logging;
import com.google.android.datatransport.runtime.scheduling.persistence.EventStore;
import com.google.android.datatransport.runtime.scheduling.persistence.EventStoreConfig;
import com.google.android.datatransport.runtime.scheduling.persistence.PersistedEvent;
import com.google.android.datatransport.runtime.scheduling.persistence.SQLiteEventStore$$Lambda$1;
import com.google.android.datatransport.runtime.scheduling.persistence.SQLiteEventStore$$Lambda$10;
import com.google.android.datatransport.runtime.scheduling.persistence.SQLiteEventStore$$Lambda$11;
import com.google.android.datatransport.runtime.scheduling.persistence.SQLiteEventStore$$Lambda$12;
import com.google.android.datatransport.runtime.scheduling.persistence.SQLiteEventStore$$Lambda$13;
import com.google.android.datatransport.runtime.scheduling.persistence.SQLiteEventStore$$Lambda$14;
import com.google.android.datatransport.runtime.scheduling.persistence.SQLiteEventStore$$Lambda$15;
import com.google.android.datatransport.runtime.scheduling.persistence.SQLiteEventStore$$Lambda$16;
import com.google.android.datatransport.runtime.scheduling.persistence.SQLiteEventStore$$Lambda$17;
import com.google.android.datatransport.runtime.scheduling.persistence.SQLiteEventStore$$Lambda$18;
import com.google.android.datatransport.runtime.scheduling.persistence.SQLiteEventStore$$Lambda$19;
import com.google.android.datatransport.runtime.scheduling.persistence.SQLiteEventStore$$Lambda$20;
import com.google.android.datatransport.runtime.scheduling.persistence.SQLiteEventStore$$Lambda$21;
import com.google.android.datatransport.runtime.scheduling.persistence.SQLiteEventStore$$Lambda$4;
import com.google.android.datatransport.runtime.scheduling.persistence.SQLiteEventStore$$Lambda$5;
import com.google.android.datatransport.runtime.scheduling.persistence.SQLiteEventStore$$Lambda$6;
import com.google.android.datatransport.runtime.scheduling.persistence.SQLiteEventStore$$Lambda$7;
import com.google.android.datatransport.runtime.scheduling.persistence.SQLiteEventStore$$Lambda$8;
import com.google.android.datatransport.runtime.scheduling.persistence.SQLiteEventStore$$Lambda$9;
import com.google.android.datatransport.runtime.scheduling.persistence.SchemaManager;
import com.google.android.datatransport.runtime.synchronization.SynchronizationException;
import com.google.android.datatransport.runtime.synchronization.SynchronizationGuard;
import com.google.android.datatransport.runtime.time.Clock;
import com.google.android.datatransport.runtime.time.Monotonic;
import com.google.android.datatransport.runtime.time.WallTime;
import com.google.android.datatransport.runtime.util.PriorityMapping;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
@WorkerThread
public class SQLiteEventStore
implements EventStore,
SynchronizationGuard {
    private static final String LOG_TAG = "SQLiteEventStore";
    static final int MAX_RETRIES = 10;
    private static final int LOCK_RETRY_BACK_OFF_MILLIS = 50;
    private static final Encoding PROTOBUF_ENCODING = Encoding.of((String)"proto");
    private final SchemaManager schemaManager;
    private final Clock wallClock;
    private final Clock monotonicClock;
    private final EventStoreConfig config;

    @Inject
    SQLiteEventStore(@WallTime Clock wallClock, @Monotonic Clock clock, EventStoreConfig config, SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
        this.wallClock = wallClock;
        this.monotonicClock = clock;
        this.config = config;
    }

    @VisibleForTesting
    SQLiteDatabase getDb() {
        SchemaManager schemaManager = this.schemaManager;
        ((Object)((Object)schemaManager)).getClass();
        return (SQLiteDatabase)this.retryIfDbLocked(SQLiteEventStore$$Lambda$1.lambdaFactory$(schemaManager), SQLiteEventStore$$Lambda$4.lambdaFactory$());
    }

    @Override
    @Nullable
    public PersistedEvent persist(TransportContext transportContext, EventInternal event) {
        Logging.d(LOG_TAG, "Storing event with priority=%s, name=%s for destination %s", transportContext.getPriority(), event.getTransportName(), transportContext.getBackendName());
        long newRowId = (Long)this.inTransaction(SQLiteEventStore$$Lambda$5.lambdaFactory$(this, transportContext, event));
        if (newRowId < 1L) {
            return null;
        }
        return PersistedEvent.create(newRowId, transportContext, event);
    }

    private long ensureTransportContext(SQLiteDatabase db, TransportContext transportContext) {
        Long existingId = this.getTransportContextId(db, transportContext);
        if (existingId != null) {
            return existingId;
        }
        ContentValues record = new ContentValues();
        record.put("backend_name", transportContext.getBackendName());
        record.put("priority", Integer.valueOf(PriorityMapping.toInt(transportContext.getPriority())));
        record.put("next_request_ms", Integer.valueOf(0));
        if (transportContext.getExtras() != null) {
            record.put("extras", Base64.encodeToString((byte[])transportContext.getExtras(), (int)0));
        }
        return db.insert("transport_contexts", null, record);
    }

    @Nullable
    private Long getTransportContextId(SQLiteDatabase db, TransportContext transportContext) {
        StringBuilder selection = new StringBuilder("backend_name = ? and priority = ?");
        ArrayList<String> selectionArgs = new ArrayList<String>(Arrays.asList(transportContext.getBackendName(), String.valueOf(PriorityMapping.toInt(transportContext.getPriority()))));
        if (transportContext.getExtras() != null) {
            selection.append(" and extras = ?");
            selectionArgs.add(Base64.encodeToString((byte[])transportContext.getExtras(), (int)0));
        }
        return (Long)SQLiteEventStore.tryWithCursor(db.query("transport_contexts", new String[]{"_id"}, selection.toString(), selectionArgs.toArray(new String[0]), null, null, null), SQLiteEventStore$$Lambda$6.lambdaFactory$());
    }

    @Override
    public void recordFailure(Iterable<PersistedEvent> events) {
        if (!events.iterator().hasNext()) {
            return;
        }
        String query = "UPDATE events SET num_attempts = num_attempts + 1 WHERE _id in " + SQLiteEventStore.toIdList(events);
        this.inTransaction(SQLiteEventStore$$Lambda$7.lambdaFactory$(query));
    }

    @Override
    public void recordSuccess(Iterable<PersistedEvent> events) {
        if (!events.iterator().hasNext()) {
            return;
        }
        String query = "DELETE FROM events WHERE _id in " + SQLiteEventStore.toIdList(events);
        this.getDb().compileStatement(query).execute();
    }

    private static String toIdList(Iterable<PersistedEvent> events) {
        StringBuilder idList = new StringBuilder("(");
        Iterator<PersistedEvent> iterator = events.iterator();
        while (iterator.hasNext()) {
            idList.append(iterator.next().getId());
            if (!iterator.hasNext()) continue;
            idList.append(',');
        }
        idList.append(')');
        return idList.toString();
    }

    @Override
    public long getNextCallTime(TransportContext transportContext) {
        return (Long)SQLiteEventStore.tryWithCursor(this.getDb().rawQuery("SELECT next_request_ms FROM transport_contexts WHERE backend_name = ? and priority = ?", new String[]{transportContext.getBackendName(), String.valueOf(PriorityMapping.toInt(transportContext.getPriority()))}), SQLiteEventStore$$Lambda$8.lambdaFactory$());
    }

    @Override
    public boolean hasPendingEventsFor(TransportContext transportContext) {
        return (Boolean)this.inTransaction(SQLiteEventStore$$Lambda$9.lambdaFactory$(this, transportContext));
    }

    @Override
    public void recordNextCallTime(TransportContext transportContext, long timestampMs) {
        this.inTransaction(SQLiteEventStore$$Lambda$10.lambdaFactory$(timestampMs, transportContext));
    }

    @Override
    public Iterable<PersistedEvent> loadBatch(TransportContext transportContext) {
        return (Iterable)this.inTransaction(SQLiteEventStore$$Lambda$11.lambdaFactory$(this, transportContext));
    }

    @Override
    public Iterable<TransportContext> loadActiveContexts() {
        return (Iterable)this.inTransaction(SQLiteEventStore$$Lambda$12.lambdaFactory$());
    }

    @Override
    public int cleanUp() {
        long oneWeekAgo = this.wallClock.getTime() - this.config.getEventCleanUpAge();
        return (Integer)this.inTransaction(SQLiteEventStore$$Lambda$13.lambdaFactory$(oneWeekAgo));
    }

    @Override
    public void close() {
        this.schemaManager.close();
    }

    @RestrictTo(value={RestrictTo.Scope.TESTS})
    public void clearDb() {
        this.inTransaction(SQLiteEventStore$$Lambda$14.lambdaFactory$());
    }

    private static byte[] maybeBase64Decode(@Nullable String value) {
        if (value == null) {
            return null;
        }
        return Base64.decode((String)value, (int)0);
    }

    private List<PersistedEvent> loadEvents(SQLiteDatabase db, TransportContext transportContext) {
        ArrayList<PersistedEvent> events = new ArrayList<PersistedEvent>();
        Long contextId = this.getTransportContextId(db, transportContext);
        if (contextId == null) {
            return events;
        }
        SQLiteEventStore.tryWithCursor(db.query("events", new String[]{"_id", "transport_name", "timestamp_ms", "uptime_ms", "payload_encoding", "payload", "code", "inline"}, "context_id = ?", new String[]{contextId.toString()}, null, null, null, String.valueOf(this.config.getLoadBatchSize())), SQLiteEventStore$$Lambda$15.lambdaFactory$(this, events, transportContext));
        return events;
    }

    private byte[] readPayload(long eventId) {
        return (byte[])SQLiteEventStore.tryWithCursor(this.getDb().query("event_payloads", new String[]{"bytes"}, "event_id = ?", new String[]{String.valueOf(eventId)}, null, null, "sequence_num"), SQLiteEventStore$$Lambda$16.lambdaFactory$());
    }

    private static Encoding toEncoding(@Nullable String value) {
        if (value == null) {
            return PROTOBUF_ENCODING;
        }
        return Encoding.of((String)value);
    }

    private Map<Long, Set<Metadata>> loadMetadata(SQLiteDatabase db, List<PersistedEvent> events) {
        HashMap<Long, Set<Metadata>> metadataIndex = new HashMap<Long, Set<Metadata>>();
        StringBuilder whereClause = new StringBuilder("event_id IN (");
        for (int i = 0; i < events.size(); ++i) {
            whereClause.append(events.get(i).getId());
            if (i >= events.size() - 1) continue;
            whereClause.append(',');
        }
        whereClause.append(')');
        SQLiteEventStore.tryWithCursor(db.query("event_metadata", new String[]{"event_id", "name", "value"}, whereClause.toString(), null, null, null, null), SQLiteEventStore$$Lambda$17.lambdaFactory$(metadataIndex));
        return metadataIndex;
    }

    private List<PersistedEvent> join(List<PersistedEvent> events, Map<Long, Set<Metadata>> metadataIndex) {
        ListIterator<PersistedEvent> iterator = events.listIterator();
        while (iterator.hasNext()) {
            PersistedEvent current = iterator.next();
            if (!metadataIndex.containsKey(current.getId())) continue;
            EventInternal.Builder newEvent = current.getEvent().toBuilder();
            for (Metadata metadata : metadataIndex.get(current.getId())) {
                newEvent.addMetadata(metadata.key, metadata.value);
            }
            iterator.set(PersistedEvent.create(current.getId(), current.getTransportContext(), newEvent.build()));
        }
        return events;
    }

    private <T> T retryIfDbLocked(Producer<T> retriable, Function<Throwable, T> failureHandler) {
        long startTime = this.monotonicClock.getTime();
        while (true) {
            try {
                return retriable.produce();
            }
            catch (SQLiteDatabaseLockedException ex) {
                if (this.monotonicClock.getTime() >= startTime + (long)this.config.getCriticalSectionEnterTimeoutMs()) {
                    return failureHandler.apply(ex);
                }
                SystemClock.sleep((long)50L);
                continue;
            }
            break;
        }
    }

    private void ensureBeginTransaction(SQLiteDatabase db) {
        this.retryIfDbLocked(SQLiteEventStore$$Lambda$18.lambdaFactory$(db), SQLiteEventStore$$Lambda$19.lambdaFactory$());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T runCriticalSection(SynchronizationGuard.CriticalSection<T> criticalSection) {
        SQLiteDatabase db = this.getDb();
        this.ensureBeginTransaction(db);
        try {
            T result = criticalSection.execute();
            db.setTransactionSuccessful();
            T t = result;
            return t;
        }
        finally {
            db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T inTransaction(Function<SQLiteDatabase, T> function) {
        SQLiteDatabase db = this.getDb();
        db.beginTransaction();
        try {
            T result = function.apply(db);
            db.setTransactionSuccessful();
            T t = result;
            return t;
        }
        finally {
            db.endTransaction();
        }
    }

    private boolean isStorageAtLimit() {
        long byteSize = this.getPageCount() * this.getPageSize();
        return byteSize >= this.config.getMaxStorageSizeInBytes();
    }

    @VisibleForTesting
    long getByteSize() {
        return this.getPageCount() * this.getPageSize();
    }

    private long getPageSize() {
        return this.getDb().compileStatement("PRAGMA page_size").simpleQueryForLong();
    }

    private long getPageCount() {
        return this.getDb().compileStatement("PRAGMA page_count").simpleQueryForLong();
    }

    private static <T> T tryWithCursor(Cursor c, Function<Cursor, T> function) {
        try {
            T t = function.apply(c);
            return t;
        }
        finally {
            c.close();
        }
    }

    static /* synthetic */ Object lambda$ensureBeginTransaction$16(Throwable ex) {
        throw new SynchronizationException("Timed out while trying to acquire the lock.", ex);
    }

    static /* synthetic */ Object lambda$ensureBeginTransaction$15(SQLiteDatabase db) {
        db.beginTransaction();
        return null;
    }

    static /* synthetic */ Object lambda$loadMetadata$14(Map metadataIndex, Cursor cursor) {
        while (cursor.moveToNext()) {
            long eventId = cursor.getLong(0);
            HashSet<Metadata> currentSet = (HashSet<Metadata>)metadataIndex.get(eventId);
            if (currentSet == null) {
                currentSet = new HashSet<Metadata>();
                metadataIndex.put(eventId, currentSet);
            }
            currentSet.add(new Metadata(cursor.getString(1), cursor.getString(2)));
        }
        return null;
    }

    static /* synthetic */ byte[] lambda$readPayload$13(Cursor cursor) {
        ArrayList<byte[]> chunks = new ArrayList<byte[]>();
        int totalLength = 0;
        while (cursor.moveToNext()) {
            byte[] chunk = cursor.getBlob(0);
            chunks.add(chunk);
            totalLength += chunk.length;
        }
        byte[] payloadBytes = new byte[totalLength];
        int offset = 0;
        for (int i = 0; i < chunks.size(); ++i) {
            byte[] chunk = (byte[])chunks.get(i);
            System.arraycopy(chunk, 0, payloadBytes, offset, chunk.length);
            offset += chunk.length;
        }
        return payloadBytes;
    }

    static /* synthetic */ Object lambda$loadEvents$12(SQLiteEventStore this_, List events, TransportContext transportContext, Cursor cursor) {
        while (cursor.moveToNext()) {
            long id = cursor.getLong(0);
            boolean inline = cursor.getInt(7) != 0;
            EventInternal.Builder event = EventInternal.builder().setTransportName(cursor.getString(1)).setEventMillis(cursor.getLong(2)).setUptimeMillis(cursor.getLong(3));
            if (inline) {
                event.setEncodedPayload(new EncodedPayload(SQLiteEventStore.toEncoding(cursor.getString(4)), cursor.getBlob(5)));
            } else {
                event.setEncodedPayload(new EncodedPayload(SQLiteEventStore.toEncoding(cursor.getString(4)), this_.readPayload(id)));
            }
            if (!cursor.isNull(6)) {
                event.setCode(cursor.getInt(6));
            }
            events.add(PersistedEvent.create(id, transportContext, event.build()));
        }
        return null;
    }

    static /* synthetic */ Object lambda$clearDb$11(SQLiteDatabase db) {
        db.delete("events", null, new String[0]);
        db.delete("transport_contexts", null, new String[0]);
        return null;
    }

    static /* synthetic */ Integer lambda$cleanUp$10(long oneWeekAgo, SQLiteDatabase db) {
        return db.delete("events", "timestamp_ms < ?", new String[]{String.valueOf(oneWeekAgo)});
    }

    static /* synthetic */ List lambda$loadActiveContexts$9(SQLiteDatabase db) {
        return (List)SQLiteEventStore.tryWithCursor(db.rawQuery("SELECT distinct t._id, t.backend_name, t.priority, t.extras FROM transport_contexts AS t, events AS e WHERE e.context_id = t._id", new String[0]), SQLiteEventStore$$Lambda$20.lambdaFactory$());
    }

    static /* synthetic */ List lambda$loadActiveContexts$8(Cursor cursor) {
        ArrayList<TransportContext> results = new ArrayList<TransportContext>();
        while (cursor.moveToNext()) {
            results.add(TransportContext.builder().setBackendName(cursor.getString(1)).setPriority(PriorityMapping.valueOf(cursor.getInt(2))).setExtras(SQLiteEventStore.maybeBase64Decode(cursor.getString(3))).build());
        }
        return results;
    }

    static /* synthetic */ List lambda$loadBatch$7(SQLiteEventStore this_, TransportContext transportContext, SQLiteDatabase db) {
        List<PersistedEvent> events = this_.loadEvents(db, transportContext);
        return this_.join(events, this_.loadMetadata(db, events));
    }

    static /* synthetic */ Object lambda$recordNextCallTime$6(long timestampMs, TransportContext transportContext, SQLiteDatabase db) {
        ContentValues values = new ContentValues();
        values.put("next_request_ms", Long.valueOf(timestampMs));
        int rowsUpdated = db.update("transport_contexts", values, "backend_name = ? and priority = ?", new String[]{transportContext.getBackendName(), String.valueOf(PriorityMapping.toInt(transportContext.getPriority()))});
        if (rowsUpdated < 1) {
            values.put("backend_name", transportContext.getBackendName());
            values.put("priority", Integer.valueOf(PriorityMapping.toInt(transportContext.getPriority())));
            db.insert("transport_contexts", null, values);
        }
        return null;
    }

    static /* synthetic */ Boolean lambda$hasPendingEventsFor$5(SQLiteEventStore this_, TransportContext transportContext, SQLiteDatabase db) {
        Long contextId = this_.getTransportContextId(db, transportContext);
        if (contextId == null) {
            return false;
        }
        return (Boolean)SQLiteEventStore.tryWithCursor(this_.getDb().rawQuery("SELECT 1 FROM events WHERE context_id = ? LIMIT 1", new String[]{contextId.toString()}), SQLiteEventStore$$Lambda$21.lambdaFactory$());
    }

    static /* synthetic */ Long lambda$getNextCallTime$4(Cursor cursor) {
        if (cursor.moveToNext()) {
            return cursor.getLong(0);
        }
        return 0L;
    }

    static /* synthetic */ Object lambda$recordFailure$3(String query, SQLiteDatabase db) {
        db.compileStatement(query).execute();
        db.compileStatement("DELETE FROM events WHERE num_attempts >= 10").execute();
        return null;
    }

    static /* synthetic */ Long lambda$getTransportContextId$2(Cursor cursor) {
        if (!cursor.moveToNext()) {
            return null;
        }
        return cursor.getLong(0);
    }

    static /* synthetic */ Long lambda$persist$1(SQLiteEventStore this_, TransportContext transportContext, EventInternal event, SQLiteDatabase db) {
        if (this_.isStorageAtLimit()) {
            return -1L;
        }
        long contextId = this_.ensureTransportContext(db, transportContext);
        int maxBlobSizePerRow = this_.config.getMaxBlobByteSizePerRow();
        byte[] payloadBytes = event.getEncodedPayload().getBytes();
        boolean inline = payloadBytes.length <= maxBlobSizePerRow;
        ContentValues values = new ContentValues();
        values.put("context_id", Long.valueOf(contextId));
        values.put("transport_name", event.getTransportName());
        values.put("timestamp_ms", Long.valueOf(event.getEventMillis()));
        values.put("uptime_ms", Long.valueOf(event.getUptimeMillis()));
        values.put("payload_encoding", event.getEncodedPayload().getEncoding().getName());
        values.put("code", event.getCode());
        values.put("num_attempts", Integer.valueOf(0));
        values.put("inline", Boolean.valueOf(inline));
        values.put("payload", inline ? payloadBytes : new byte[]{});
        long newEventId = db.insert("events", null, values);
        if (!inline) {
            int numChunks = (int)Math.ceil((double)payloadBytes.length / (double)maxBlobSizePerRow);
            for (int chunk = 1; chunk <= numChunks; ++chunk) {
                byte[] chunkBytes = Arrays.copyOfRange(payloadBytes, (chunk - 1) * maxBlobSizePerRow, Math.min(chunk * maxBlobSizePerRow, payloadBytes.length));
                ContentValues payloadValues = new ContentValues();
                payloadValues.put("event_id", Long.valueOf(newEventId));
                payloadValues.put("sequence_num", Integer.valueOf(chunk));
                payloadValues.put("bytes", chunkBytes);
                db.insert("event_payloads", null, payloadValues);
            }
        }
        for (Map.Entry<String, String> entry : event.getMetadata().entrySet()) {
            ContentValues metadata = new ContentValues();
            metadata.put("event_id", Long.valueOf(newEventId));
            metadata.put("name", entry.getKey());
            metadata.put("value", entry.getValue());
            db.insert("event_metadata", null, metadata);
        }
        return newEventId;
    }

    static /* synthetic */ SQLiteDatabase lambda$getDb$0(Throwable ex) {
        throw new SynchronizationException("Timed out while trying to open db.", ex);
    }

    private static class Metadata {
        final String key;
        final String value;

        private Metadata(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }

    static interface Function<T, U> {
        public U apply(T var1);
    }

    static interface Producer<T> {
        public T produce();
    }
}

