/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.datatransport.runtime.dagger.internal;

import com.google.android.datatransport.runtime.dagger.Lazy;
import com.google.android.datatransport.runtime.dagger.internal.MemoizedSentinel;
import com.google.android.datatransport.runtime.dagger.internal.Preconditions;
import javax.inject.Provider;

public final class DoubleCheck<T>
implements Provider<T>,
Lazy<T> {
    private static final Object UNINITIALIZED = new Object();
    private volatile Provider<T> provider;
    private volatile Object instance = UNINITIALIZED;

    private DoubleCheck(Provider<T> provider) {
        assert (provider != null);
        this.provider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        Object result = this.instance;
        if (result == UNINITIALIZED) {
            DoubleCheck doubleCheck = this;
            synchronized (doubleCheck) {
                result = this.instance;
                if (result == UNINITIALIZED) {
                    result = this.provider.get();
                    this.instance = DoubleCheck.reentrantCheck(this.instance, result);
                    this.provider = null;
                }
            }
        }
        return (T)result;
    }

    public static Object reentrantCheck(Object currentInstance, Object newInstance) {
        boolean isReentrant;
        boolean bl = isReentrant = currentInstance != UNINITIALIZED && !(currentInstance instanceof MemoizedSentinel);
        if (isReentrant && currentInstance != newInstance) {
            throw new IllegalStateException("Scoped provider was invoked recursively returning different results: " + currentInstance + " & " + newInstance + ". This is likely due to a circular dependency.");
        }
        return newInstance;
    }

    public static <P extends Provider<T>, T> Provider<T> provider(P delegate) {
        Preconditions.checkNotNull(delegate);
        if (delegate instanceof DoubleCheck) {
            return delegate;
        }
        return new DoubleCheck<T>(delegate);
    }

    public static <P extends Provider<T>, T> Lazy<T> lazy(P provider) {
        if (provider instanceof Lazy) {
            Lazy lazy = (Lazy)provider;
            return lazy;
        }
        return new DoubleCheck<T>(Preconditions.checkNotNull(provider));
    }
}

