/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.datatransport.runtime.util;

import android.util.SparseArray;
import androidx.annotation.NonNull;
import com.google.android.datatransport.Priority;
import java.util.HashMap;

public final class PriorityMapping {
    private static SparseArray<Priority> PRIORITY_MAP = new SparseArray();
    private static HashMap<Priority, Integer> PRIORITY_INT_MAP = new HashMap();

    @NonNull
    public static Priority valueOf(int value) {
        Priority priority = (Priority)PRIORITY_MAP.get(value);
        if (priority == null) {
            throw new IllegalArgumentException("Unknown Priority for value " + value);
        }
        return priority;
    }

    public static int toInt(@NonNull Priority priority) {
        Integer integer = PRIORITY_INT_MAP.get(priority);
        if (integer == null) {
            throw new IllegalStateException("PriorityMapping is missing known Priority value " + priority);
        }
        return integer;
    }

    static {
        PRIORITY_INT_MAP.put(Priority.DEFAULT, 0);
        PRIORITY_INT_MAP.put(Priority.VERY_LOW, 1);
        PRIORITY_INT_MAP.put(Priority.HIGHEST, 2);
        for (Priority p : PRIORITY_INT_MAP.keySet()) {
            PRIORITY_MAP.append(PRIORITY_INT_MAP.get(p).intValue(), (Object)p);
        }
    }
}

