/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.datatransport.runtime.scheduling.jobscheduling;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.google.android.datatransport.Encoding;
import com.google.android.datatransport.runtime.EncodedPayload;
import com.google.android.datatransport.runtime.EventInternal;
import com.google.android.datatransport.runtime.TransportContext;
import com.google.android.datatransport.runtime.backends.BackendRegistry;
import com.google.android.datatransport.runtime.backends.BackendRequest;
import com.google.android.datatransport.runtime.backends.BackendResponse;
import com.google.android.datatransport.runtime.backends.TransportBackend;
import com.google.android.datatransport.runtime.firebase.transport.ClientMetrics;
import com.google.android.datatransport.runtime.firebase.transport.LogEventDropped;
import com.google.android.datatransport.runtime.logging.Logging;
import com.google.android.datatransport.runtime.scheduling.jobscheduling.WorkScheduler;
import com.google.android.datatransport.runtime.scheduling.persistence.ClientHealthMetricsStore;
import com.google.android.datatransport.runtime.scheduling.persistence.EventStore;
import com.google.android.datatransport.runtime.scheduling.persistence.PersistedEvent;
import com.google.android.datatransport.runtime.synchronization.SynchronizationException;
import com.google.android.datatransport.runtime.synchronization.SynchronizationGuard;
import com.google.android.datatransport.runtime.time.Clock;
import com.google.android.datatransport.runtime.time.Monotonic;
import com.google.android.datatransport.runtime.time.WallTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.inject.Inject;

public class Uploader {
    private static final String LOG_TAG = "Uploader";
    private static final String CLIENT_HEALTH_METRICS_LOG_SOURCE = "GDT_CLIENT_METRICS";
    private final Context context;
    private final BackendRegistry backendRegistry;
    private final EventStore eventStore;
    private final WorkScheduler workScheduler;
    private final Executor executor;
    private final SynchronizationGuard guard;
    private final Clock clock;
    private final Clock uptimeClock;
    private final ClientHealthMetricsStore clientHealthMetricsStore;

    @Inject
    public Uploader(Context context, BackendRegistry backendRegistry, EventStore eventStore, WorkScheduler workScheduler, Executor executor, SynchronizationGuard guard, @WallTime Clock clock, @Monotonic Clock uptimeClock, ClientHealthMetricsStore clientHealthMetricsStore) {
        this.context = context;
        this.backendRegistry = backendRegistry;
        this.eventStore = eventStore;
        this.workScheduler = workScheduler;
        this.executor = executor;
        this.guard = guard;
        this.clock = clock;
        this.uptimeClock = uptimeClock;
        this.clientHealthMetricsStore = clientHealthMetricsStore;
    }

    boolean isNetworkAvailable() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.context.getSystemService("connectivity");
        NetworkInfo activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
        return activeNetworkInfo != null && activeNetworkInfo.isConnected();
    }

    public void upload(TransportContext transportContext, int attemptNumber, Runnable callback) {
        this.executor.execute(() -> {
            try {
                this.guard.runCriticalSection(this.eventStore::cleanUp);
                if (!this.isNetworkAvailable()) {
                    this.guard.runCriticalSection(() -> {
                        this.workScheduler.schedule(transportContext, attemptNumber + 1);
                        return null;
                    });
                } else {
                    this.logAndUpdateState(transportContext, attemptNumber);
                }
            }
            catch (SynchronizationException e) {
                this.workScheduler.schedule(transportContext, attemptNumber + 1);
            }
            finally {
                callback.run();
            }
        });
    }

    void logAndUpdateState(TransportContext transportContext, int attemptNumber) {
        TransportBackend backend = this.backendRegistry.get(transportContext.getBackendName());
        long maxNextRequestWaitMillis = 0L;
        while (this.guard.runCriticalSection(() -> this.eventStore.hasPendingEventsFor(transportContext)).booleanValue()) {
            BackendResponse response;
            Iterable persistedEvents = this.guard.runCriticalSection(() -> this.eventStore.loadBatch(transportContext));
            if (!persistedEvents.iterator().hasNext()) {
                return;
            }
            if (backend == null) {
                Logging.d(LOG_TAG, "Unknown backend for %s, deleting event batch for it...", (Object)transportContext);
                response = BackendResponse.fatalError();
            } else {
                ArrayList<EventInternal> eventInternals = new ArrayList<EventInternal>();
                for (PersistedEvent persistedEvent : persistedEvents) {
                    eventInternals.add(persistedEvent.getEvent());
                }
                if (transportContext.shouldUploadClientHealthMetrics()) {
                    ClientMetrics clientMetrics = this.guard.runCriticalSection(this.clientHealthMetricsStore::loadClientMetrics);
                    EventInternal eventInternal = EventInternal.builder().setEventMillis(this.clock.getTime()).setUptimeMillis(this.uptimeClock.getTime()).setTransportName(CLIENT_HEALTH_METRICS_LOG_SOURCE).setEncodedPayload(new EncodedPayload(Encoding.of((String)"proto"), clientMetrics.toByteArray())).build();
                    EventInternal decoratedEvent = backend.decorate(eventInternal);
                    eventInternals.add(decoratedEvent);
                }
                response = backend.send(BackendRequest.builder().setEvents(eventInternals).setExtras(transportContext.getExtras()).build());
            }
            if (response.getStatus() == BackendResponse.Status.TRANSIENT_ERROR) {
                long finalMaxNextRequestWaitMillis1 = maxNextRequestWaitMillis;
                this.guard.runCriticalSection(() -> {
                    this.eventStore.recordFailure(persistedEvents);
                    this.eventStore.recordNextCallTime(transportContext, this.clock.getTime() + finalMaxNextRequestWaitMillis1);
                    return null;
                });
                this.workScheduler.schedule(transportContext, attemptNumber + 1, true);
                return;
            }
            this.guard.runCriticalSection(() -> {
                this.eventStore.recordSuccess(persistedEvents);
                return null;
            });
            if (response.getStatus() == BackendResponse.Status.OK) {
                maxNextRequestWaitMillis = Math.max(maxNextRequestWaitMillis, response.getNextRequestWaitMillis());
                continue;
            }
            if (response.getStatus() != BackendResponse.Status.INVALID_PAYLOAD) continue;
            HashMap<String, Integer> countMap = new HashMap<String, Integer>();
            for (PersistedEvent persistedEvent : persistedEvents) {
                String logSource = persistedEvent.getEvent().getTransportName();
                if (!countMap.containsKey(logSource)) {
                    countMap.put(logSource, 1);
                    continue;
                }
                countMap.put(logSource, (Integer)countMap.get(logSource) + 1);
            }
            this.guard.runCriticalSection(() -> {
                for (Map.Entry entry : countMap.entrySet()) {
                    this.clientHealthMetricsStore.recordLogEventDropped(((Integer)entry.getValue()).intValue(), LogEventDropped.Reason.INVALID_PAYLOD, (String)entry.getKey());
                }
                return null;
            });
        }
        long finalMaxNextRequestWaitMillis = maxNextRequestWaitMillis;
        this.guard.runCriticalSection(() -> {
            this.eventStore.recordNextCallTime(transportContext, this.clock.getTime() + finalMaxNextRequestWaitMillis);
            return null;
        });
    }
}

