package com.google.android.datatransport.runtime.firebase.transport;

import com.google.android.datatransport.runtime.ProtoEncoderDoNotUse;
import com.google.firebase.encoders.annotations.Encodable;
import com.google.firebase.encoders.proto.Protobuf;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.String;
import java.util.ArrayList;
import java.util.List;

public final class ClientMetrics {
  private static final ClientMetrics DEFAULT_INSTANCE = new Builder().build();

  private final TimeWindow window_;

  private final List<LogSourceMetrics> log_source_metrics_;

  private final GlobalMetrics global_metrics_;

  private final String app_namespace_;

  ClientMetrics(TimeWindow window_, List<LogSourceMetrics> log_source_metrics_,
      GlobalMetrics global_metrics_, String app_namespace_) {
    this.window_ = window_;
    this.log_source_metrics_ = log_source_metrics_;
    this.global_metrics_ = global_metrics_;
    this.app_namespace_ = app_namespace_;
  }

  public byte[] toByteArray() {
    return ProtoEncoderDoNotUse.encode(this);
  }

  public void writeTo(OutputStream output) throws IOException {
    ProtoEncoderDoNotUse.encode(this, output);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  @Encodable.Ignore
  public TimeWindow getWindow() {
    return window_ == null ? TimeWindow.getDefaultInstance() : window_;
  }

  @Protobuf(
      tag = 1
  )
  @Encodable.Field(
      name = "window"
  )
  public TimeWindow getWindowInternal() {
    return window_;
  }

  @Protobuf(
      tag = 2
  )
  @Encodable.Field(
      name = "logSourceMetrics"
  )
  public List<LogSourceMetrics> getLogSourceMetricsList() {
    return log_source_metrics_;
  }

  @Encodable.Ignore
  public GlobalMetrics getGlobalMetrics() {
    return global_metrics_ == null ? GlobalMetrics.getDefaultInstance() : global_metrics_;
  }

  @Protobuf(
      tag = 3
  )
  @Encodable.Field(
      name = "globalMetrics"
  )
  public GlobalMetrics getGlobalMetricsInternal() {
    return global_metrics_;
  }

  @Protobuf(
      tag = 4
  )
  public String getAppNamespace() {
    return app_namespace_;
  }

  public static ClientMetrics getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  public static final class Builder {
    private TimeWindow window_;

    private List<LogSourceMetrics> log_source_metrics_;

    private GlobalMetrics global_metrics_;

    private String app_namespace_;

    Builder() {
      this.window_ = null;
      this.log_source_metrics_ = new ArrayList<>();
      this.global_metrics_ = null;
      this.app_namespace_ = "";
    }

    public ClientMetrics build() {
      return new ClientMetrics(window_, java.util.Collections.unmodifiableList(log_source_metrics_), global_metrics_, app_namespace_);
    }

    public Builder setWindow(TimeWindow window_) {
      this.window_ = window_;
      return this;
    }

    public Builder addLogSourceMetrics(LogSourceMetrics log_source_metrics_) {
      this.log_source_metrics_.add(log_source_metrics_);
      return this;
    }

    public Builder setLogSourceMetricsList(List<LogSourceMetrics> log_source_metrics_) {
      this.log_source_metrics_ = log_source_metrics_;
      return this;
    }

    public Builder setGlobalMetrics(GlobalMetrics global_metrics_) {
      this.global_metrics_ = global_metrics_;
      return this;
    }

    public Builder setAppNamespace(String app_namespace_) {
      this.app_namespace_ = app_namespace_;
      return this;
    }
  }
}
