package com.google.android.datatransport.runtime.firebase.transport;

import com.google.firebase.encoders.annotations.Encodable;
import com.google.firebase.encoders.proto.Protobuf;
import java.lang.String;
import java.util.ArrayList;
import java.util.List;

public final class LogSourceMetrics {
  private static final LogSourceMetrics DEFAULT_INSTANCE = new Builder().build();

  private final String log_source_;

  private final List<LogEventDropped> log_event_dropped_;

  LogSourceMetrics(String log_source_, List<LogEventDropped> log_event_dropped_) {
    this.log_source_ = log_source_;
    this.log_event_dropped_ = log_event_dropped_;
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  @Protobuf(
      tag = 1
  )
  public String getLogSource() {
    return log_source_;
  }

  @Protobuf(
      tag = 2
  )
  @Encodable.Field(
      name = "logEventDropped"
  )
  public List<LogEventDropped> getLogEventDroppedList() {
    return log_event_dropped_;
  }

  public static LogSourceMetrics getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  public static final class Builder {
    private String log_source_;

    private List<LogEventDropped> log_event_dropped_;

    Builder() {
      this.log_source_ = "";
      this.log_event_dropped_ = new ArrayList<>();
    }

    public LogSourceMetrics build() {
      return new LogSourceMetrics(log_source_, java.util.Collections.unmodifiableList(log_event_dropped_));
    }

    public Builder setLogSource(String log_source_) {
      this.log_source_ = log_source_;
      return this;
    }

    public Builder addLogEventDropped(LogEventDropped log_event_dropped_) {
      this.log_event_dropped_.add(log_event_dropped_);
      return this;
    }

    public Builder setLogEventDroppedList(List<LogEventDropped> log_event_dropped_) {
      this.log_event_dropped_ = log_event_dropped_;
      return this;
    }
  }
}
