/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.datatransport.runtime;

import com.google.android.datatransport.Encoding;
import com.google.android.datatransport.Transformer;
import com.google.android.datatransport.Transport;
import com.google.android.datatransport.TransportFactory;
import com.google.android.datatransport.runtime.TransportContext;
import com.google.android.datatransport.runtime.TransportImpl;
import com.google.android.datatransport.runtime.TransportInternal;
import java.util.Set;

final class TransportFactoryImpl
implements TransportFactory {
    private final Set<Encoding> supportedPayloadEncodings;
    private final TransportContext transportContext;
    private final TransportInternal transportInternal;

    TransportFactoryImpl(Set<Encoding> supportedPayloadEncodings, TransportContext transportContext, TransportInternal transportInternal) {
        this.supportedPayloadEncodings = supportedPayloadEncodings;
        this.transportContext = transportContext;
        this.transportInternal = transportInternal;
    }

    public <T> Transport<T> getTransport(String name, Class<T> payloadType, Transformer<T, byte[]> payloadTransformer) {
        return this.getTransport(name, payloadType, Encoding.of((String)"proto"), payloadTransformer);
    }

    public <T> Transport<T> getTransport(String name, Class<T> payloadType, Encoding payloadEncoding, Transformer<T, byte[]> payloadTransformer) {
        if (!this.supportedPayloadEncodings.contains(payloadEncoding)) {
            throw new IllegalArgumentException(String.format("%s is not supported byt this factory. Supported encodings are: %s.", payloadEncoding, this.supportedPayloadEncodings));
        }
        return new TransportImpl<T>(this.transportContext, name, payloadEncoding, payloadTransformer, this.transportInternal);
    }
}

