/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2;

import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Bundleable;
import com.google.android.exoplayer2.Rating;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.util.Util;
import com.google.common.base.Objects;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.List;

public final class MediaMetadata
implements Bundleable {
    public static final int FOLDER_TYPE_MIXED = 0;
    public static final int FOLDER_TYPE_TITLES = 1;
    public static final int FOLDER_TYPE_ALBUMS = 2;
    public static final int FOLDER_TYPE_ARTISTS = 3;
    public static final int FOLDER_TYPE_GENRES = 4;
    public static final int FOLDER_TYPE_PLAYLISTS = 5;
    public static final int FOLDER_TYPE_YEARS = 6;
    public static final MediaMetadata EMPTY = new Builder().build();
    @Nullable
    public final CharSequence title;
    @Nullable
    public final CharSequence artist;
    @Nullable
    public final CharSequence albumTitle;
    @Nullable
    public final CharSequence albumArtist;
    @Nullable
    public final CharSequence displayTitle;
    @Nullable
    public final CharSequence subtitle;
    @Nullable
    public final CharSequence description;
    @Nullable
    public final Uri mediaUri;
    @Nullable
    public final Rating userRating;
    @Nullable
    public final Rating overallRating;
    @Nullable
    public final byte[] artworkData;
    @Nullable
    public final Uri artworkUri;
    @Nullable
    public final Integer trackNumber;
    @Nullable
    public final Integer totalTrackCount;
    @Nullable
    public final Integer folderType;
    @Nullable
    public final Boolean isPlayable;
    @Nullable
    public final Integer year;
    @Nullable
    public final Bundle extras;
    private static final int FIELD_TITLE = 0;
    private static final int FIELD_ARTIST = 1;
    private static final int FIELD_ALBUM_TITLE = 2;
    private static final int FIELD_ALBUM_ARTIST = 3;
    private static final int FIELD_DISPLAY_TITLE = 4;
    private static final int FIELD_SUBTITLE = 5;
    private static final int FIELD_DESCRIPTION = 6;
    private static final int FIELD_MEDIA_URI = 7;
    private static final int FIELD_USER_RATING = 8;
    private static final int FIELD_OVERALL_RATING = 9;
    private static final int FIELD_ARTWORK_DATA = 10;
    private static final int FIELD_ARTWORK_URI = 11;
    private static final int FIELD_TRACK_NUMBER = 12;
    private static final int FIELD_TOTAL_TRACK_COUNT = 13;
    private static final int FIELD_FOLDER_TYPE = 14;
    private static final int FIELD_IS_PLAYABLE = 15;
    private static final int FIELD_YEAR = 16;
    private static final int FIELD_EXTRAS = 1000;
    public static final Bundleable.Creator<MediaMetadata> CREATOR = MediaMetadata::fromBundle;

    private MediaMetadata(Builder builder) {
        this.title = builder.title;
        this.artist = builder.artist;
        this.albumTitle = builder.albumTitle;
        this.albumArtist = builder.albumArtist;
        this.displayTitle = builder.displayTitle;
        this.subtitle = builder.subtitle;
        this.description = builder.description;
        this.mediaUri = builder.mediaUri;
        this.userRating = builder.userRating;
        this.overallRating = builder.overallRating;
        this.artworkData = builder.artworkData;
        this.artworkUri = builder.artworkUri;
        this.trackNumber = builder.trackNumber;
        this.totalTrackCount = builder.totalTrackCount;
        this.folderType = builder.folderType;
        this.isPlayable = builder.isPlayable;
        this.year = builder.year;
        this.extras = builder.extras;
    }

    public Builder buildUpon() {
        return new Builder(this);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MediaMetadata that = (MediaMetadata)obj;
        return Util.areEqual(this.title, that.title) && Util.areEqual(this.artist, that.artist) && Util.areEqual(this.albumTitle, that.albumTitle) && Util.areEqual(this.albumArtist, that.albumArtist) && Util.areEqual(this.displayTitle, that.displayTitle) && Util.areEqual(this.subtitle, that.subtitle) && Util.areEqual(this.description, that.description) && Util.areEqual(this.mediaUri, that.mediaUri) && Util.areEqual(this.userRating, that.userRating) && Util.areEqual(this.overallRating, that.overallRating) && Arrays.equals(this.artworkData, that.artworkData) && Util.areEqual(this.artworkUri, that.artworkUri) && Util.areEqual(this.trackNumber, that.trackNumber) && Util.areEqual(this.totalTrackCount, that.totalTrackCount) && Util.areEqual(this.folderType, that.folderType) && Util.areEqual(this.isPlayable, that.isPlayable) && Util.areEqual(this.year, that.year);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.title, this.artist, this.albumTitle, this.albumArtist, this.displayTitle, this.subtitle, this.description, this.mediaUri, this.userRating, this.overallRating, Arrays.hashCode(this.artworkData), this.artworkUri, this.trackNumber, this.totalTrackCount, this.folderType, this.isPlayable, this.year});
    }

    @Override
    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        bundle.putCharSequence(MediaMetadata.keyForField(0), this.title);
        bundle.putCharSequence(MediaMetadata.keyForField(1), this.artist);
        bundle.putCharSequence(MediaMetadata.keyForField(2), this.albumTitle);
        bundle.putCharSequence(MediaMetadata.keyForField(3), this.albumArtist);
        bundle.putCharSequence(MediaMetadata.keyForField(4), this.displayTitle);
        bundle.putCharSequence(MediaMetadata.keyForField(5), this.subtitle);
        bundle.putCharSequence(MediaMetadata.keyForField(6), this.description);
        bundle.putParcelable(MediaMetadata.keyForField(7), (Parcelable)this.mediaUri);
        bundle.putByteArray(MediaMetadata.keyForField(10), this.artworkData);
        bundle.putParcelable(MediaMetadata.keyForField(11), (Parcelable)this.artworkUri);
        if (this.userRating != null) {
            bundle.putBundle(MediaMetadata.keyForField(8), this.userRating.toBundle());
        }
        if (this.overallRating != null) {
            bundle.putBundle(MediaMetadata.keyForField(9), this.overallRating.toBundle());
        }
        if (this.trackNumber != null) {
            bundle.putInt(MediaMetadata.keyForField(12), this.trackNumber.intValue());
        }
        if (this.totalTrackCount != null) {
            bundle.putInt(MediaMetadata.keyForField(13), this.totalTrackCount.intValue());
        }
        if (this.folderType != null) {
            bundle.putInt(MediaMetadata.keyForField(14), this.folderType.intValue());
        }
        if (this.isPlayable != null) {
            bundle.putBoolean(MediaMetadata.keyForField(15), this.isPlayable.booleanValue());
        }
        if (this.year != null) {
            bundle.putInt(MediaMetadata.keyForField(16), this.year.intValue());
        }
        if (this.extras != null) {
            bundle.putBundle(MediaMetadata.keyForField(1000), this.extras);
        }
        return bundle;
    }

    private static MediaMetadata fromBundle(Bundle bundle) {
        Bundle fieldBundle;
        Builder builder = new Builder();
        builder.setTitle(bundle.getCharSequence(MediaMetadata.keyForField(0))).setArtist(bundle.getCharSequence(MediaMetadata.keyForField(1))).setAlbumTitle(bundle.getCharSequence(MediaMetadata.keyForField(2))).setAlbumArtist(bundle.getCharSequence(MediaMetadata.keyForField(3))).setDisplayTitle(bundle.getCharSequence(MediaMetadata.keyForField(4))).setSubtitle(bundle.getCharSequence(MediaMetadata.keyForField(5))).setDescription(bundle.getCharSequence(MediaMetadata.keyForField(6))).setMediaUri((Uri)bundle.getParcelable(MediaMetadata.keyForField(7))).setArtworkData(bundle.getByteArray(MediaMetadata.keyForField(10))).setArtworkUri((Uri)bundle.getParcelable(MediaMetadata.keyForField(11))).setExtras(bundle.getBundle(MediaMetadata.keyForField(1000)));
        if (bundle.containsKey(MediaMetadata.keyForField(8)) && (fieldBundle = bundle.getBundle(MediaMetadata.keyForField(8))) != null) {
            builder.setUserRating(Rating.CREATOR.fromBundle(fieldBundle));
        }
        if (bundle.containsKey(MediaMetadata.keyForField(9)) && (fieldBundle = bundle.getBundle(MediaMetadata.keyForField(9))) != null) {
            builder.setOverallRating(Rating.CREATOR.fromBundle(fieldBundle));
        }
        if (bundle.containsKey(MediaMetadata.keyForField(12))) {
            builder.setTrackNumber(bundle.getInt(MediaMetadata.keyForField(12)));
        }
        if (bundle.containsKey(MediaMetadata.keyForField(13))) {
            builder.setTotalTrackCount(bundle.getInt(MediaMetadata.keyForField(13)));
        }
        if (bundle.containsKey(MediaMetadata.keyForField(14))) {
            builder.setFolderType(bundle.getInt(MediaMetadata.keyForField(14)));
        }
        if (bundle.containsKey(MediaMetadata.keyForField(15))) {
            builder.setIsPlayable(bundle.getBoolean(MediaMetadata.keyForField(15)));
        }
        if (bundle.containsKey(MediaMetadata.keyForField(16))) {
            builder.setYear(bundle.getInt(MediaMetadata.keyForField(16)));
        }
        return builder.build();
    }

    private static String keyForField(int field) {
        return Integer.toString(field, 36);
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FolderType {
    }

    public static final class Builder {
        @Nullable
        private CharSequence title;
        @Nullable
        private CharSequence artist;
        @Nullable
        private CharSequence albumTitle;
        @Nullable
        private CharSequence albumArtist;
        @Nullable
        private CharSequence displayTitle;
        @Nullable
        private CharSequence subtitle;
        @Nullable
        private CharSequence description;
        @Nullable
        private Uri mediaUri;
        @Nullable
        private Rating userRating;
        @Nullable
        private Rating overallRating;
        @Nullable
        private byte[] artworkData;
        @Nullable
        private Uri artworkUri;
        @Nullable
        private Integer trackNumber;
        @Nullable
        private Integer totalTrackCount;
        @Nullable
        private Integer folderType;
        @Nullable
        private Boolean isPlayable;
        @Nullable
        private Integer year;
        @Nullable
        private Bundle extras;

        public Builder() {
        }

        private Builder(MediaMetadata mediaMetadata) {
            this.title = mediaMetadata.title;
            this.artist = mediaMetadata.artist;
            this.albumTitle = mediaMetadata.albumTitle;
            this.albumArtist = mediaMetadata.albumArtist;
            this.displayTitle = mediaMetadata.displayTitle;
            this.subtitle = mediaMetadata.subtitle;
            this.description = mediaMetadata.description;
            this.mediaUri = mediaMetadata.mediaUri;
            this.userRating = mediaMetadata.userRating;
            this.overallRating = mediaMetadata.overallRating;
            this.artworkData = mediaMetadata.artworkData;
            this.artworkUri = mediaMetadata.artworkUri;
            this.trackNumber = mediaMetadata.trackNumber;
            this.totalTrackCount = mediaMetadata.totalTrackCount;
            this.folderType = mediaMetadata.folderType;
            this.isPlayable = mediaMetadata.isPlayable;
            this.year = mediaMetadata.year;
            this.extras = mediaMetadata.extras;
        }

        public Builder setTitle(@Nullable CharSequence title) {
            this.title = title;
            return this;
        }

        public Builder setArtist(@Nullable CharSequence artist) {
            this.artist = artist;
            return this;
        }

        public Builder setAlbumTitle(@Nullable CharSequence albumTitle) {
            this.albumTitle = albumTitle;
            return this;
        }

        public Builder setAlbumArtist(@Nullable CharSequence albumArtist) {
            this.albumArtist = albumArtist;
            return this;
        }

        public Builder setDisplayTitle(@Nullable CharSequence displayTitle) {
            this.displayTitle = displayTitle;
            return this;
        }

        public Builder setSubtitle(@Nullable CharSequence subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        public Builder setDescription(@Nullable CharSequence description) {
            this.description = description;
            return this;
        }

        public Builder setMediaUri(@Nullable Uri mediaUri) {
            this.mediaUri = mediaUri;
            return this;
        }

        public Builder setUserRating(@Nullable Rating userRating) {
            this.userRating = userRating;
            return this;
        }

        public Builder setOverallRating(@Nullable Rating overallRating) {
            this.overallRating = overallRating;
            return this;
        }

        public Builder setArtworkData(@Nullable byte[] artworkData) {
            this.artworkData = artworkData == null ? null : (byte[])artworkData.clone();
            return this;
        }

        public Builder setArtworkUri(@Nullable Uri artworkUri) {
            this.artworkUri = artworkUri;
            return this;
        }

        public Builder setTrackNumber(@Nullable Integer trackNumber) {
            this.trackNumber = trackNumber;
            return this;
        }

        public Builder setTotalTrackCount(@Nullable Integer totalTrackCount) {
            this.totalTrackCount = totalTrackCount;
            return this;
        }

        public Builder setFolderType(@Nullable Integer folderType) {
            this.folderType = folderType;
            return this;
        }

        public Builder setIsPlayable(@Nullable Boolean isPlayable) {
            this.isPlayable = isPlayable;
            return this;
        }

        public Builder setYear(@Nullable Integer year) {
            this.year = year;
            return this;
        }

        public Builder setExtras(@Nullable Bundle extras) {
            this.extras = extras;
            return this;
        }

        public Builder populateFromMetadata(Metadata metadata) {
            for (int i = 0; i < metadata.length(); ++i) {
                Metadata.Entry entry = metadata.get(i);
                entry.populateMediaMetadata(this);
            }
            return this;
        }

        public Builder populateFromMetadata(List<Metadata> metadataList) {
            for (int i = 0; i < metadataList.size(); ++i) {
                Metadata metadata = metadataList.get(i);
                for (int j = 0; j < metadata.length(); ++j) {
                    Metadata.Entry entry = metadata.get(j);
                    entry.populateMediaMetadata(this);
                }
            }
            return this;
        }

        public MediaMetadata build() {
            return new MediaMetadata(this);
        }
    }
}

