/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2;

import android.os.Bundle;
import android.os.Looper;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.TextureView;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Bundleable;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.MediaMetadata;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.audio.AudioAttributes;
import com.google.android.exoplayer2.audio.AudioListener;
import com.google.android.exoplayer2.device.DeviceInfo;
import com.google.android.exoplayer2.device.DeviceListener;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.metadata.MetadataOutput;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.text.Cue;
import com.google.android.exoplayer2.text.TextOutput;
import com.google.android.exoplayer2.trackselection.TrackSelectionArray;
import com.google.android.exoplayer2.util.ExoFlags;
import com.google.android.exoplayer2.video.VideoListener;
import com.google.android.exoplayer2.video.VideoSize;
import com.google.common.base.Objects;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;

public interface Player {
    public static final int STATE_IDLE = 1;
    public static final int STATE_BUFFERING = 2;
    public static final int STATE_READY = 3;
    public static final int STATE_ENDED = 4;
    public static final int PLAY_WHEN_READY_CHANGE_REASON_USER_REQUEST = 1;
    public static final int PLAY_WHEN_READY_CHANGE_REASON_AUDIO_FOCUS_LOSS = 2;
    public static final int PLAY_WHEN_READY_CHANGE_REASON_AUDIO_BECOMING_NOISY = 3;
    public static final int PLAY_WHEN_READY_CHANGE_REASON_REMOTE = 4;
    public static final int PLAY_WHEN_READY_CHANGE_REASON_END_OF_MEDIA_ITEM = 5;
    public static final int PLAYBACK_SUPPRESSION_REASON_NONE = 0;
    public static final int PLAYBACK_SUPPRESSION_REASON_TRANSIENT_AUDIO_FOCUS_LOSS = 1;
    public static final int REPEAT_MODE_OFF = 0;
    public static final int REPEAT_MODE_ONE = 1;
    public static final int REPEAT_MODE_ALL = 2;
    public static final int DISCONTINUITY_REASON_AUTO_TRANSITION = 0;
    public static final int DISCONTINUITY_REASON_SEEK = 1;
    public static final int DISCONTINUITY_REASON_SEEK_ADJUSTMENT = 2;
    public static final int DISCONTINUITY_REASON_SKIP = 3;
    public static final int DISCONTINUITY_REASON_REMOVE = 4;
    public static final int DISCONTINUITY_REASON_INTERNAL = 5;
    public static final int TIMELINE_CHANGE_REASON_PLAYLIST_CHANGED = 0;
    public static final int TIMELINE_CHANGE_REASON_SOURCE_UPDATE = 1;
    public static final int MEDIA_ITEM_TRANSITION_REASON_REPEAT = 0;
    public static final int MEDIA_ITEM_TRANSITION_REASON_AUTO = 1;
    public static final int MEDIA_ITEM_TRANSITION_REASON_SEEK = 2;
    public static final int MEDIA_ITEM_TRANSITION_REASON_PLAYLIST_CHANGED = 3;
    public static final int EVENT_TIMELINE_CHANGED = 0;
    public static final int EVENT_MEDIA_ITEM_TRANSITION = 1;
    public static final int EVENT_TRACKS_CHANGED = 2;
    public static final int EVENT_STATIC_METADATA_CHANGED = 3;
    public static final int EVENT_IS_LOADING_CHANGED = 4;
    public static final int EVENT_PLAYBACK_STATE_CHANGED = 5;
    public static final int EVENT_PLAY_WHEN_READY_CHANGED = 6;
    public static final int EVENT_PLAYBACK_SUPPRESSION_REASON_CHANGED = 7;
    public static final int EVENT_IS_PLAYING_CHANGED = 8;
    public static final int EVENT_REPEAT_MODE_CHANGED = 9;
    public static final int EVENT_SHUFFLE_MODE_ENABLED_CHANGED = 10;
    public static final int EVENT_PLAYER_ERROR = 11;
    public static final int EVENT_POSITION_DISCONTINUITY = 12;
    public static final int EVENT_PLAYBACK_PARAMETERS_CHANGED = 13;
    public static final int EVENT_AVAILABLE_COMMANDS_CHANGED = 14;
    public static final int EVENT_MEDIA_METADATA_CHANGED = 15;
    public static final int COMMAND_PLAY_PAUSE = 1;
    public static final int COMMAND_PREPARE_STOP = 2;
    public static final int COMMAND_SEEK_TO_DEFAULT_POSITION = 3;
    public static final int COMMAND_SEEK_IN_CURRENT_MEDIA_ITEM = 4;
    public static final int COMMAND_SEEK_TO_NEXT_MEDIA_ITEM = 5;
    public static final int COMMAND_SEEK_TO_PREVIOUS_MEDIA_ITEM = 6;
    public static final int COMMAND_SEEK_TO_MEDIA_ITEM = 7;
    public static final int COMMAND_SET_SPEED_AND_PITCH = 8;
    public static final int COMMAND_SET_SHUFFLE_MODE = 9;
    public static final int COMMAND_SET_REPEAT_MODE = 10;
    public static final int COMMAND_GET_CURRENT_MEDIA_ITEM = 11;
    public static final int COMMAND_GET_MEDIA_ITEMS = 12;
    public static final int COMMAND_GET_MEDIA_ITEMS_METADATA = 13;
    public static final int COMMAND_CHANGE_MEDIA_ITEMS = 14;
    public static final int COMMAND_GET_AUDIO_ATTRIBUTES = 15;
    public static final int COMMAND_GET_VOLUME = 16;
    public static final int COMMAND_GET_DEVICE_VOLUME = 17;
    public static final int COMMAND_SET_VOLUME = 18;
    public static final int COMMAND_SET_DEVICE_VOLUME = 19;
    public static final int COMMAND_ADJUST_DEVICE_VOLUME = 20;
    public static final int COMMAND_SET_VIDEO_SURFACE = 21;
    public static final int COMMAND_GET_TEXT = 22;

    public Looper getApplicationLooper();

    @Deprecated
    public void addListener(EventListener var1);

    public void addListener(Listener var1);

    @Deprecated
    public void removeListener(EventListener var1);

    public void removeListener(Listener var1);

    public void setMediaItems(List<MediaItem> var1);

    public void setMediaItems(List<MediaItem> var1, boolean var2);

    public void setMediaItems(List<MediaItem> var1, int var2, long var3);

    public void setMediaItem(MediaItem var1);

    public void setMediaItem(MediaItem var1, long var2);

    public void setMediaItem(MediaItem var1, boolean var2);

    public void addMediaItem(MediaItem var1);

    public void addMediaItem(int var1, MediaItem var2);

    public void addMediaItems(List<MediaItem> var1);

    public void addMediaItems(int var1, List<MediaItem> var2);

    public void moveMediaItem(int var1, int var2);

    public void moveMediaItems(int var1, int var2, int var3);

    public void removeMediaItem(int var1);

    public void removeMediaItems(int var1, int var2);

    public void clearMediaItems();

    public boolean isCommandAvailable(int var1);

    public Commands getAvailableCommands();

    public void prepare();

    public int getPlaybackState();

    public int getPlaybackSuppressionReason();

    public boolean isPlaying();

    @Nullable
    public ExoPlaybackException getPlayerError();

    @Deprecated
    @Nullable
    public ExoPlaybackException getPlaybackError();

    public void play();

    public void pause();

    public void setPlayWhenReady(boolean var1);

    public boolean getPlayWhenReady();

    public void setRepeatMode(int var1);

    public int getRepeatMode();

    public void setShuffleModeEnabled(boolean var1);

    public boolean getShuffleModeEnabled();

    public boolean isLoading();

    public void seekToDefaultPosition();

    public void seekToDefaultPosition(int var1);

    public void seekTo(long var1);

    public void seekTo(int var1, long var2);

    public boolean hasPrevious();

    public void previous();

    public boolean hasNext();

    public void next();

    public void setPlaybackParameters(PlaybackParameters var1);

    public void setPlaybackSpeed(float var1);

    public PlaybackParameters getPlaybackParameters();

    public void stop();

    @Deprecated
    public void stop(boolean var1);

    public void release();

    public TrackGroupArray getCurrentTrackGroups();

    public TrackSelectionArray getCurrentTrackSelections();

    public List<Metadata> getCurrentStaticMetadata();

    public MediaMetadata getMediaMetadata();

    @Nullable
    public Object getCurrentManifest();

    public Timeline getCurrentTimeline();

    public int getCurrentPeriodIndex();

    public int getCurrentWindowIndex();

    public int getNextWindowIndex();

    public int getPreviousWindowIndex();

    @Deprecated
    @Nullable
    public Object getCurrentTag();

    @Nullable
    public MediaItem getCurrentMediaItem();

    public int getMediaItemCount();

    public MediaItem getMediaItemAt(int var1);

    public long getDuration();

    public long getCurrentPosition();

    public long getBufferedPosition();

    public int getBufferedPercentage();

    public long getTotalBufferedDuration();

    public boolean isCurrentWindowDynamic();

    public boolean isCurrentWindowLive();

    public long getCurrentLiveOffset();

    public boolean isCurrentWindowSeekable();

    public boolean isPlayingAd();

    public int getCurrentAdGroupIndex();

    public int getCurrentAdIndexInAdGroup();

    public long getContentDuration();

    public long getContentPosition();

    public long getContentBufferedPosition();

    public AudioAttributes getAudioAttributes();

    public void setVolume(float var1);

    public float getVolume();

    public void clearVideoSurface();

    public void clearVideoSurface(@Nullable Surface var1);

    public void setVideoSurface(@Nullable Surface var1);

    public void setVideoSurfaceHolder(@Nullable SurfaceHolder var1);

    public void clearVideoSurfaceHolder(@Nullable SurfaceHolder var1);

    public void setVideoSurfaceView(@Nullable SurfaceView var1);

    public void clearVideoSurfaceView(@Nullable SurfaceView var1);

    public void setVideoTextureView(@Nullable TextureView var1);

    public void clearVideoTextureView(@Nullable TextureView var1);

    public VideoSize getVideoSize();

    public List<Cue> getCurrentCues();

    public DeviceInfo getDeviceInfo();

    public int getDeviceVolume();

    public boolean isDeviceMuted();

    public void setDeviceVolume(int var1);

    public void increaseDeviceVolume();

    public void decreaseDeviceVolume();

    public void setDeviceMuted(boolean var1);

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Command {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EventFlags {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MediaItemTransitionReason {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TimelineChangeReason {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DiscontinuityReason {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RepeatMode {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PlaybackSuppressionReason {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PlayWhenReadyChangeReason {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface State {
    }

    public static interface Listener
    extends VideoListener,
    AudioListener,
    TextOutput,
    MetadataOutput,
    DeviceListener,
    EventListener {
        @Override
        default public void onCues(List<Cue> cues) {
        }

        @Override
        default public void onMetadata(Metadata metadata) {
        }
    }

    public static final class Commands {
        public static final Commands EMPTY = new Builder().build();
        private final ExoFlags flags;

        private Commands(ExoFlags flags) {
            this.flags = flags;
        }

        public boolean contains(int command) {
            return this.flags.contains(command);
        }

        public int size() {
            return this.flags.size();
        }

        public int get(int index) {
            return this.flags.get(index);
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Commands)) {
                return false;
            }
            Commands commands = (Commands)obj;
            return this.flags.equals(commands.flags);
        }

        public int hashCode() {
            return this.flags.hashCode();
        }

        public static final class Builder {
            private final ExoFlags.Builder flagsBuilder = new ExoFlags.Builder();

            public Builder add(int command) {
                this.flagsBuilder.add(command);
                return this;
            }

            public Builder addIf(int command, boolean condition) {
                this.flagsBuilder.addIf(command, condition);
                return this;
            }

            public Builder addAll(int ... commands) {
                this.flagsBuilder.addAll(commands);
                return this;
            }

            public Builder addAll(Commands commands) {
                this.flagsBuilder.addAll(commands.flags);
                return this;
            }

            public Commands build() {
                return new Commands(this.flagsBuilder.build());
            }
        }
    }

    public static final class PositionInfo
    implements Bundleable {
        @Nullable
        public final Object windowUid;
        public final int windowIndex;
        @Nullable
        public final Object periodUid;
        public final int periodIndex;
        public final long positionMs;
        public final long contentPositionMs;
        public final int adGroupIndex;
        public final int adIndexInAdGroup;
        private static final int FIELD_WINDOW_INDEX = 0;
        private static final int FIELD_PERIOD_INDEX = 1;
        private static final int FIELD_POSITION_MS = 2;
        private static final int FIELD_CONTENT_POSITION_MS = 3;
        private static final int FIELD_AD_GROUP_INDEX = 4;
        private static final int FIELD_AD_INDEX_IN_AD_GROUP = 5;
        public static final Bundleable.Creator<PositionInfo> CREATOR = PositionInfo::fromBundle;

        public PositionInfo(@Nullable Object windowUid, int windowIndex, @Nullable Object periodUid, int periodIndex, long positionMs, long contentPositionMs, int adGroupIndex, int adIndexInAdGroup) {
            this.windowUid = windowUid;
            this.windowIndex = windowIndex;
            this.periodUid = periodUid;
            this.periodIndex = periodIndex;
            this.positionMs = positionMs;
            this.contentPositionMs = contentPositionMs;
            this.adGroupIndex = adGroupIndex;
            this.adIndexInAdGroup = adIndexInAdGroup;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PositionInfo that = (PositionInfo)o;
            return this.windowIndex == that.windowIndex && this.periodIndex == that.periodIndex && this.positionMs == that.positionMs && this.contentPositionMs == that.contentPositionMs && this.adGroupIndex == that.adGroupIndex && this.adIndexInAdGroup == that.adIndexInAdGroup && Objects.equal((Object)this.windowUid, (Object)that.windowUid) && Objects.equal((Object)this.periodUid, (Object)that.periodUid);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.windowUid, this.windowIndex, this.periodUid, this.periodIndex, this.windowIndex, this.positionMs, this.contentPositionMs, this.adGroupIndex, this.adIndexInAdGroup});
        }

        @Override
        public Bundle toBundle() {
            Bundle bundle = new Bundle();
            bundle.putInt(PositionInfo.keyForField(0), this.windowIndex);
            bundle.putInt(PositionInfo.keyForField(1), this.periodIndex);
            bundle.putLong(PositionInfo.keyForField(2), this.positionMs);
            bundle.putLong(PositionInfo.keyForField(3), this.contentPositionMs);
            bundle.putInt(PositionInfo.keyForField(4), this.adGroupIndex);
            bundle.putInt(PositionInfo.keyForField(5), this.adIndexInAdGroup);
            return bundle;
        }

        private static PositionInfo fromBundle(Bundle bundle) {
            int windowIndex = bundle.getInt(PositionInfo.keyForField(0), -1);
            int periodIndex = bundle.getInt(PositionInfo.keyForField(1), -1);
            long positionMs = bundle.getLong(PositionInfo.keyForField(2), -9223372036854775807L);
            long contentPositionMs = bundle.getLong(PositionInfo.keyForField(3), -9223372036854775807L);
            int adGroupIndex = bundle.getInt(PositionInfo.keyForField(4), -1);
            int adIndexInAdGroup = bundle.getInt(PositionInfo.keyForField(5), -1);
            return new PositionInfo(null, windowIndex, null, periodIndex, positionMs, contentPositionMs, adGroupIndex, adIndexInAdGroup);
        }

        private static String keyForField(int field) {
            return Integer.toString(field, 36);
        }
    }

    public static final class Events {
        private final ExoFlags flags;

        public Events(ExoFlags flags) {
            this.flags = flags;
        }

        public boolean contains(int event) {
            return this.flags.contains(event);
        }

        public boolean containsAny(int ... events) {
            return this.flags.containsAny(events);
        }

        public int size() {
            return this.flags.size();
        }

        public int get(int index) {
            return this.flags.get(index);
        }
    }

    @Deprecated
    public static interface EventListener {
        default public void onTimelineChanged(Timeline timeline, int reason) {
        }

        @Deprecated
        default public void onTimelineChanged(Timeline timeline, @Nullable Object manifest, int reason) {
        }

        default public void onMediaItemTransition(@Nullable MediaItem mediaItem, int reason) {
        }

        default public void onTracksChanged(TrackGroupArray trackGroups, TrackSelectionArray trackSelections) {
        }

        default public void onStaticMetadataChanged(List<Metadata> metadataList) {
        }

        default public void onMediaMetadataChanged(MediaMetadata mediaMetadata) {
        }

        default public void onIsLoadingChanged(boolean isLoading) {
        }

        @Deprecated
        default public void onLoadingChanged(boolean isLoading) {
        }

        default public void onAvailableCommandsChanged(Commands availableCommands) {
        }

        @Deprecated
        default public void onPlayerStateChanged(boolean playWhenReady, int playbackState) {
        }

        default public void onPlaybackStateChanged(int state) {
        }

        default public void onPlayWhenReadyChanged(boolean playWhenReady, int reason) {
        }

        default public void onPlaybackSuppressionReasonChanged(int playbackSuppressionReason) {
        }

        default public void onIsPlayingChanged(boolean isPlaying) {
        }

        default public void onRepeatModeChanged(int repeatMode) {
        }

        default public void onShuffleModeEnabledChanged(boolean shuffleModeEnabled) {
        }

        default public void onPlayerError(ExoPlaybackException error) {
        }

        @Deprecated
        default public void onPositionDiscontinuity(int reason) {
        }

        default public void onPositionDiscontinuity(PositionInfo oldPosition, PositionInfo newPosition, int reason) {
        }

        default public void onPlaybackParametersChanged(PlaybackParameters playbackParameters) {
        }

        @Deprecated
        default public void onSeekProcessed() {
        }

        default public void onEvents(Player player, Events events) {
        }
    }
}

