/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source;

import android.os.Bundle;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Bundleable;
import com.google.android.exoplayer2.source.TrackGroup;
import com.google.android.exoplayer2.util.BundleableUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;

public final class TrackGroupArray
implements Bundleable {
    public static final TrackGroupArray EMPTY = new TrackGroupArray(new TrackGroup[0]);
    public final int length;
    private final TrackGroup[] trackGroups;
    private int hashCode;
    private static final int FIELD_TRACK_GROUPS = 0;
    public static final Bundleable.Creator<TrackGroupArray> CREATOR = bundle -> {
        List<TrackGroup> trackGroups = BundleableUtil.fromBundleNullableList(TrackGroup.CREATOR, bundle.getParcelableArrayList(TrackGroupArray.keyForField(0)), ImmutableList.of());
        return new TrackGroupArray(trackGroups.toArray(new TrackGroup[0]));
    };

    public TrackGroupArray(TrackGroup ... trackGroups) {
        this.trackGroups = trackGroups;
        this.length = trackGroups.length;
    }

    public TrackGroup get(int index) {
        return this.trackGroups[index];
    }

    public int indexOf(TrackGroup group) {
        for (int i = 0; i < this.length; ++i) {
            if (this.trackGroups[i] != group) continue;
            return i;
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.length == 0;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Arrays.hashCode(this.trackGroups);
        }
        return this.hashCode;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TrackGroupArray other = (TrackGroupArray)obj;
        return this.length == other.length && Arrays.equals(this.trackGroups, other.trackGroups);
    }

    @Override
    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        bundle.putParcelableArrayList(TrackGroupArray.keyForField(0), BundleableUtil.toBundleArrayList(Lists.newArrayList((Object[])this.trackGroups)));
        return bundle;
    }

    private static String keyForField(int field) {
        return Integer.toString(field, 36);
    }
}

