/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.util;

import android.graphics.SurfaceTexture;
import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLSurface;
import android.opengl.GLES20;
import android.os.Handler;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.GlUtil;
import com.google.android.exoplayer2.util.Util;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@RequiresApi(value=17)
public final class EGLSurfaceTexture
implements SurfaceTexture.OnFrameAvailableListener,
Runnable {
    public static final int SECURE_MODE_NONE = 0;
    public static final int SECURE_MODE_SURFACELESS_CONTEXT = 1;
    public static final int SECURE_MODE_PROTECTED_PBUFFER = 2;
    private static final int EGL_SURFACE_WIDTH = 1;
    private static final int EGL_SURFACE_HEIGHT = 1;
    private static final int[] EGL_CONFIG_ATTRIBUTES = new int[]{12352, 4, 12324, 8, 12323, 8, 12322, 8, 12321, 8, 12325, 0, 12327, 12344, 12339, 4, 12344};
    private static final int EGL_PROTECTED_CONTENT_EXT = 12992;
    private final Handler handler;
    private final int[] textureIdHolder;
    @Nullable
    private final TextureImageListener callback;
    @Nullable
    private EGLDisplay display;
    @Nullable
    private EGLContext context;
    @Nullable
    private EGLSurface surface;
    @Nullable
    private SurfaceTexture texture;

    public EGLSurfaceTexture(Handler handler) {
        this(handler, null);
    }

    public EGLSurfaceTexture(Handler handler, @Nullable TextureImageListener callback) {
        this.handler = handler;
        this.callback = callback;
        this.textureIdHolder = new int[1];
    }

    public void init(int secureMode) {
        this.display = EGLSurfaceTexture.getDefaultDisplay();
        EGLConfig config = EGLSurfaceTexture.chooseEGLConfig(this.display);
        this.context = EGLSurfaceTexture.createEGLContext(this.display, config, secureMode);
        this.surface = EGLSurfaceTexture.createEGLSurface(this.display, config, this.context, secureMode);
        EGLSurfaceTexture.generateTextureIds(this.textureIdHolder);
        this.texture = new SurfaceTexture(this.textureIdHolder[0]);
        this.texture.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
    }

    public void release() {
        this.handler.removeCallbacks((Runnable)this);
        try {
            if (this.texture != null) {
                this.texture.release();
                GLES20.glDeleteTextures((int)1, (int[])this.textureIdHolder, (int)0);
            }
        }
        finally {
            if (this.display != null && !this.display.equals((Object)EGL14.EGL_NO_DISPLAY)) {
                EGL14.eglMakeCurrent((EGLDisplay)this.display, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLContext)EGL14.EGL_NO_CONTEXT);
            }
            if (this.surface != null && !this.surface.equals((Object)EGL14.EGL_NO_SURFACE)) {
                EGL14.eglDestroySurface((EGLDisplay)this.display, (EGLSurface)this.surface);
            }
            if (this.context != null) {
                EGL14.eglDestroyContext((EGLDisplay)this.display, (EGLContext)this.context);
            }
            if (Util.SDK_INT >= 19) {
                EGL14.eglReleaseThread();
            }
            if (this.display != null && !this.display.equals((Object)EGL14.EGL_NO_DISPLAY)) {
                EGL14.eglTerminate((EGLDisplay)this.display);
            }
            this.display = null;
            this.context = null;
            this.surface = null;
            this.texture = null;
        }
    }

    public SurfaceTexture getSurfaceTexture() {
        return Assertions.checkNotNull(this.texture);
    }

    public void onFrameAvailable(SurfaceTexture surfaceTexture) {
        this.handler.post((Runnable)this);
    }

    @Override
    public void run() {
        this.dispatchOnFrameAvailable();
        if (this.texture != null) {
            try {
                this.texture.updateTexImage();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    private void dispatchOnFrameAvailable() {
        if (this.callback != null) {
            this.callback.onFrameAvailable();
        }
    }

    private static EGLDisplay getDefaultDisplay() {
        EGLDisplay display = EGL14.eglGetDisplay((int)0);
        if (display == null) {
            throw new GlException("eglGetDisplay failed");
        }
        int[] version = new int[2];
        boolean eglInitialized = EGL14.eglInitialize((EGLDisplay)display, (int[])version, (int)0, (int[])version, (int)1);
        if (!eglInitialized) {
            throw new GlException("eglInitialize failed");
        }
        return display;
    }

    private static EGLConfig chooseEGLConfig(EGLDisplay display) {
        EGLConfig[] configs = new EGLConfig[1];
        int[] numConfigs = new int[1];
        boolean success = EGL14.eglChooseConfig((EGLDisplay)display, (int[])EGL_CONFIG_ATTRIBUTES, (int)0, (EGLConfig[])configs, (int)0, (int)1, (int[])numConfigs, (int)0);
        if (!success || numConfigs[0] <= 0 || configs[0] == null) {
            throw new GlException(Util.formatInvariant("eglChooseConfig failed: success=%b, numConfigs[0]=%d, configs[0]=%s", success, numConfigs[0], configs[0]));
        }
        return configs[0];
    }

    private static EGLContext createEGLContext(EGLDisplay display, EGLConfig config, int secureMode) {
        int[] glAttributes = secureMode == 0 ? new int[]{12440, 2, 12344} : new int[]{12440, 2, 12992, 1, 12344};
        EGLContext context = EGL14.eglCreateContext((EGLDisplay)display, (EGLConfig)config, (EGLContext)EGL14.EGL_NO_CONTEXT, (int[])glAttributes, (int)0);
        if (context == null) {
            throw new GlException("eglCreateContext failed");
        }
        return context;
    }

    private static EGLSurface createEGLSurface(EGLDisplay display, EGLConfig config, EGLContext context, int secureMode) {
        EGLSurface surface;
        if (secureMode == 1) {
            surface = EGL14.EGL_NO_SURFACE;
        } else {
            int[] pbufferAttributes = secureMode == 2 ? new int[]{12375, 1, 12374, 1, 12992, 1, 12344} : new int[]{12375, 1, 12374, 1, 12344};
            surface = EGL14.eglCreatePbufferSurface((EGLDisplay)display, (EGLConfig)config, (int[])pbufferAttributes, (int)0);
            if (surface == null) {
                throw new GlException("eglCreatePbufferSurface failed");
            }
        }
        boolean eglMadeCurrent = EGL14.eglMakeCurrent((EGLDisplay)display, (EGLSurface)surface, (EGLSurface)surface, (EGLContext)context);
        if (!eglMadeCurrent) {
            throw new GlException("eglMakeCurrent failed");
        }
        return surface;
    }

    private static void generateTextureIds(int[] textureIdHolder) {
        GLES20.glGenTextures((int)1, (int[])textureIdHolder, (int)0);
        GlUtil.checkGlError();
    }

    public static final class GlException
    extends RuntimeException {
        private GlException(String msg) {
            super(msg);
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SecureMode {
    }

    public static interface TextureImageListener {
        public void onFrameAvailable();
    }
}

