/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.util;

import android.content.Context;
import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLSurface;
import android.opengl.GLES20;
import android.opengl.GLU;
import androidx.annotation.DoNotInline;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Map;

public final class GlUtil {
    public static boolean glAssertionsEnabled = false;
    public static final int RECTANGLE_VERTICES_COUNT = 4;
    private static final String TAG = "GlUtil";
    private static final String EXTENSION_PROTECTED_CONTENT = "EGL_EXT_protected_content";
    private static final String EXTENSION_SURFACELESS_CONTEXT = "EGL_KHR_surfaceless_context";
    private static final int GL_SAMPLER_EXTERNAL_2D_Y2Y_EXT = 35815;
    private static final int EGL_GL_COLORSPACE_KHR = 12445;
    private static final int EGL_GL_COLORSPACE_BT2020_PQ_EXT = 13120;
    private static final int[] EGL_WINDOW_SURFACE_ATTRIBUTES_NONE = new int[]{12344};
    private static final int[] EGL_WINDOW_SURFACE_ATTRIBUTES_BT2020_PQ = new int[]{12445, 13120, 12344};
    private static final int[] EGL_CONFIG_ATTRIBUTES_RGBA_8888 = new int[]{12352, 4, 12324, 8, 12323, 8, 12322, 8, 12321, 8, 12325, 0, 12326, 0, 12344};
    private static final int[] EGL_CONFIG_ATTRIBUTES_RGBA_1010102 = new int[]{12352, 4, 12324, 10, 12323, 10, 12322, 10, 12321, 2, 12325, 0, 12326, 0, 12344};

    private GlUtil() {
    }

    public static float[] getNormalizedCoordinateBounds() {
        return new float[]{-1.0f, -1.0f, 0.0f, 1.0f, 1.0f, -1.0f, 0.0f, 1.0f, -1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f};
    }

    public static float[] getTextureCoordinateBounds() {
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f};
    }

    public static boolean isProtectedContentExtensionSupported(Context context) {
        if (Util.SDK_INT < 24) {
            return false;
        }
        if (Util.SDK_INT < 26 && ("samsung".equals(Util.MANUFACTURER) || "XT1650".equals(Util.MODEL))) {
            return false;
        }
        if (Util.SDK_INT < 26 && !context.getPackageManager().hasSystemFeature("android.hardware.vr.high_performance")) {
            return false;
        }
        EGLDisplay display = EGL14.eglGetDisplay((int)0);
        String eglExtensions = EGL14.eglQueryString((EGLDisplay)display, (int)12373);
        return eglExtensions != null && eglExtensions.contains(EXTENSION_PROTECTED_CONTENT);
    }

    public static boolean isSurfacelessContextExtensionSupported() {
        if (Util.SDK_INT < 17) {
            return false;
        }
        EGLDisplay display = EGL14.eglGetDisplay((int)0);
        String eglExtensions = EGL14.eglQueryString((EGLDisplay)display, (int)12373);
        return eglExtensions != null && eglExtensions.contains(EXTENSION_SURFACELESS_CONTEXT);
    }

    @RequiresApi(value=17)
    public static EGLDisplay createEglDisplay() {
        return Api17.createEglDisplay();
    }

    @RequiresApi(value=17)
    public static EGLContext createEglContext(EGLDisplay eglDisplay) {
        return Api17.createEglContext(eglDisplay, 2, EGL_CONFIG_ATTRIBUTES_RGBA_8888);
    }

    @RequiresApi(value=17)
    public static EGLContext createEglContextEs3Rgba1010102(EGLDisplay eglDisplay) {
        return Api17.createEglContext(eglDisplay, 3, EGL_CONFIG_ATTRIBUTES_RGBA_1010102);
    }

    @RequiresApi(value=17)
    public static EGLSurface getEglSurface(EGLDisplay eglDisplay, Object surface) {
        return Api17.getEglSurface(eglDisplay, surface, EGL_CONFIG_ATTRIBUTES_RGBA_8888, EGL_WINDOW_SURFACE_ATTRIBUTES_NONE);
    }

    @RequiresApi(value=17)
    public static EGLSurface getEglSurfaceBt2020Pq(EGLDisplay eglDisplay, Object surface) {
        return Api17.getEglSurface(eglDisplay, surface, EGL_CONFIG_ATTRIBUTES_RGBA_1010102, EGL_WINDOW_SURFACE_ATTRIBUTES_BT2020_PQ);
    }

    public static void checkGlError() {
        int error;
        int lastError = 0;
        while ((error = GLES20.glGetError()) != 0) {
            String string = String.valueOf(GLU.gluErrorString((int)error));
            Log.e(TAG, string.length() != 0 ? "glError: ".concat(string) : new String("glError: "));
            lastError = error;
        }
        if (lastError != 0) {
            String string = String.valueOf(GLU.gluErrorString((int)lastError));
            GlUtil.throwGlException(string.length() != 0 ? "glError: ".concat(string) : new String("glError: "));
        }
    }

    @RequiresApi(value=17)
    public static void focusSurface(EGLDisplay eglDisplay, EGLContext eglContext, EGLSurface surface, int width, int height) {
        Api17.focusSurface(eglDisplay, eglContext, surface, width, height);
    }

    public static void deleteTexture(int textureId) {
        GLES20.glDeleteTextures((int)1, (int[])new int[]{textureId}, (int)0);
        GlUtil.checkGlError();
    }

    @RequiresApi(value=17)
    public static void destroyEglContext(@Nullable EGLDisplay eglDisplay, @Nullable EGLContext eglContext) {
        Api17.destroyEglContext(eglDisplay, eglContext);
    }

    public static FloatBuffer createBuffer(float[] data) {
        return (FloatBuffer)GlUtil.createBuffer(data.length).put(data).flip();
    }

    public static FloatBuffer createBuffer(int capacity) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(capacity * 4);
        return byteBuffer.order(ByteOrder.nativeOrder()).asFloatBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadAsset(Context context, String assetPath) throws IOException {
        String string;
        InputStream inputStream = null;
        try {
            inputStream = context.getAssets().open(assetPath);
            string = Util.fromUtf8Bytes(Util.toByteArray(inputStream));
        }
        catch (Throwable throwable) {
            Util.closeQuietly(inputStream);
            throw throwable;
        }
        Util.closeQuietly(inputStream);
        return string;
    }

    public static int createExternalTexture() {
        int[] texId = new int[1];
        GLES20.glGenTextures((int)1, (IntBuffer)IntBuffer.wrap(texId));
        GLES20.glBindTexture((int)36197, (int)texId[0]);
        GLES20.glTexParameteri((int)36197, (int)10241, (int)9729);
        GLES20.glTexParameteri((int)36197, (int)10240, (int)9729);
        GLES20.glTexParameteri((int)36197, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)36197, (int)10243, (int)33071);
        GlUtil.checkGlError();
        return texId[0];
    }

    private static void addShader(int programId, int type, String glsl) {
        int shader = GLES20.glCreateShader((int)type);
        GLES20.glShaderSource((int)shader, (String)glsl);
        GLES20.glCompileShader((int)shader);
        int[] result = new int[]{0};
        GLES20.glGetShaderiv((int)shader, (int)35713, (int[])result, (int)0);
        if (result[0] != 1) {
            String string = GLES20.glGetShaderInfoLog((int)shader);
            GlUtil.throwGlException(new StringBuilder(10 + String.valueOf(string).length() + String.valueOf(glsl).length()).append(string).append(", source: ").append(glsl).toString());
        }
        GLES20.glAttachShader((int)programId, (int)shader);
        GLES20.glDeleteShader((int)shader);
        GlUtil.checkGlError();
    }

    private static int getAttributeLocation(int programId, String attributeName) {
        return GLES20.glGetAttribLocation((int)programId, (String)attributeName);
    }

    private static int getUniformLocation(int programId, String uniformName) {
        return GLES20.glGetUniformLocation((int)programId, (String)uniformName);
    }

    private static void throwGlException(String errorMsg) {
        Log.e(TAG, errorMsg);
        if (glAssertionsEnabled) {
            throw new GlException(errorMsg);
        }
    }

    private static void checkEglException(boolean expression, String errorMessage) {
        if (!expression) {
            GlUtil.throwGlException(errorMessage);
        }
    }

    private static int strlen(byte[] strVal) {
        for (int i = 0; i < strVal.length; ++i) {
            if (strVal[i] != 0) continue;
            return i;
        }
        return strVal.length;
    }

    @RequiresApi(value=17)
    private static final class Api17 {
        private Api17() {
        }

        @DoNotInline
        public static EGLDisplay createEglDisplay() {
            EGLDisplay eglDisplay = EGL14.eglGetDisplay((int)0);
            GlUtil.checkEglException(!eglDisplay.equals((Object)EGL14.EGL_NO_DISPLAY), "No EGL display.");
            if (!EGL14.eglInitialize((EGLDisplay)eglDisplay, (int[])new int[1], (int)0, (int[])new int[1], (int)0)) {
                GlUtil.throwGlException("Error in eglInitialize.");
            }
            GlUtil.checkGlError();
            return eglDisplay;
        }

        @DoNotInline
        public static EGLContext createEglContext(EGLDisplay eglDisplay, int version, int[] configAttributes) {
            int[] contextAttributes = new int[]{12440, version, 12344};
            EGLContext eglContext = EGL14.eglCreateContext((EGLDisplay)eglDisplay, (EGLConfig)Api17.getEglConfig(eglDisplay, configAttributes), (EGLContext)EGL14.EGL_NO_CONTEXT, (int[])contextAttributes, (int)0);
            if (eglContext == null) {
                EGL14.eglTerminate((EGLDisplay)eglDisplay);
                GlUtil.throwGlException(new StringBuilder(103).append("eglCreateContext() failed to create a valid context. The device may not support EGL version ").append(version).toString());
            }
            GlUtil.checkGlError();
            return eglContext;
        }

        @DoNotInline
        public static EGLSurface getEglSurface(EGLDisplay eglDisplay, Object surface, int[] configAttributes, int[] windowSurfaceAttributes) {
            return EGL14.eglCreateWindowSurface((EGLDisplay)eglDisplay, (EGLConfig)Api17.getEglConfig(eglDisplay, configAttributes), (Object)surface, (int[])windowSurfaceAttributes, (int)0);
        }

        @DoNotInline
        public static void focusSurface(EGLDisplay eglDisplay, EGLContext eglContext, EGLSurface surface, int width, int height) {
            int[] boundFrameBuffer = new int[1];
            GLES20.glGetIntegerv((int)36006, (int[])boundFrameBuffer, (int)0);
            int defaultFrameBuffer = 0;
            if (boundFrameBuffer[0] != defaultFrameBuffer) {
                GLES20.glBindFramebuffer((int)36160, (int)defaultFrameBuffer);
            }
            EGL14.eglMakeCurrent((EGLDisplay)eglDisplay, (EGLSurface)surface, (EGLSurface)surface, (EGLContext)eglContext);
            GLES20.glViewport((int)0, (int)0, (int)width, (int)height);
        }

        @DoNotInline
        public static void destroyEglContext(@Nullable EGLDisplay eglDisplay, @Nullable EGLContext eglContext) {
            if (eglDisplay == null) {
                return;
            }
            EGL14.eglMakeCurrent((EGLDisplay)eglDisplay, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLContext)EGL14.EGL_NO_CONTEXT);
            int error = EGL14.eglGetError();
            int n = error;
            GlUtil.checkEglException(error == 12288, new StringBuilder(36).append("Error releasing context: ").append(n).toString());
            if (eglContext != null) {
                EGL14.eglDestroyContext((EGLDisplay)eglDisplay, (EGLContext)eglContext);
                error = EGL14.eglGetError();
                n = error;
                GlUtil.checkEglException(error == 12288, new StringBuilder(37).append("Error destroying context: ").append(n).toString());
            }
            EGL14.eglReleaseThread();
            error = EGL14.eglGetError();
            n = error;
            GlUtil.checkEglException(error == 12288, new StringBuilder(35).append("Error releasing thread: ").append(n).toString());
            EGL14.eglTerminate((EGLDisplay)eglDisplay);
            error = EGL14.eglGetError();
            n = error;
            GlUtil.checkEglException(error == 12288, new StringBuilder(38).append("Error terminating display: ").append(n).toString());
        }

        @DoNotInline
        private static EGLConfig getEglConfig(EGLDisplay eglDisplay, int[] attributes) {
            EGLConfig[] eglConfigs = new EGLConfig[1];
            if (!EGL14.eglChooseConfig((EGLDisplay)eglDisplay, (int[])attributes, (int)0, (EGLConfig[])eglConfigs, (int)0, (int)1, (int[])new int[1], (int)0)) {
                GlUtil.throwGlException("eglChooseConfig failed.");
            }
            return eglConfigs[0];
        }
    }

    private static final class Uniform {
        public final String name;
        private final int location;
        private final int type;
        private final float[] value;
        private int texId;
        private int unit;

        public static Uniform create(int programId, int index) {
            int[] length = new int[1];
            GLES20.glGetProgramiv((int)programId, (int)35719, (int[])length, (int)0);
            int[] type = new int[1];
            byte[] nameBytes = new byte[length[0]];
            GLES20.glGetActiveUniform((int)programId, (int)index, (int)length[0], (int[])new int[1], (int)0, (int[])new int[1], (int)0, (int[])type, (int)0, (byte[])nameBytes, (int)0);
            String name = new String(nameBytes, 0, GlUtil.strlen(nameBytes));
            int location = GlUtil.getUniformLocation(programId, name);
            return new Uniform(name, location, type[0]);
        }

        private Uniform(String name, int location, int type) {
            this.name = name;
            this.location = location;
            this.type = type;
            this.value = new float[16];
        }

        public void setSamplerTexId(int texId, int unit) {
            this.texId = texId;
            this.unit = unit;
        }

        public void setFloat(float value) {
            this.value[0] = value;
        }

        public void setFloats(float[] value) {
            System.arraycopy(value, 0, this.value, 0, value.length);
        }

        public void bind() {
            if (this.type == 5126) {
                GLES20.glUniform1fv((int)this.location, (int)1, (float[])this.value, (int)0);
                GlUtil.checkGlError();
                return;
            }
            if (this.type == 35675) {
                GLES20.glUniformMatrix3fv((int)this.location, (int)1, (boolean)false, (float[])this.value, (int)0);
                GlUtil.checkGlError();
                return;
            }
            if (this.type == 35676) {
                GLES20.glUniformMatrix4fv((int)this.location, (int)1, (boolean)false, (float[])this.value, (int)0);
                GlUtil.checkGlError();
                return;
            }
            if (this.texId == 0) {
                throw new IllegalStateException("No call to setSamplerTexId() before bind.");
            }
            GLES20.glActiveTexture((int)(33984 + this.unit));
            if (this.type == 36198 || this.type == 35815) {
                GLES20.glBindTexture((int)36197, (int)this.texId);
            } else if (this.type == 35678) {
                GLES20.glBindTexture((int)3553, (int)this.texId);
            } else {
                int n = this.type;
                throw new IllegalStateException(new StringBuilder(36).append("Unexpected uniform type: ").append(n).toString());
            }
            GLES20.glUniform1i((int)this.location, (int)this.unit);
            GLES20.glTexParameteri((int)3553, (int)10240, (int)9729);
            GLES20.glTexParameteri((int)3553, (int)10241, (int)9729);
            GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
            GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
            GlUtil.checkGlError();
        }
    }

    private static final class Attribute {
        public final String name;
        private final int index;
        private final int location;
        @Nullable
        private Buffer buffer;
        private int size;

        public static Attribute create(int programId, int index) {
            int[] length = new int[1];
            GLES20.glGetProgramiv((int)programId, (int)35722, (int[])length, (int)0);
            byte[] nameBytes = new byte[length[0]];
            GLES20.glGetActiveAttrib((int)programId, (int)index, (int)length[0], (int[])new int[1], (int)0, (int[])new int[1], (int)0, (int[])new int[1], (int)0, (byte[])nameBytes, (int)0);
            String name = new String(nameBytes, 0, GlUtil.strlen(nameBytes));
            int location = GlUtil.getAttributeLocation(programId, name);
            return new Attribute(name, index, location);
        }

        private Attribute(String name, int index, int location) {
            this.name = name;
            this.index = index;
            this.location = location;
        }

        public void setBuffer(float[] buffer, int size) {
            this.buffer = GlUtil.createBuffer(buffer);
            this.size = size;
        }

        public void bind() {
            Buffer buffer = Assertions.checkNotNull(this.buffer, "call setBuffer before bind");
            GLES20.glBindBuffer((int)34962, (int)0);
            GLES20.glVertexAttribPointer((int)this.location, (int)this.size, (int)5126, (boolean)false, (int)0, (Buffer)buffer);
            GLES20.glEnableVertexAttribArray((int)this.index);
            GlUtil.checkGlError();
        }
    }

    public static final class Program {
        private final int programId = GLES20.glCreateProgram();
        private final Attribute[] attributes;
        private final Uniform[] uniforms;
        private final Map<String, Attribute> attributeByName;
        private final Map<String, Uniform> uniformByName;

        public Program(Context context, String vertexShaderFilePath, String fragmentShaderFilePath) throws IOException {
            this(GlUtil.loadAsset(context, vertexShaderFilePath), GlUtil.loadAsset(context, fragmentShaderFilePath));
        }

        public Program(String vertexShaderGlsl, String fragmentShaderGlsl) {
            GlUtil.checkGlError();
            GlUtil.addShader(this.programId, 35633, vertexShaderGlsl);
            GlUtil.addShader(this.programId, 35632, fragmentShaderGlsl);
            GLES20.glLinkProgram((int)this.programId);
            int[] linkStatus = new int[]{0};
            GLES20.glGetProgramiv((int)this.programId, (int)35714, (int[])linkStatus, (int)0);
            if (linkStatus[0] != 1) {
                String string = String.valueOf(GLES20.glGetProgramInfoLog((int)this.programId));
                GlUtil.throwGlException(string.length() != 0 ? "Unable to link shader program: \n".concat(string) : new String("Unable to link shader program: \n"));
            }
            GLES20.glUseProgram((int)this.programId);
            this.attributeByName = new HashMap<String, Attribute>();
            int[] attributeCount = new int[1];
            GLES20.glGetProgramiv((int)this.programId, (int)35721, (int[])attributeCount, (int)0);
            this.attributes = new Attribute[attributeCount[0]];
            for (int i = 0; i < attributeCount[0]; ++i) {
                Attribute attribute;
                this.attributes[i] = attribute = Attribute.create(this.programId, i);
                this.attributeByName.put(attribute.name, attribute);
            }
            this.uniformByName = new HashMap<String, Uniform>();
            int[] uniformCount = new int[1];
            GLES20.glGetProgramiv((int)this.programId, (int)35718, (int[])uniformCount, (int)0);
            this.uniforms = new Uniform[uniformCount[0]];
            for (int i = 0; i < uniformCount[0]; ++i) {
                Uniform uniform;
                this.uniforms[i] = uniform = Uniform.create(this.programId, i);
                this.uniformByName.put(uniform.name, uniform);
            }
            GlUtil.checkGlError();
        }

        public void use() {
            GLES20.glUseProgram((int)this.programId);
            GlUtil.checkGlError();
        }

        public void delete() {
            GLES20.glDeleteProgram((int)this.programId);
            GlUtil.checkGlError();
        }

        public int getAttributeArrayLocationAndEnable(String attributeName) {
            int location = this.getAttributeLocation(attributeName);
            GLES20.glEnableVertexAttribArray((int)location);
            GlUtil.checkGlError();
            return location;
        }

        private int getAttributeLocation(String attributeName) {
            return GlUtil.getAttributeLocation(this.programId, attributeName);
        }

        public int getUniformLocation(String uniformName) {
            return GlUtil.getUniformLocation(this.programId, uniformName);
        }

        public void setBufferAttribute(String name, float[] values, int size) {
            Assertions.checkNotNull(this.attributeByName.get(name)).setBuffer(values, size);
        }

        public void setSamplerTexIdUniform(String name, int texId, int unit) {
            Assertions.checkNotNull(this.uniformByName.get(name)).setSamplerTexId(texId, unit);
        }

        public void setFloatUniform(String name, float value) {
            Assertions.checkNotNull(this.uniformByName.get(name)).setFloat(value);
        }

        public void setFloatsUniform(String name, float[] value) {
            Assertions.checkNotNull(this.uniformByName.get(name)).setFloats(value);
        }

        public void bindAttributesAndUniforms() {
            for (Attribute attribute : this.attributes) {
                attribute.bind();
            }
            for (Uniform uniform : this.uniforms) {
                uniform.bind();
            }
        }
    }

    public static final class GlException
    extends RuntimeException {
        public GlException(String message) {
            super(message);
        }
    }
}

